/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.util;

import com.dassault.cecilia.dbobj.fmea.Messages;
import java.util.Vector;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class TableColumnVisibilitySelectableModel
extends DefaultTableColumnModel {
    protected Vector allColumns = new Vector();

    @Override
    public void addColumn(TableColumn aColumn) {
        super.addColumn(aColumn);
        this.allColumns.add(aColumn);
    }

    @Override
    public void removeColumn(TableColumn column) {
        super.removeColumn(column);
        this.allColumns.remove(column);
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        super.moveColumn(columnIndex, newIndex);
        Object column = this.tableColumns.get(newIndex);
        int index = this.allColumns.indexOf(column);
        if (newIndex == 0) {
            Object nextColumn = this.tableColumns.get(1);
            int nextIndex = this.allColumns.indexOf(nextColumn);
            this.allColumns.remove(index);
            this.allColumns.insertElementAt(column, nextIndex - 1);
        } else {
            Object previousColumn = this.tableColumns.get(newIndex - 1);
            int indexAfter = this.allColumns.indexOf(previousColumn) + 1;
            this.allColumns.remove(index);
            if (index >= indexAfter) {
                this.allColumns.insertElementAt(column, indexAfter);
            } else {
                this.allColumns.insertElementAt(column, indexAfter - 1);
            }
        }
    }

    public void setColumnVisible(Object identifier, boolean visible, boolean notify) {
        int index = -1;
        try {
            index = super.getColumnIndex(identifier);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (visible) {
            if (index != -1) {
                return;
            }
            TableColumn column = null;
            int ind = 0;
            boolean found = false;
            for (int i = 0; i < this.allColumns.size(); ++i) {
                column = (TableColumn)this.allColumns.get(i);
                if (column.getIdentifier().equals(identifier)) {
                    found = true;
                    break;
                }
                if (!this.tableColumns.contains(column)) continue;
                ++ind;
            }
            if (!found) {
                throw new IllegalArgumentException(Messages.getString("TableColumnVisibilitySelectableModel.0"));
            }
            if (column == null) {
                throw new IllegalArgumentException(Messages.getString("TableColumnVisibilitySelectableModel.1"));
            }
            this.tableColumns.insertElementAt(column, ind);
            column.addPropertyChangeListener(this);
            this.totalColumnWidth = -1;
            if (notify) {
                this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
            }
        } else {
            if (index == -1) {
                return;
            }
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(index, index);
            }
            TableColumn column = (TableColumn)this.tableColumns.get(index);
            column.removePropertyChangeListener(this);
            this.tableColumns.removeElementAt(index);
            this.totalColumnWidth = -1;
            if (notify) {
                this.fireColumnRemoved(new TableColumnModelEvent(this, index, 0));
            }
        }
    }
}

