/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderList;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderListTransferable;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderSelectUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.faulttree.egli.EGLICmdGenerate;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdWithError;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.io.imports.UtilityConvertID;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DBFolderCmdPaste
extends DBFolderCmdWithError {
    private static Logger _LOG = Logger.getLogger(DBFolderCmdPaste.class.getPackage().getName());
    DBFolderTreeEditable _ctrlOwner;
    DBUser _dbUser;
    DBFolder _dstFolder;
    ArrayList<DBFolder> _srcFolders;
    boolean _bCutOperation;
    CECFactory _daoFactory;
    DAOFolder _daoFolder;
    private static final String __COPY = "_Copy";
    private static final String __PATTERN_COPY_STR = "(.*)_Copy([0-9]+)";
    private static final Pattern __PATTERN_COPY = Pattern.compile("(.*)_Copy([0-9]+)");

    public DBFolderCmdPaste(CeciliaAppl appl, DBFolderTreeEditable owner, DBFolder dstFolder, DBUser user) {
        super((CAppl)appl, owner);
        this._ctrlOwner = owner;
        this._dstFolder = dstFolder;
        this._dbUser = user;
    }

    @Override
    protected String getTitle() {
        return ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_PASTE");
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    protected void verifyAndRecupObject(List<DBFolder> folders, Set<DBFolder> beenLocked, Set<DBFolder> treats, DAOFolder daoFolder) {
        for (int i = 0; i < folders.size(); ++i) {
            DBFolder dbFolder = folders.get(i);
            if (treats.contains(dbFolder)) continue;
            treats.add(dbFolder);
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = daoFolder.findChildren(dbFolder);
            }
            this.verifyAndRecupObject(children, beenLocked, treats, daoFolder);
            if (dbFolder.getObject() == null) continue;
            if (daoFolder.getAccessRight(dbFolder, this._dbUser) == DBAccess.Right.NONE) {
                this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ACCESS_NO", dbFolder.getRefPath()));
                continue;
            }
            if (!dbFolder.isFreeze() && dbFolder.isLocked()) {
                DBSession dbSession = dbFolder.getObject().getLockedSession();
                this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", dbFolder.getRefPath(), dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~"));
                continue;
            }
            if (!dbFolder.isVersion()) continue;
            beenLocked.add(dbFolder);
        }
    }

    @Override
    protected boolean prepareDo() {
        Transferable transferable = this.getAppl().getLocalClipboard(true).getContents(this);
        if (transferable == null) {
            return false;
        }
        if (!transferable.isDataFlavorSupported(DBFolderListTransferable.DB_FLAVOR)) {
            return false;
        }
        DBFolderList dbFolList = null;
        try {
            dbFolList = (DBFolderList)transferable.getTransferData(DBFolderListTransferable.DB_FLAVOR);
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Probleme avec le presse-papier", e);
        }
        this._srcFolders = new ArrayList<DBFolder>(dbFolList.getFolders());
        this._bCutOperation = dbFolList.isCutOperation();
        if (!this.verifyClipboard()) {
            _LOG.log(Level.WARNING, "CmdPaste: Les donnees du presse-papier ne sont pas compatibles !!");
            return false;
        }
        if (!this._bCutOperation && ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO) {
            try {
                DemoLimits appendLimits = new DemoLimits();
                DemoLimitedFactory daoFactory = (DemoLimitedFactory)this.getAppl().getDAOFactory();
                DAOFolder daoFolder = daoFactory.createFolderDAO();
                for (int i = 0; i < this._srcFolders.size(); ++i) {
                    appendLimits.countModelFromFolder(this._srcFolders.get(i), daoFolder);
                }
                daoFactory.verifyAppendLimits(appendLimits);
            }
            catch (DemoLimitedException e) {
                _LOG.info("DemoLimited " + e.toString());
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.getString("DEMO_ERROR_PASTE"), this.getTitle(), 0);
                return false;
            }
        }
        this._daoFactory = this.getAppl().getDAOFactory();
        this._daoFolder = this._daoFactory.createFolderDAO();
        return true;
    }

    private boolean verifyClipboard() {
        if (this._srcFolders.size() < 1) {
            return false;
        }
        DBFolder src = this._srcFolders.get(0);
        if (src.isVersion()) {
            if (this._bCutOperation) {
                return false;
            }
            if (this._dstFolder.isVersion()) {
                this._dstFolder = this._dstFolder.getParent();
                if (this._dstFolder.isReadOnly()) {
                    return false;
                }
            }
            if (!src.getParent().equals(this._dstFolder)) {
                return false;
            }
        }
        if (src.getFamily() != this._dstFolder.getFamily()) {
            return false;
        }
        int srcDepth = src.getDepthUntilSystem();
        for (int i = 1; i < this._srcFolders.size(); ++i) {
            DBFolder cur = this._srcFolders.get(i);
            if (src.getFamily() != cur.getFamily()) {
                return false;
            }
            if (srcDepth == cur.getDepthUntilSystem()) continue;
            return false;
        }
        int dstDepth = this._dstFolder.getDepthUntilSystem();
        if (dstDepth == srcDepth) {
            this._dstFolder = this._dstFolder.getParent();
            --dstDepth;
            if (this._dstFolder.isReadOnly()) {
                return false;
            }
        }
        return dstDepth == srcDepth - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void firstDo() {
        LinkedHashSet<DBFolder> foldersToLocked = new LinkedHashSet<DBFolder>();
        HashSet<DBFolder> treatsRecup = new HashSet<DBFolder>();
        this.verifyAndRecupObject(this._srcFolders, foldersToLocked, treatsRecup, this.getAppl().getDAOFactory().createFolderDAO());
        if (this.withWarnning()) {
            _LOG.finest("CmdPaste-Phase1: Il y a eu un probleme => affichage de(s) erreur(s)");
            this.displayErrors(this.getErrors());
            return;
        }
        if (this._bCutOperation) {
            for (int i = this._srcFolders.size() - 1; i >= 0; --i) {
                DBFolder curFolder = this._srcFolders.get(i);
                if (this._dstFolder.findChild(curFolder.getName()) == null) continue;
                String msg = ResMsgObj.msgFormat("MSG_FOL_ALREADY_CHILD", curFolder.getName());
                _LOG.finest("CmdPaste-Phase2A: " + msg);
                this.addError(curFolder, msg);
            }
            if (!this.withWarnning()) {
                List<DBFolder> dbAtSelected = this.doPasteFromCut();
                if (!this.withError()) {
                    this.getAppl().refreshDAOFolder(true);
                    if (dbAtSelected != null) {
                        SwingUtilities.invokeLater(new DBFolderSelectUtility((DBFolderTree)this._ctrlOwner, dbAtSelected));
                    }
                }
            }
            this.getAppl().getLocalClipboard(true).setContents(new StringSelection(""), null);
        } else {
            DAOObject daoObject = this.getAppl().getDAOFactory().createObjectDAO();
            DBSession dbSession = this.getAppl().getDBSession();
            ArrayList<DBFolder> foldersLocked = new ArrayList<DBFolder>(foldersToLocked.size());
            try {
                DBFolder dbFolderErrorLock = null;
                for (DBFolder dbFolder : foldersToLocked) {
                    if (dbFolder.getObject() == null) continue;
                    if (daoObject.lock(dbFolder.getObject(), dbSession)) {
                        foldersLocked.add(dbFolder);
                        continue;
                    }
                    dbFolderErrorLock = dbFolder;
                    break;
                }
                if (dbFolderErrorLock != null) {
                    this.addError(dbFolderErrorLock, ResMsgCore.getString("MSG_FOL_DONT_LOCK"));
                } else {
                    List<DBFolder> dbAtSelected = this.doPasteFromCopy();
                    this.getAppl().refreshDAOFolder(true);
                    if (dbAtSelected != null) {
                        SwingUtilities.invokeLater(new DBFolderSelectUtility((DBFolderTree)this._ctrlOwner, dbAtSelected));
                    }
                }
            }
            finally {
                for (DBFolder dbFolder : foldersLocked) {
                    if (dbFolder.getObject() == null || daoObject.unlock(dbFolder.getObject(), dbSession)) continue;
                    this.addError(dbFolder, ResMsgCore.getString("MSG_FOL_DONT_UNLOCK"));
                }
            }
        }
        if (this.withWarnning()) {
            _LOG.finest("CmdPaste-Phase3: Il y a eu un probleme => affichage de(s) erreur(s)");
            this.displayErrors(this.getErrors());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBFolder> doPasteFromCut() {
        block17: {
            try {
                this._daoFactory.createFolderDAO().freezeCache(true);
                this._daoFactory.beginTransaction(true);
                if (this._dstFolder.getChildren() == null) {
                    this._daoFolder.findChildren(this._dstFolder);
                }
                HashSet<DBFolder> parentsFolder = new HashSet<DBFolder>();
                ArrayList<DBFolder> dbAtSelected = new ArrayList<DBFolder>();
                boolean alreadyAbort = false;
                try {
                    _LOG.finest("CmdPaste-Phase2A: Begin Cut");
                    for (int i = 0; i < this._srcFolders.size(); ++i) {
                        DBFolder curFolder = this._srcFolders.get(i);
                        DBFolder parFolder = curFolder.getParent();
                        parFolder.getChildren().remove(curFolder);
                        parentsFolder.add(parFolder);
                        curFolder.setParent(this._dstFolder);
                        this._dstFolder.getChildren().add(curFolder);
                        if (!this._daoFolder.update(curFolder)) {
                            this.addError(curFolder, ResMsgObj.getString("MSG_ERR_DB_FOL_UPDATE"));
                            break;
                        }
                        dbAtSelected.add(curFolder);
                    }
                    if (!this.withError()) {
                        for (DBFolder parFolder : parentsFolder) {
                            if (!this._daoFolder.update(parFolder)) {
                                this.addError(parFolder, ResMsgObj.getString("MSG_ERR_DB_FOL_UPDATE"));
                                break;
                            }
                            parFolder.setMustBeUpdated(true);
                        }
                    }
                    if (!this.withError()) {
                        Collections.sort(this._dstFolder.getChildren(), DBFolder.getComparator());
                        if (!this._daoFolder.update(this._dstFolder)) {
                            this.addError(this._dstFolder, ResMsgObj.getString("MSG_ERR_DB_FOL_UPDATE"));
                        }
                        this._dstFolder.setMustBeUpdated(true);
                    }
                    _LOG.finest("CmdPaste-Phase2A: End Cut");
                }
                catch (Throwable th) {
                    _LOG.log(Level.INFO, "CmdPaste-Phase2A (Throwable)", th);
                    this._daoFactory.abortTransaction();
                    alreadyAbort = true;
                }
                if (this.withError()) {
                    if (!alreadyAbort) {
                        this._daoFactory.abortTransaction();
                    }
                    break block17;
                }
                this._daoFactory.endTransaction();
                ArrayList<DBFolder> arrayList = dbAtSelected;
                return arrayList;
            }
            catch (Exception e) {
                _LOG.log(Level.SEVERE, "Realise-Import | Processus de transition", e);
                this.addError(this._dstFolder, ResMsgObj.getString("MSG_ERR_DB_WARNING"));
            }
            finally {
                this._daoFactory.createFolderDAO().freezeCache(false);
            }
        }
        return null;
    }

    private List<DBFolder> doPasteFromCopy() {
        block24: {
            try {
                this._daoFactory.beginTransaction(true);
                if (this._dstFolder.getChildren() == null) {
                    this._daoFolder.findChildren(this._dstFolder);
                }
                ArrayList<DBFolder> dbAtSelected = new ArrayList<DBFolder>();
                boolean alreadyAbort = false;
                try {
                    _LOG.finest("CmdPaste-Phase2A: Begin Copy");
                    if (this._srcFolders.get(0).isVersion()) {
                        block10: for (int i = 0; i < this._srcFolders.size() && !this._daoFactory.withExceptionDuringTransaction(); ++i) {
                            String dstName;
                            DBFolder srcFolder = this._srcFolders.get(i);
                            DBFolder cpyFolder = this.doPasteVersion(this._dstFolder, srcFolder, dstName = this.findNextVersion(srcFolder));
                            if (cpyFolder == null) continue;
                            dbAtSelected.add(cpyFolder);
                            if (cpyFolder.getFamily() != DBFolder.Family.PROJECT) continue;
                            switch (cpyFolder.getFamilyFlag()) {
                                case 2: 
                                case 3: 
                                case 5: {
                                    if (EGLICmdGenerate.GenerateEGLI(this._daoFactory, cpyFolder)) continue block10;
                                    this.addError(cpyFolder, MsgType.WARNING, ResMsgObj.getString("EGL_MSG_GENERATE_GENERAL"));
                                }
                            }
                        }
                    } else {
                        LinkedHashMap<DBFolder, DBFolder> pasteFoldersWithObject = new LinkedHashMap<DBFolder, DBFolder>();
                        for (int i = 0; i < this._srcFolders.size(); ++i) {
                            DBFolder srcFolder = this._srcFolders.get(i);
                            String dstName = this.findFreeName(srcFolder.getName());
                            if (dstName == null) {
                                this.addError(srcFolder, MsgType.ERROR, ResMsgObj.getString("MSG_ERR_VERIFY_NAME"));
                                continue;
                            }
                            DBFolder cpyFolder = this.doPasteStruct_rec(this._dstFolder, srcFolder, dstName, pasteFoldersWithObject);
                            if (cpyFolder == null) continue;
                            dbAtSelected.add(cpyFolder);
                        }
                        if (pasteFoldersWithObject.size() > 0) {
                            HashMap<Long, Long> mapID = new HashMap<Long, Long>();
                            for (Map.Entry entryFolder : pasteFoldersWithObject.entrySet()) {
                                mapID.put(((DBFolder)entryFolder.getKey()).getID(), ((DBFolder)entryFolder.getValue()).getID());
                            }
                            for (Map.Entry entryFolder : pasteFoldersWithObject.entrySet()) {
                                this.updateXMLStream((DBFolder)entryFolder.getKey(), (DBFolder)entryFolder.getValue(), mapID, pasteFoldersWithObject);
                            }
                            for (DBFolder cpyFolder : pasteFoldersWithObject.values()) {
                                if (cpyFolder.getFamily() != DBFolder.Family.PROJECT) continue;
                                switch (cpyFolder.getFamilyFlag()) {
                                    case 2: 
                                    case 3: 
                                    case 5: {
                                        if (EGLICmdGenerate.GenerateEGLI(this._daoFactory, cpyFolder)) break;
                                        this.addError(cpyFolder, MsgType.WARNING, ResMsgObj.getString("EGL_MSG_GENERATE_GENERAL"));
                                    }
                                }
                            }
                        }
                    }
                    if (!this.withError()) {
                        Collections.sort(this._dstFolder.getChildren(), DBFolder.getComparator());
                        if (!this._daoFolder.update(this._dstFolder)) {
                            this.addError(this._dstFolder, ResMsgObj.getString("MSG_ERR_DB_FOL_UPDATE"));
                        }
                        this._dstFolder.setMustBeUpdated(true);
                    }
                    _LOG.finest("CmdPaste-Phase2A: End Copy");
                }
                catch (Throwable th) {
                    _LOG.log(Level.INFO, "CmdPaste-Phase2A (Throwable)", th);
                    this.addError(this._dstFolder, MsgType.ERROR, ResMsgObj.getString("MSG_ERR_DB_FOL_PASTE_EXCEPTION"));
                    this._daoFactory.abortTransaction();
                    alreadyAbort = true;
                }
                if (this.withError()) {
                    if (!alreadyAbort) {
                        this._daoFactory.abortTransaction();
                    }
                    break block24;
                }
                this._daoFactory.endTransaction();
                return dbAtSelected;
            }
            catch (Exception e) {
                _LOG.log(Level.SEVERE, "CmdPaste-Phase2A | Processus de transition", e);
                this.addError(this._dstFolder, ResMsgObj.getString("MSG_ERR_DB_WARNING"));
            }
        }
        return null;
    }

    private DBFolder doPasteVersion(DBFolder parentFolder, DBFolder srcFolder, String dstName) {
        DBFolder dbCreate;
        Collection<DBRelation> srcRelations;
        DBFolder dstFolder = new DBFolder(parentFolder, this._dbUser);
        dstFolder.setName(dstName);
        dstFolder.setDescription(srcFolder.getDescription());
        dstFolder.setDateCreate(srcFolder.getDateCreate());
        dstFolder.setDateModify(new Date());
        dstFolder.setUserModify(this._dbUser);
        dstFolder.setFlags(srcFolder.getFlags());
        DBObject srcObject = srcFolder.getObject();
        if (srcObject != null) {
            this.createObject(srcFolder, dstFolder, srcObject, true);
        }
        if ((srcRelations = this._daoFactory.createRelationDAO().getDestinationRelations(srcFolder)).size() > 0) {
            ArrayList<DBRelation> dstRelations = new ArrayList<DBRelation>(srcRelations.size());
            for (DBRelation srcRelation : srcRelations) {
                DBRelation dstRelation = new DBRelation(dstFolder, srcRelation.getTypeSource(), srcRelation.getDestination(), srcRelation.getTypeDestination());
                dstRelations.add(dstRelation);
            }
            dstFolder.setRelations(dstRelations);
        }
        if ((dbCreate = this._daoFolder.create(dstFolder)) != null) {
            dbCreate.setMustBeUpdated(true);
        }
        return dbCreate;
    }

    private DBFolder doPasteStruct_rec(DBFolder parentFolder, DBFolder srcFolder, String dstName, Map<DBFolder, DBFolder> pasteFoldersWithObject) {
        DBFolder dbCreate;
        if (this._daoFactory.withExceptionDuringTransaction()) {
            return null;
        }
        DBFolder dstFolder = new DBFolder(parentFolder, this._dbUser);
        dstFolder.setName(dstName);
        dstFolder.setDescription(srcFolder.getDescription());
        dstFolder.setDateCreate(srcFolder.getDateCreate());
        dstFolder.setDateModify(new Date());
        dstFolder.setUserModify(this._dbUser);
        dstFolder.setFlags(srcFolder.getFlags());
        DBObject srcObject = srcFolder.getObject();
        if (srcObject != null) {
            this.createObject(srcFolder, dstFolder, srcObject, false);
        }
        if ((dbCreate = this._daoFolder.create(dstFolder)) != null) {
            List<DBFolder> srcChildren;
            dbCreate.setMustBeUpdated(true);
            if (srcObject != null) {
                pasteFoldersWithObject.put(srcFolder, dbCreate);
            }
            if ((srcChildren = srcFolder.getChildren()) == null) {
                srcChildren = this._daoFolder.findChildren(srcFolder);
            }
            for (int i = 0; i < srcChildren.size(); ++i) {
                DBFolder srcChild = srcChildren.get(i);
                this.doPasteStruct_rec(dbCreate, srcChild, srcChild.getName(), pasteFoldersWithObject);
            }
        } else {
            this.addError(srcFolder, ResMsgObj.getString("MSG_FOL_ERR_CREATE"));
        }
        return dbCreate;
    }

    private boolean createObject(DBFolder srcFolder, DBFolder dstFolder, DBObject srcObject, boolean withoutID) {
        boolean result = false;
        DBObject dstObject = new DBObject();
        dstObject.setFlags(srcObject.getFlags());
        dstObject.unsetBinFlag(2);
        for (DBObjProperty srcObjProp : srcObject.getProperties()) {
            DBObjProperty dstObjProp = new DBObjProperty(srcObjProp);
            dstObjProp.setID(-1L);
            dstObject.addProperty(dstObjProp);
        }
        for (DBObjModel srcObjMod : srcObject.getModels()) {
            String dbFormat = srcObjMod.getFormat();
            if (!withoutID && (dbFormat.equals("XML") || dbFormat.equals("ZML"))) {
                result = true;
                continue;
            }
            DBObjModel dstObjMod = new DBObjModel(srcObjMod);
            dstObjMod.setID(-1L);
            dstObjMod.setStreamToSave(this._daoFactory.createObjModelDAO().getBinaryStream(srcObjMod));
            dstObject.addModel(dstObjMod);
        }
        dstFolder.setObject(dstObject);
        return result;
    }

    private boolean updateXMLStream(DBFolder srcFolder, DBFolder dstFolder, Map<Long, Long> mapID, Map<DBFolder, DBFolder> mapFol) {
        _LOG.finest("CmdPaste | updateXMLStream:" + dstFolder);
        if (this._daoFactory.withExceptionDuringTransaction()) {
            return false;
        }
        try {
            DBObject dstObject = dstFolder.getObject();
            DBObject srcObject = srcFolder.getObject();
            LinkedHashSet<Long> relationSources = new LinkedHashSet<Long>();
            for (DBObjModel srcObjMod : srcObject.getModels()) {
                String dbFormat = srcObjMod.getFormat();
                if (!dbFormat.equals("XML") && !dbFormat.equals("ZML")) continue;
                DBObjModel dstObjMod = new DBObjModel(srcObjMod);
                dstObjMod.setID(-1L);
                dstObject.addModel(dstObjMod);
                UtilityConvertID.convertXMLStream(this._daoFactory.createObjModelDAO(), srcObjMod, dstObjMod, relationSources, mapID, true);
            }
            Collection<DBRelation> srcRelations = this._daoFactory.createRelationDAO().getDestinationRelations(srcFolder);
            if (srcRelations.size() > 0) {
                ArrayList<DBRelation> dstRelations = new ArrayList<DBRelation>(srcRelations.size());
                for (DBRelation srcRelation : srcRelations) {
                    DBFolder dstRelFolder = mapFol.get(srcRelation.getDestination());
                    if (dstRelFolder == null) {
                        dstRelFolder = srcRelation.getDestination();
                    }
                    DBRelation dstRelation = new DBRelation(dstFolder, srcRelation.getTypeSource(), dstRelFolder, srcRelation.getTypeDestination());
                    dstRelations.add(dstRelation);
                }
                dstFolder.setRelations(dstRelations);
            }
            return this._daoFolder.update(dstFolder);
        }
        catch (Throwable th) {
            _LOG.log(Level.WARNING, "CmdPaste | Exception during updateXMLStream:" + dstFolder, th);
            return false;
        }
    }

    private String findFreeName(String name) {
        Matcher match;
        if (this._dstFolder.findChild(name) == null) {
            return name;
        }
        int idx = 1;
        if (__PATTERN_COPY.matcher(name).matches() && (match = __PATTERN_COPY.matcher(name)).find()) {
            name = match.group(1);
            try {
                idx = Integer.parseInt(match.group(2));
            }
            catch (NumberFormatException nfe) {
                _LOG.log(Level.SEVERE, "Probleme de Pattern", nfe);
            }
            if (idx > Short.MAX_VALUE) {
                idx = 1;
            }
        }
        String testName;
        while ((testName = new StringBuilder(name.length() + 10).append(name).append(__COPY).append(idx).toString()).length() <= 248) {
            if (this._dstFolder.findChild(testName) == null) {
                return testName;
            }
            ++idx;
        }
        return null;
    }

    private String findNextVersion(DBFolder srcVersion) {
        if (!srcVersion.isVersion()) {
            return null;
        }
        switch (srcVersion.getFamily()) {
            case BTP_APPLICATION: 
            case BTP_AUTHOR: 
            case BTP_SUBSTANTIATION: {
                return this.findFreeName(srcVersion.getName());
            }
        }
        DBFolder parentFolder = srcVersion.getParent();
        DBFolder lastFolder = DBFactory.findLastVersion(parentFolder);
        if (lastFolder == null) {
            return null;
        }
        return DBFactory.incrementNameVersion(lastFolder);
    }
}

