/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CCmd;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderSelectUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DBFolderCmdRename
extends CCmd {
    private static Logger _LOG = Logger.getLogger(DBFolderCmdRename.class.getPackage().getName());
    protected CAppl _application;
    protected DBFolderTreeEditable _ctrlTree;
    protected DBFolder _dbFolder;
    protected String _newName;

    public DBFolderCmdRename(CAppl appl, DBFolderTreeEditable ctrlTree) {
        super(appl, ctrlTree);
        this._application = appl;
        this._ctrlTree = ctrlTree;
    }

    public DBFolderCmdRename setDBFolder(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
        return this;
    }

    public static boolean canRenameFolder(DBFolder dbFolder) {
        if (dbFolder == null) {
            return false;
        }
        if (dbFolder.isEdited()) {
            return false;
        }
        if (dbFolder.isReadOnly()) {
            return false;
        }
        if (dbFolder.isLocked()) {
            return false;
        }
        if (dbFolder.isFreeze()) {
            return false;
        }
        if (dbFolder.isSystem()) {
            return false;
        }
        if (dbFolder.isModel()) {
            for (DBFolder dbChild : dbFolder.getChildren()) {
                if (dbChild.isEdited()) {
                    return false;
                }
                if (dbChild.isLocked()) {
                    return false;
                }
                if (!dbChild.isFreeze()) continue;
                return false;
            }
        }
        if (dbFolder.isVersion()) {
            switch (dbFolder.getFamily()) {
                case BTP_APPLICATION: 
                case BTP_AUTHOR: 
                case BTP_SUBSTANTIATION: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean prepareDo() {
        boolean valide;
        block4: {
            String oldName;
            if (!DBFolderCmdRename.canRenameFolder(this._dbFolder)) {
                _LOG.finer("Tentative de renommage sur un dossier qui ne le permet pas : " + this._dbFolder.getRefPath());
                return false;
            }
            Container owner = SwingUtilities.getAncestorOfClass(JScrollPane.class, this._ctrlTree);
            this._newName = oldName = this._dbFolder.getName();
            valide = false;
            while (true) {
                this._newName = (String)JOptionPane.showInputDialog(owner, ResMsgVoc.getString("VOC_RENAME_NEW_NAME_DLG"), ResMsgVoc.getString("VOC_RENAME"), 3, null, null, this._newName);
                if (this._newName == null || this._newName.isEmpty() || this._newName.equals(oldName)) break block4;
                if (!DBFactory.verifyName(this._newName, this._dbFolder)) {
                    JOptionPane.showMessageDialog(owner, ResMsgObj.getString("MSG_ERR_VERIFY_NAME"), ResMsgVoc.getString("VOC_RENAME"), 0);
                    continue;
                }
                if (this._newName.equalsIgnoreCase(oldName)) {
                    valide = true;
                    break block4;
                }
                if (this._dbFolder.getParent().findChild(this._newName) == null) break;
                JOptionPane.showMessageDialog(owner, ResMsgObj.msgFormat("MSG_FOL_ALREADY_CHILD", this._newName), ResMsgVoc.getString("VOC_RENAME"), 0);
            }
            valide = true;
        }
        return valide;
    }

    @Override
    protected void firstDo() {
        String oldName = this._dbFolder.getName();
        boolean update = false;
        try {
            this._dbFolder.setName(this._newName);
            update = this.updateDBFolder(this._dbFolder);
        }
        finally {
            if (!update) {
                this._dbFolder.setName(oldName);
            }
        }
    }

    protected boolean updateDBFolder(DBFolder modify) {
        boolean update = false;
        update = this._application.getDAOFactory().createFolderDAO().update(modify);
        if (!update) {
            _LOG.warning("Erreur lors de la mise a jour dans la BdD du dossier : " + modify.toString());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTree), ResMsgObj.msgFormat("MSG_FOL_ERR_CREATE", new Object[0]), this._application.getTitle(), 0);
        } else {
            this._dbFolder.setMustBeUpdated(true);
            this._application.refreshDAOFolder(true);
            EventQueue.invokeLater(new DBFolderSelectUtility((DBFolderTree)this._ctrlTree, this._dbFolder));
        }
        return update;
    }
}

