/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib;

import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AttrCriterion {
    public static AttrCriterion DEFAULT_ATTRCRITERION = new AttrCriterion(new Attr.DefaultKey(AttrType.STRING, "default"), null, null);
    private static Logger _LOG = Logger.getLogger(AttrCriterion.class.getPackage().getName());
    Attr.Key _key;
    String _data;
    Object _util;
    Operator _op;

    public AttrCriterion(AttrCriterion src) {
        this._key = src._key;
        this._op = src._op;
        this._data = src._data;
        this.compilUtil();
    }

    public AttrCriterion getCopy() {
        return new AttrCriterion(this);
    }

    public AttrCriterion(Attr.Key key, Operator op, String data) {
        this._key = key;
        this._op = op;
        this._data = data;
        this.compilUtil();
    }

    private void compilUtil() {
        switch (this.getType()) {
            case STRING: {
                if (this.getOperator() != Operator.MATCH) break;
                try {
                    this._util = Pattern.compile(this._data);
                }
                catch (Exception e) {
                    _LOG.log(Level.INFO, "Critere de recherche avec expression reguliere impossible : " + this._data, e);
                }
                break;
            }
            case NUMBER: {
                this._util = Double.parseDouble(this._data);
            }
        }
    }

    public Attr.Key getKey() {
        return this._key;
    }

    public AttrType getType() {
        return this._key.getType();
    }

    public String getName() {
        return this._key.getName();
    }

    public String getData() {
        return this._data;
    }

    public Operator getOperator() {
        return this._op;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttrCriterion)) {
            return false;
        }
        AttrCriterion other = (AttrCriterion)obj;
        if (this._key.getType() != other._key.getType()) {
            return false;
        }
        if (!this._key.getName().equals(other._key.getName())) {
            return false;
        }
        if (this._key.getType() != AttrType.ALIAS) {
            if (!this._op.equals((Object)other._op)) {
                return false;
            }
            if (!this._data.equals(other._data)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this._key.getType().hashCode();
        hashCode = hashCode * 3 + this._key.getName().hashCode();
        if (this._key.getType() != AttrType.ALIAS) {
            hashCode = hashCode * 5 + this._op.hashCode();
            hashCode = hashCode * 7 + this._data.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        switch (this.getType()) {
            case ALIAS: {
                sb.append(" #");
                break;
            }
            case STRING: {
                sb.append(" ");
                sb.append(this._op.getLabel());
                sb.append(" \"");
                sb.append(this._data);
                sb.append("\"");
                break;
            }
            case ENUM: {
                sb.append(" ");
                sb.append(this._op.getLabel());
                sb.append(" '");
                sb.append(this._data);
                sb.append("'");
                break;
            }
            case NUMBER: {
                sb.append(" ");
                sb.append(this._op.getLabel());
                sb.append(" ");
                sb.append(this._data);
            }
        }
        return sb.toString();
    }

    public boolean match(Attr attr) {
        if (!attr.getKey().equals(this._key)) {
            return false;
        }
        switch (this.getType()) {
            case ALIAS: {
                return true;
            }
            case STRING: {
                switch (this.getOperator()) {
                    case EQ: {
                        return attr.getValue().equals(this._data);
                    }
                    case NEQ: {
                        return !attr.getValue().equals(this._data);
                    }
                    case MATCH: {
                        if (this._util == null) {
                            return false;
                        }
                        return ((Pattern)this._util).matcher(attr.getValue().toString()).matches();
                    }
                }
                break;
            }
            case ENUM: {
                switch (this.getOperator()) {
                    case EQ: {
                        return attr.getValue().equals(this._data);
                    }
                    case NEQ: {
                        return !attr.getValue().equals(this._data);
                    }
                }
                break;
            }
            case NUMBER: {
                try {
                    double attrDbl = Double.parseDouble(attr.getValue().toString());
                    double critDbl = (Double)this._util;
                    switch (this.getOperator()) {
                        case EQ: {
                            return attrDbl == critDbl;
                        }
                        case NEQ: {
                            return attrDbl != critDbl;
                        }
                        case LEQ: {
                            return attrDbl <= critDbl;
                        }
                        case LT: {
                            return attrDbl < critDbl;
                        }
                        case GEQ: {
                            return attrDbl >= critDbl;
                        }
                        case GT: {
                            return attrDbl > critDbl;
                        }
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public void saveToXML(Appendable output) throws IOException {
        output.append(" name='").append(XMLWriter.toXML((String)this.getName())).append("'");
        output.append(" type='").append(XMLWriter.toXML((String)this.getType().toString())).append("'");
        if (this.getType() != AttrType.ALIAS) {
            output.append(" op='").append(XMLWriter.toXML((String)this.getOperator().toString())).append("'");
            output.append(" data='").append(XMLWriter.toXML((String)this.getData())).append("'");
        }
    }

    public static AttrCriterion loadFromXML(Element xmlElt) throws SAXException, IOException {
        String attrName = xmlElt.getAttribute("name");
        String attrType = xmlElt.getAttribute("type");
        AttrType type = AttrType.valueOf(attrType);
        if (type == null) {
            throw new SAXException("Value of attribute 'type' unknown : " + attrType + " !");
        }
        Attr.DefaultKey key = new Attr.DefaultKey(type, attrName);
        if (type != AttrType.ALIAS) {
            String attrOp = xmlElt.getAttribute("op");
            String attrData = xmlElt.getAttribute("data");
            Operator op = Operator.valueOf(attrOp);
            if (op == null) {
                throw new SAXException("Value of attribute 'op' unknown : " + attrOp + " !");
            }
            return new AttrCriterion(key, op, attrData);
        }
        return new AttrCriterion(key, null, null);
    }

    public static enum Operator {
        EQ("=="),
        NEQ("!="),
        LEQ("<="),
        LT("<"),
        GEQ(">="),
        GT(">"),
        MATCH("#");

        String _keyLabel;

        private Operator(String keyLabel) {
            this._keyLabel = keyLabel;
        }

        public String getLabel() {
            return this._keyLabel;
        }
    }
}

