/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.io.DBAttribHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DBAttrib
extends DBWrap
implements Attr.Key {
    private static Logger _LOG = Logger.getLogger(DBAttrib.class.getPackage().getName());
    public static final String PROP_ATTRIBUTE_DEFAULT_NAME = "cecilia.attribute.DefaultName";
    public static final String PROP_ATTRIBUTE_DEFAULT_VALUE = "cecilia.attribute.DefaultValue";
    public static final String PROP_ATTRIBUTE_UNSELECTABLE = "cecilia.attribute.Unselectable";
    AttrType _type = AttrType.ALIAS;
    ArrayList<String> _enums = null;
    private static final String _FORMAT_ENUM = "[^,'`\"]+";
    private static final Pattern _PATTERN_ENUM = Pattern.compile("[^,'`\"]+");
    private static final String _FORMAT_FRB = "([0-3]):(([^,'`\"]+,)+)?";
    private static final Pattern _PATTERN_FRB = Pattern.compile("([0-3]):(([^,'`\"]+,)+)?");

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public DBAttrib(DBFolder folder) {
        super(folder);
    }

    @Override
    public DBAttrib getCopy() {
        DBAttrib dest = new DBAttrib(this._dbFolder);
        dest.copy(this);
        dest._type = this._type;
        if (this._enums != null) {
            dest._enums = new ArrayList<String>(this._enums);
        }
        return dest;
    }

    @Override
    public AttrType getType() {
        return this._type;
    }

    public void setType(AttrType type) {
        this._type = type;
    }

    public ArrayList<String> getEnums() {
        return this._enums;
    }

    public DBAttrib setEnums(Collection<String> enums) {
        this._enums = enums == null ? null : (enums instanceof ArrayList ? (ArrayList<Object>)enums : new ArrayList<String>(enums));
        return this;
    }

    public String toString() {
        return this.getDBFolder().getRefPath();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBAttrib)) {
            return false;
        }
        DBAttrib param = (DBAttrib)obj;
        if (!param.getType().equals((Object)this.getType())) {
            return false;
        }
        if (this._enums == null) {
            return param.getEnums() == null;
        }
        return this._enums.equals(param.getEnums());
    }

    @Override
    public int compareTo(Attr.Key o) {
        int cmp = this._type.ordinal() - o.getType().ordinal();
        if (cmp != 0) {
            return cmp;
        }
        return this.getDBFolder().getRefPath().compareTo(o.getName());
    }

    @Override
    public String getName() {
        return this.getDBFolder().getRefPath();
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.ATTRIBUTE;
    }

    @Override
    protected String getNature() {
        return "attribute";
    }

    public static boolean verifyEnum(String value) {
        return _PATTERN_ENUM.matcher(value).matches();
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        if ("FRB".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            String istr = DAOObjModel.convertWithByteArray(istream);
            if (istr == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                return false;
            }
            return this.readFrb(istr, cecFactory, logMng);
        }
        if ("ZML".equals(format) || "XML".equals(format)) {
            InputStream istream = this.getBinaryStream(model, cecFactory, logMng);
            if (istream == null) {
                return false;
            }
            if ("ZML".equals(format)) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            return this.readXml(istream, cecFactory, logMng);
        }
        logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
        return false;
    }

    private boolean readFrb(String data, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        Matcher matcher = _PATTERN_FRB.matcher(data);
        if (!matcher.matches()) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIB_FRB_FORMAT", data, _FORMAT_FRB));
            return false;
        }
        this._type = AttrType.getType(Integer.parseInt(matcher.group(1)));
        if (this._type == null) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_INTERNAL", "Le type de l'attribut n'a pas ete reconnu : " + data));
            return false;
        }
        if (this._type == AttrType.ENUM) {
            this._enums = new ArrayList();
            String enums = matcher.group(2);
            if (enums != null) {
                StringTokenizer st = new StringTokenizer(enums, ",");
                while (st.hasMoreTokens()) {
                    this._enums.add(st.nextToken());
                }
            }
        } else {
            this._enums = null;
        }
        return true;
    }

    private boolean readXml(InputStream input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        DBAttribHandlerXml saxHanlder = new DBAttribHandlerXml(logMng, null);
        try {
            this.readXml(input, saxHanlder);
            this._type = saxHanlder.getType();
            List<String> enums = saxHanlder.getEnums();
            this._enums = enums != null ? new ArrayList<String>(enums) : null;
            result = true;
        }
        catch (IOException e) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC"));
        }
        return result;
    }

    @Override
    protected void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.attribute");
        DBObjectXmlUtility.appendXML(out.append(" ").append("type").append("='"), this._type.toString().toLowerCase()).append("'");
        out.append(">\n");
        if (this._type == AttrType.ENUM && this._enums != null) {
            for (int i = 0; i < this._enums.size(); ++i) {
                out.append(indent).append("  <").append("attribute.enum");
                DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._enums.get(i)).append("'");
                out.append("/>\n");
            }
        }
        out.append(indent).append("</").append("cec.attribute").append(">\n");
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                String type1 = DBAttrib.this.getType().getLabel();
                String type2 = ((DBAttrib)wrap).getType().getLabel();
                return new CompareResultString(ResMsgVoc.getString("VOC_TYPE"), type1, type2);
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                ArrayList<String> enums1 = DBAttrib.this.getEnums();
                ArrayList<String> enums2 = ((DBAttrib)wrap).getEnums();
                return new CompareResultString(ResMsgVoc.getString("VOC_VALUE"), enums1 != null ? ((Object)enums1).toString() : "", enums2 != null ? ((Object)enums2).toString() : "");
            }
        });
        return list;
    }

    public String validValue(String value) {
        switch (this._type) {
            case ALIAS: {
                if (value == null) {
                    return "";
                }
                if (value.isEmpty()) {
                    return "";
                }
                if (value.equals("true")) {
                    return "";
                }
                if (this.getDBFolder() != null && this.getDBFolder().getParent() != null && value.equals(this.getDBFolder().getParent().getName())) {
                    return "";
                }
                return null;
            }
            case ENUM: {
                if (value != null) {
                    if (this._enums.contains(value)) {
                        return value;
                    }
                    if (value.startsWith("'") && value.endsWith("'") && value.length() > 2 && this._enums.contains(value = value.substring(1, value.length() - 1))) {
                        return value;
                    }
                }
                return null;
            }
            case NUMBER: {
                if (value == null) {
                    return null;
                }
                try {
                    return Double.toString(Double.parseDouble(value));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case STRING: {
                if (value == null) {
                    return null;
                }
                return value;
            }
        }
        return null;
    }

    public Value createInstance(Object value) {
        String strValue = this.validValue(value == null ? "" : value.toString());
        if (strValue == null) {
            return null;
        }
        return new Value(strValue);
    }

    public String correctRAWValue(Object value) {
        if (value == null) {
            return null;
        }
        String strValue = value.toString();
        if (this._type != AttrType.ENUM) {
            return strValue;
        }
        if (this._enums == null || this._enums.isEmpty()) {
            return strValue;
        }
        strValue = strValue.trim();
        for (int i = 0; i < this._enums.size(); ++i) {
            if (!strValue.equalsIgnoreCase(this._enums.get(i))) continue;
            return this._enums.get(i);
        }
        return strValue;
    }

    public static Collection<Value> update(Collection<Value> attribValues, CECFactory cecFactory, DBLogs.DBLogsManager logMng, String name) {
        ArrayList<Value> result = new ArrayList<Value>(attribValues.size());
        for (Value attribValue : attribValues) {
            DBAttrib dbAttrib = (DBAttrib)DBWrap.createOrFind(cecFactory, attribValue.getKey().getDBFolder(), logMng, DBAttrib.class);
            if (dbAttrib == null) continue;
            Value dbValue = dbAttrib.createInstance(attribValue.getValue());
            if (dbValue == null) {
                String definition = new StringBuilder(128).append("'").append(attribValue.getKey().getRefPath()).append("' = ").append(attribValue.getValue()).toString();
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIBS_XML_VALUE", definition, name));
                continue;
            }
            result.add(dbValue);
        }
        return result;
    }

    public class Value
    implements Attr {
        Object _value;

        Value(Object value) {
            this._value = value;
        }

        @Override
        public DBAttrib getKey() {
            return DBAttrib.this;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        public String toString() {
            if (DBAttrib.this.getType() == AttrType.ALIAS) {
                return this.getKey().toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.getKey().toString());
            sb.append("=").append(this._value);
            return sb.toString();
        }

        public String toDisplay() {
            StringBuilder buffer = new StringBuilder(256);
            this.appendDisplay(buffer);
            return buffer.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            if (!this.getKey().equals(other.getKey())) {
                return false;
            }
            if (this._value == null) {
                return other.getValue() == null;
            }
            return this._value.equals(other.getValue());
        }

        public int compareTo(Attr o) {
            int result = this.getKey().compareTo(o.getKey());
            if (result != 0) {
                return result;
            }
            if (this.getKey().getType() == AttrType.ALIAS) {
                return 0;
            }
            if (this._value == null) {
                if (o.getValue() == null) {
                    return 0;
                }
                return -1;
            }
            if (o.getValue() == null) {
                return 1;
            }
            if (this._value instanceof Number && o.getValue() instanceof Number) {
                return Double.compare(((Number)this._value).doubleValue(), ((Number)o.getValue()).doubleValue());
            }
            return this._value.toString().compareTo(o.getValue().toString());
        }

        public void appendDisplay(StringBuilder buf) {
            buf.append("'").append(DBAttrib.this.getDBFolder().getRefPath()).append("'");
            if (this.getKey().getType() != AttrType.ALIAS) {
                buf.append("=").append(this._value);
            }
        }

        public boolean setValue(String value) {
            String valid = DBAttrib.this.validValue(value);
            if (valid == null) {
                return false;
            }
            this._value = valid;
            return true;
        }

        public Value getCopy() {
            return this.getKey().createInstance(this._value);
        }
    }
}

