/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class DBAttribValueDlg
extends JDialogCecilia {
    protected DBAttrib _dbAttribSelect;
    JLabel _ctrlTypeInfo;
    JLabel _ctrlValueAlias;
    JComboBox _ctrlValueEnum;
    JTextField _ctrlValueOther;

    public DBAttribValueDlg(Window win, String title, boolean bMake) {
        super(win, title, true);
        if (bMake) {
            this.make();
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(win));
        }
    }

    protected void make() {
        this._ctrlTypeInfo = new JLabel("ABCDEFGHIJK");
        this._ctrlValueAlias = new JLabel("Aucune valeur");
        this._ctrlValueEnum = new JComboBox();
        this._ctrlValueOther = new JTextField();
        JComponent centerPanel = this.createCenterPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
        this.pack();
    }

    protected abstract boolean appendAttribPanel(JPanel var1, int var2, int var3);

    protected JComponent createCenterPanel() {
        int posY = 0;
        JPanel centerPanel = new JPanel(new GridBagLayout());
        if (this.appendAttribPanel(centerPanel, 0, 0)) {
            ++posY;
        }
        centerPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_TYPE")), new GridBagConstraints(0, posY, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        centerPanel.add((Component)this._ctrlTypeInfo, new GridBagConstraints(1, posY++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        centerPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_VALUE")), new GridBagConstraints(0, posY, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        GridBagConstraints valueConstraint = new GridBagConstraints(1, posY++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        centerPanel.add((Component)this._ctrlValueAlias, valueConstraint);
        centerPanel.add((Component)this._ctrlValueEnum, valueConstraint);
        centerPanel.add((Component)this._ctrlValueOther, valueConstraint);
        return centerPanel;
    }

    protected void changeAttrib(DBAttrib selectAttrib) {
        if (selectAttrib == null) {
            this._ctrlTypeInfo.setText("");
            this._ctrlValueAlias.setVisible(true);
            this._ctrlValueAlias.setEnabled(false);
            this._ctrlValueEnum.setVisible(false);
            this._ctrlValueOther.setVisible(false);
        } else {
            this._ctrlTypeInfo.setText(selectAttrib.getType().getLabel());
            switch (selectAttrib.getType()) {
                case ALIAS: {
                    this._ctrlValueAlias.setVisible(true);
                    this._ctrlValueAlias.setEnabled(false);
                    this._ctrlValueEnum.setVisible(false);
                    this._ctrlValueOther.setVisible(false);
                    break;
                }
                case ENUM: {
                    this._ctrlValueAlias.setVisible(false);
                    this._ctrlValueEnum.setVisible(true);
                    this._ctrlValueOther.setVisible(false);
                    this._ctrlValueEnum.removeAllItems();
                    ArrayList<String> enums = selectAttrib.getEnums();
                    for (int i = 0; i < enums.size(); ++i) {
                        this._ctrlValueEnum.addItem(enums.get(i));
                    }
                    break;
                }
                default: {
                    this._ctrlValueAlias.setVisible(false);
                    this._ctrlValueEnum.setVisible(false);
                    this._ctrlValueOther.setVisible(true);
                    this._ctrlValueOther.setText("");
                }
            }
        }
    }

    @Override
    protected boolean verifyParameters() {
        switch (this._dbAttribSelect.getType()) {
            case ALIAS: {
                return true;
            }
            case FIELD: {
                return false;
            }
            case NUMBER: {
                String strValue = this._ctrlValueOther.getText().trim();
                if (!strValue.isEmpty()) {
                    try {
                        Double.parseDouble(strValue);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this._ctrlValueOther.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlValueOther), ResMsgCore.getString("MSG_ERR_NUMBER_PARSE"), this.getTitle(), 0);
                break;
            }
            case STRING: {
                String strValue = this._ctrlValueOther.getText().trim();
                if (!strValue.isEmpty()) {
                    return true;
                }
                this._ctrlValueOther.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlValueOther), ResMsgCore.getString("MSG_ERR_TEXT_EMPTY"), this.getTitle(), 0);
                break;
            }
            case ENUM: {
                if (this._ctrlValueEnum.getSelectedItem() != null) {
                    return true;
                }
                this._ctrlValueEnum.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlValueEnum), ResMsgCore.getString("MSG_ERR_VALUE_SELECT"), this.getTitle(), 0);
            }
        }
        return false;
    }

    public DBAttrib getSelectAttrib() {
        return this._dbAttribSelect;
    }

    public String getSelectValue() {
        if (this._dbAttribSelect == null) {
            return null;
        }
        switch (this._dbAttribSelect.getType()) {
            case ALIAS: {
                return "";
            }
            case FIELD: {
                return null;
            }
            case NUMBER: {
                return this._ctrlValueOther.getText().trim();
            }
            case STRING: {
                return this._ctrlValueOther.getText();
            }
            case ENUM: {
                return this._ctrlValueEnum.getSelectedItem().toString();
            }
        }
        return null;
    }

    protected void setSelectValue(String value) {
        if (this._dbAttribSelect == null) {
            return;
        }
        if (value == null) {
            return;
        }
        value = value.trim();
        switch (this._dbAttribSelect.getType()) {
            case ENUM: {
                if (this._dbAttribSelect.validValue(value) != null) {
                    this._ctrlValueEnum.setSelectedItem(value);
                    break;
                }
                this._ctrlValueEnum.setSelectedItem(null);
                break;
            }
            case NUMBER: 
            case STRING: {
                if (this._dbAttribSelect.validValue(value) != null) {
                    this._ctrlValueOther.setText(value.trim());
                    break;
                }
                this._ctrlValueOther.setText("");
            }
        }
    }
}

