/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.event.io;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.io.DBAttributesHandlerXml;
import com.dassault.cecilia.dbobj.general.event.Event;
import com.dassault.cecilia.dbobj.general.event.io.EventConstantXml;
import com.dassault.cecilia.dbobj.general.event.io.ParamInspecFlightHandlerXml;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.io.LawHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class EventHandlerXml
extends SAXWrapHandler
implements EventConstantXml {
    private static Logger _LOG = Logger.getLogger(EventHandlerXml.class.getPackage().getName());
    protected CECFactory _daoFactory;
    protected String _name = null;
    protected String _label = null;
    Law _law = null;
    Param _inspected = null;
    Param _inflight = null;
    DBModelLaw _dbModelLaw = null;
    Collection<DBAttrib.Value> _attributes = null;
    protected String _startEltKey = null;
    protected SAXExtendedHandler _childHandler = null;

    protected EventHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory daoFactory) {
        super(manager, locator);
        this._daoFactory = daoFactory;
    }

    protected String readName(String key, Map<String, String> attrs) throws SAXException {
        return this.readName(key, "name", attrs);
    }

    protected String getName() {
        return this._name;
    }

    private String getMsgName() {
        return new StringBuilder(256).append(ResMsgVoc.getString("VOC_EVENT")).append(" ").append(this.getName()).toString();
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._childHandler != null) {
            this._childHandler.startAction(key, attrs, startAction);
        } else if (startAction) {
            this._startEltKey = key;
            this._name = this.readName(key, attrs);
        } else if (!this.startInternalAction(key, attrs)) {
            this.errorElementUnknown(key);
        }
    }

    protected boolean startInternalAction(String key, Map<String, String> attrs) throws SAXException {
        if ("frb".equals(key)) {
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._daoFactory.createFolderDAO(), DBFolder.Family.BTP_MODEL.getRootName(), false);
            if (dbFolder != null && dbFolder.getFamily() != DBFolder.Family.BTP_MODEL) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbFolder.getRefPath(), DBFolder.Family.BTP_MODEL}), this.getLocator()));
                dbFolder = null;
            }
            if (dbFolder != null) {
                DBWrap dbWrap = this._daoFactory.findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_XML_MODEL_EVENT_READ", dbFolder.getRefPath()), this.getLocator()));
                } else {
                    this._dbModelLaw = (DBModelLaw)dbWrap;
                }
            }
        } else if ("law".equals(key)) {
            this._childHandler = new LawHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory, this._daoFactory.getLawManager()){

                @Override
                protected String getOwnerObject() {
                    return EventHandlerXml.this.getMsgName();
                }
            };
            this._childHandler.startAction(key, attrs, true);
        } else if ("inspected".equals(key)) {
            this._childHandler = new ParamInspecFlightHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory, this._daoFactory.getLawManager()){

                @Override
                protected String getOwnerObject() {
                    return EventHandlerXml.this.getMsgName();
                }
            };
            this._childHandler.startAction(key, attrs, true);
        } else if ("inflight".equals(key)) {
            this._childHandler = new ParamInspecFlightHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory, this._daoFactory.getLawManager()){

                @Override
                protected String getOwnerObject() {
                    return EventHandlerXml.this.getMsgName();
                }
            };
            this._childHandler.startAction(key, attrs, true);
        } else if ("attributes".equals(key)) {
            this._childHandler = new DBAttributesHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory, this.getName());
            this._childHandler.startAction(key, attrs, true);
        } else if (!"label".equals(key)) {
            return false;
        }
        return true;
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._childHandler != null) {
            boolean result = this._childHandler.endAction(key, attrs, txt);
            if (result) {
                if ("law".equals(key)) {
                    this._law = ((LawHandlerXml)this._childHandler).getLaw();
                } else if ("inspected".equals(key)) {
                    this._inspected = ((ParamInspecFlightHandlerXml)this._childHandler).getParam();
                } else if ("inflight".equals(key)) {
                    this._inflight = ((ParamInspecFlightHandlerXml)this._childHandler).getParam();
                } else if ("attributes".equals(key)) {
                    this._attributes = ((DBAttributesHandlerXml)this._childHandler).getAttributes();
                } else {
                    _LOG.severe("Erreur interne \u00e0 la fermeture de l'\u00e9l\u00e9ment '" + key + "'");
                }
                this._childHandler = null;
            }
            return false;
        }
        if ("label".equals(key)) {
            this._label = txt;
            return false;
        }
        boolean result = this._startEltKey.equals(key);
        if (result) {
            Event evt = this.createEvent();
            this.configureEvent(evt);
        }
        return result;
    }

    protected abstract Event createEvent();

    protected void configureEvent(Event evt) {
        if (this._dbModelLaw != null) {
            evt.setModelLaw(this._dbModelLaw);
        } else if (this._law != null) {
            evt.setOccurrence(this._law);
        }
        if (this._inspected != null) {
            evt.setInspected(this._inspected);
        }
        if (this._inflight != null) {
            evt.setInflightTested(this._inflight);
        }
        if (this._attributes != null) {
            evt.setAttributes(this._attributes);
        }
    }
}

