/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogsDlg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DBLogEditDlg
extends JDialogCecilia {
    JComboBox _ctrlLevel;
    JTextArea _ctrlMsg;
    JLabel _lablUser;
    JLabel _lablDate;
    JTextField _ctrlUser;
    JTextField _ctrlDate;

    DBLogEditDlg(Window owner) {
        super(owner, true);
        this.make();
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    private void make() {
        this._ctrlLevel = new JComboBox();
        this._ctrlLevel.addItem(DBLogs.DBLevel.FINEST);
        this._ctrlLevel.setEditable(false);
        this._ctrlLevel.setRenderer(DBLogs.DBLevel.getListCellRenderer());
        this._ctrlMsg = new JTextArea(5, 120);
        this._lablUser = new JLabel(ResMsgVoc.getString("VOC_USER"));
        this._ctrlUser = new JTextField(12);
        this._ctrlUser.setEnabled(false);
        this._ctrlUser.setEditable(false);
        this._lablDate = new JLabel(ResMsgVoc.getString("VOC_DATE"));
        this._ctrlDate = new JTextField(12);
        this._ctrlDate.setEnabled(false);
        this._ctrlDate.setEditable(false);
        Insets defInset = new Insets(5, 5, 5, 5);
        int row = 0;
        JPanel center = new JPanel(new GridBagLayout());
        center.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        center.add((Component)this._lablDate, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, defInset, 0, 0));
        center.add((Component)this._ctrlDate, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, defInset, 0, 0));
        center.add((Component)this._lablUser, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, defInset, 0, 0));
        center.add((Component)this._ctrlUser, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, defInset, 0, 0));
        center.add((Component)new JLabel(ResMsgVoc.getString("VOC_LEVEL")), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, defInset, 0, 0));
        center.add((Component)this._ctrlLevel, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, defInset, 0, 0));
        center.add((Component)new JLabel(ResMsgVoc.getString("VOC_MESSAGE")), new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, defInset, 0, 0));
        center.add((Component)new JScrollPane(this._ctrlMsg), new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 17, 1, defInset, 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)center, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
    }

    public void prepareDlg(DBLogs.Log dbLog, boolean displayMsg) {
        if (dbLog != null) {
            if (displayMsg) {
                this.setTitle(ResMsgCore.getString("TITLE_LOG_DISPLAY"));
            } else {
                this.setTitle(ResMsgCore.getString("TITLE_LOG_EDIT"));
            }
            this.setLimitLevel(dbLog.getLevel());
            this._ctrlLevel.setSelectedItem((Object)dbLog.getLevel());
            String msg = dbLog.getMessage();
            this._ctrlMsg.setText(msg);
            if (msg.length() > 0) {
                this._ctrlMsg.setCaretPosition(0);
            }
            this._ctrlUser.setText(dbLog.getUser());
            Date date = dbLog.getModif();
            if (date == null) {
                date = dbLog.getCreate();
            }
            this._ctrlDate.setText(DBLogsDlg._formatDate.format(date));
            this._ctrlLevel.setEnabled(!displayMsg);
        } else {
            this.setTitle(ResMsgCore.getString("TITLE_LOG_ADD"));
            this.setLimitLevel(DBLogs.DBLevel.ERROR);
            this._ctrlLevel.setSelectedItem((Object)DBLogs.DBLevel.INFO);
            this._ctrlMsg.setText("");
        }
        boolean readOnly = dbLog != null;
        this._ctrlMsg.setEditable(!readOnly);
        this._ctrlMsg.setForeground(readOnly ? Color.gray : Color.black);
        this._lablDate.setVisible(readOnly);
        this._ctrlDate.setVisible(readOnly);
        this._lablUser.setVisible(readOnly);
        this._ctrlUser.setVisible(readOnly);
    }

    private void setLimitLevel(DBLogs.DBLevel limitLevel) {
        this._ctrlLevel.removeAllItems();
        switch (limitLevel) {
            case ERROR: {
                this._ctrlLevel.addItem(DBLogs.DBLevel.ERROR);
            }
            case WARNING: {
                this._ctrlLevel.addItem(DBLogs.DBLevel.WARNING);
            }
            case INFO: {
                this._ctrlLevel.addItem(DBLogs.DBLevel.INFO);
            }
            case FINE: {
                this._ctrlLevel.addItem(DBLogs.DBLevel.FINE);
            }
            case FINER: {
                this._ctrlLevel.addItem(DBLogs.DBLevel.FINER);
            }
            case FINEST: {
                this._ctrlLevel.addItem(DBLogs.DBLevel.FINEST);
            }
        }
    }

    public DBLogs.DBLevel getLevel() {
        return (DBLogs.DBLevel)((Object)this._ctrlLevel.getSelectedItem());
    }

    public String getMsg() {
        return this._ctrlMsg.getText();
    }

    @Override
    protected boolean verifyParameters() {
        if (this._ctrlMsg.isEditable() && this._ctrlMsg.getText().isEmpty()) {
            this._ctrlMsg.requestFocus();
            return false;
        }
        if (this._ctrlLevel.getSelectedItem() == null) {
            this._ctrlLevel.requestFocus();
            return false;
        }
        return true;
    }
}

