/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa;

import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import java.util.Vector;
import javax.swing.JLabel;

public class UtilOcas {
    public static String validateNameAltaRica(String name, AltaComponent component) {
        ObjectWithName field = null;
        String character = "";
        if (DBFactory.isReservedAltarica(name)) {
            return ResMsgOcas.msgFormat("MODEL_EDIT_RESERVED_WORD", name);
        }
        character = UtilOcas.controlName(name);
        if (character != null) {
            return ResMsgOcas.msgFormat("INFO_INVALID_CHARACTERE", character);
        }
        field = component.getFieldWithName(name);
        if (field != null) {
            if (field instanceof AltaState) {
                return ResMsgOcas.getString("MODEL_EDIT_STATE_ALREADY_EXIST");
            }
            if (field instanceof AltaSynchro) {
                return ResMsgOcas.getString("MODEL_EDIT_NAME_USE_FOR_SYNC");
            }
            if (field instanceof AltaEvent) {
                return ResMsgOcas.getString("MODEL_EDIT_NAME_USE_FOR_EVENT");
            }
            if (field instanceof AltaFlow) {
                return ResMsgOcas.getString("MODEL_EDIT_NAME_USE_FOR_FLOW");
            }
            if (field instanceof AltaSub) {
                return ResMsgOcas.getString("MODEL_EDIT_NAME_USE_FOR_SUB");
            }
        }
        return null;
    }

    public static boolean isLetterOrDigit(char character) {
        switch (character) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return true;
            }
        }
        return false;
    }

    public static String controlName(String name) {
        char[] arrayName = name.toCharArray();
        if (arrayName.length != 0 && Character.isDigit(arrayName[0])) {
            return new String("" + arrayName[0]);
        }
        if (arrayName.length != 0 && Character.isWhitespace(arrayName[arrayName.length - 1])) {
            return "" + arrayName[arrayName.length - 1];
        }
        for (int i = 0; i < arrayName.length; ++i) {
            if (UtilOcas.isLetterOrDigit(arrayName[i]) || arrayName[i] == '_') continue;
            return new String("" + arrayName[i]);
        }
        return null;
    }

    public static void addInAlphabeticOrder(Vector list, JLabel value) {
        if (list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (value.getText().toUpperCase().compareTo(((JLabel)list.elementAt(i)).getText().toUpperCase()) >= 0) continue;
                list.insertElementAt(value, i);
                return;
            }
            list.addElement(value);
        } else {
            list.addElement(value);
        }
    }
}

