/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.ColorButton;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.icon.gui.IconDlgChooser;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.DBIconRenderer;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AltaIconRendererDlg
extends JDialogCecilia {
    private CeciliaAppl _application;
    private DBIcon _currentIcon = null;
    private JLabel _iconLabel = new JLabel(ResMsgOcas.getString("MODEL_EDIT_FILE_ICON") + " : ");
    private JTextField _iconFile = new JTextField("");
    private JButton _selectIconButton = new JButton("...");
    private JCheckBox _drawBorderOption = new JCheckBox(ResMsgOcas.getString("MODEL_EDIT_DRAW_BORDER"), true);
    private ColorButton _ctrlColorDraw = new ColorButton(ResMsgVoc.getString("VOC_LINE"));
    private JCheckBox _fillBorderOption = new JCheckBox(ResMsgOcas.getString("MODEL_EDIT_FILL_BORDER"), false);
    private ColorButton _ctrlColorFill = new ColorButton(ResMsgVoc.getString("VOC_FILLING"));
    private static IconDlgChooser _dlgIcon = null;
    private static Object _lockerDlgIcon = new Object();

    public AltaIconRendererDlg(Window win, CeciliaAppl appl) {
        super(win, true);
        this._application = appl;
        this.setTitle(ResMsgOcas.getString("TITLE_SIZE_ICON"));
        this.make();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    private void make() {
        this.createCtrls();
        JPanel majorPanel = this.createMajorPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)majorPanel, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
        this.pack();
    }

    protected JPanel createMajorPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
        panel.add((Component)this._iconLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        panel.add((Component)this._iconFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        panel.add((Component)this._selectIconButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)this._drawBorderOption, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        bottomPanel.add((Component)this._ctrlColorDraw, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        bottomPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        bottomPanel.add((Component)this._fillBorderOption, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        bottomPanel.add((Component)this._ctrlColorFill, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        panel.add((Component)bottomPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        return panel;
    }

    private void createCtrls() {
        this._selectIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IconDlgChooser dlg = AltaIconRendererDlg.this.createIconDlgChooser();
                DBIcon dbIcon = AltaIconRendererDlg.this._currentIcon;
                if (dbIcon != null) {
                    dlg.setSelectFolder(dbIcon.getDBFolder());
                }
                dlg.setVisible(true);
                if (!dlg.getResult()) {
                    return;
                }
                DBFolder dbFolder = dlg.getSelectFolder();
                if (dbFolder == null) {
                    return;
                }
                DBWrap dbWrap = AltaIconRendererDlg.this._application.getDAOFactory().findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    return;
                }
                dbIcon = (DBIcon)dbWrap;
                ImageIcon image = dbIcon.getImage();
                if (image != null) {
                    AltaIconRendererDlg.this.refreshSizeAfterSetImageIcon(image);
                    AltaIconRendererDlg.this._iconFile.setText(dbFolder.getRefPath());
                    AltaIconRendererDlg.this._currentIcon = dbIcon;
                }
            }
        });
        this._iconFile.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String dbPath = AltaIconRendererDlg.this._iconFile.getText().trim();
                DBIcon dbIcon = null;
                if (!dbPath.isEmpty()) {
                    ImageIcon image;
                    dbIcon = AltaIconRendererDlg.this.verifyDBIcon(dbPath);
                    if (dbIcon == null) {
                        if (AltaIconRendererDlg.this._currentIcon == null) {
                            AltaIconRendererDlg.this._iconFile.setText("");
                        } else {
                            AltaIconRendererDlg.this._iconFile.setText(AltaIconRendererDlg.this._currentIcon.getRefPath());
                        }
                    } else if (dbIcon.equals(AltaIconRendererDlg.this._currentIcon)) {
                        dbIcon = null;
                    }
                    if (dbIcon != null && (image = dbIcon.getImage()) != null) {
                        AltaIconRendererDlg.this.refreshSizeAfterSetImageIcon(image);
                    }
                }
                super.focusLost(e);
            }
        });
        this._drawBorderOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaIconRendererDlg.this._ctrlColorDraw.setEnabled(AltaIconRendererDlg.this._drawBorderOption.isSelected());
            }
        });
        this._fillBorderOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaIconRendererDlg.this._ctrlColorFill.setEnabled(AltaIconRendererDlg.this._fillBorderOption.isSelected());
            }
        });
    }

    protected void refreshSizeAfterSetImageIcon(ImageIcon image) {
    }

    DBIcon verifyDBIcon(String dbPath) {
        DBWrap dbWrap;
        DBFolder dbFolder;
        if (!dbPath.isEmpty() && (dbFolder = this._application.getDAOFactory().createFolderDAO().findFolder(DBFolder.Family.IMAG.getRootName(), dbPath)) != null && (dbWrap = this._application.getDAOFactory().findOrCreateWrap(dbFolder)) != null) {
            return (DBIcon)dbWrap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IconDlgChooser createIconDlgChooser() {
        if (_dlgIcon == null) {
            Object object = _lockerDlgIcon;
            synchronized (object) {
                IconDlgChooser dlg = null;
                if (_dlgIcon == null) {
                    Window win = SwingUtilities.getWindowAncestor(this);
                    dlg = new IconDlgChooser(win, this._application);
                }
                if (dlg != null && _dlgIcon == null) {
                    _dlgIcon = dlg;
                }
            }
        }
        return _dlgIcon;
    }

    public void copyToCtrl(DBIconRenderer dbIconRenderer) {
        this._drawBorderOption.setSelected(dbIconRenderer.isColorDrawOverload());
        Color drawColor = dbIconRenderer.getColorDraw();
        this._ctrlColorDraw.setColor(drawColor != null ? drawColor : Color.black);
        this._ctrlColorDraw.setEnabled(this._drawBorderOption.isSelected());
        this._fillBorderOption.setSelected(dbIconRenderer.isColorFillOverload());
        Color fillColor = dbIconRenderer.getColorFill();
        this._ctrlColorFill.setColor(fillColor != null ? fillColor : Color.white);
        this._ctrlColorFill.setEnabled(this._fillBorderOption.isSelected());
        this._currentIcon = dbIconRenderer.getDBIcon();
        this._iconFile.setText(this._currentIcon == null ? "" : this._currentIcon.getRefPath());
    }

    @Override
    protected boolean verifyParameters() {
        return this.verifyIcon();
    }

    protected boolean verifyIcon() {
        String dbPath = this._iconFile.getText().trim();
        if (dbPath.isEmpty()) {
            this._currentIcon = null;
        } else {
            DBIcon dbIcon = this.verifyDBIcon(dbPath);
            if (dbIcon == null || dbIcon.getImage() == null) {
                JOptionPane.showMessageDialog(this._iconFile, "Icon invalide");
                this._iconFile.requestFocus();
                return false;
            }
            this._currentIcon = dbIcon;
        }
        return true;
    }

    public Color getColorDraw() {
        if (this._drawBorderOption.isSelected()) {
            return this._ctrlColorDraw.getColor();
        }
        return null;
    }

    public Color getColorFill() {
        if (this._fillBorderOption.isSelected()) {
            return this._ctrlColorFill.getColor();
        }
        return null;
    }

    public DBIcon getIcon() {
        return this._currentIcon;
    }
}

