/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.gui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditPanel;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaDefaultTableCellRenderer;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBound;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.mbsa.type.gui.AltaTypeTableCellRenderer;
import com.dassault.cecilia.dbobj.mbsa.type.gui.TypeDlgChooser;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;

public class AltaStatePanel
extends AltaEditPanel {
    private CeciliaAppl _appl;
    StateTable _ctrlTable;
    StateTableModel _ctrlTableModel;
    JLabel _stateNameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME"));
    JTextField _stateName = new JTextField("");
    JLabel _stateTypeLabel = new JLabel(ResMsgVoc.getString("VOC_TYPE"));
    JComboBox _stateTypeSelector = new JComboBox();
    CeciliaAction _ctrlAdd;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlEdit;
    JButton _allocateStateTypeButton = new JButton(ResMsgVoc.getString("VOC_AFFECT"));
    JPopupMenu _popupMenu = new JPopupMenu();
    JPanel _emptyPanel = new JPanel();
    JPanel _intFloatPanel = new JPanel();
    JPanel _boolPanel = new JPanel();
    JComboBox _stateEnumSelector = new JComboBox();
    JComboBox _stateBoolSelector = new JComboBox();
    JComboBox _statePredefineSelector = new JComboBox();
    JTextField _valueEnumTypeState = new JTextField("");
    JPanel _predefinePanel = new JPanel();
    JTextField _predefineType = new JTextField("");
    JButton _selectPredefineType = new JButton("...");
    private static TypeDlgChooser _typeChooser = null;
    private static Object _LockerDlgChooser = new Object();
    JPanel _intervalPanel = new JPanel();
    JPanel _enumPanel = new JPanel();
    JLabel _minLabel = new JLabel("Min");
    JLabel _maxLabel = new JLabel("Max");
    JTextField _minValue = new JTextField("");
    JTextField _maxValue = new JTextField("");
    JTextField _defaultValue = new JTextField();
    JComboBox _listValueCombo = new JComboBox();
    StateTableEditor _stateNameEditor = new StateTableEditor();
    JTextField _intFloatValue = new JTextField("");
    int _editingRow = -1;
    int _editingColumn = -1;
    ItemListener _listValueListener;
    AltaState _currentState = null;
    String _maxCommun = "";
    String _minCommun = "";
    boolean _forReadOnly = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (_typeChooser == null) {
            TypeDlgChooser dlg = null;
            Object object = _LockerDlgChooser;
            synchronized (object) {
                if (_typeChooser == null) {
                    dlg = new TypeDlgChooser(win, appl);
                    dlg.setOnlyEnum(true);
                }
                if (_typeChooser == null) {
                    _typeChooser = dlg;
                }
            }
        }
        return _typeChooser;
    }

    public void forReadOnly(boolean readOnly) {
        this._forReadOnly = readOnly;
    }

    public AltaStatePanel(CeciliaAppl appl) {
        this._appl = appl;
        this.createActions();
        JToolBar panelStateButton = new JToolBar();
        panelStateButton.add(Box.createGlue());
        panelStateButton.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelStateButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelStateButton.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelStateButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelStateButton.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelStateButton.add(Box.createGlue());
        panelStateButton.setFloatable(false);
        JPanel panelStateType = new JPanel();
        panelStateType.setLayout(new GridBagLayout());
        panelStateType.setBorder(BorderFactory.createEtchedBorder());
        panelStateType.add((Component)this._stateNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._stateName, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._stateTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._stateTypeSelector, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._enumPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._predefinePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._intervalPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._intFloatPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._boolPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._emptyPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelStateType.add((Component)this._allocateStateTypeButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._predefinePanel.setLayout(new GridBagLayout());
        this._predefinePanel.add((Component)this._predefineType, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 2), 0, 0));
        this._predefinePanel.add((Component)this._selectPredefineType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 5), 0, 0));
        this._predefinePanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_VALUE")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 2), 0, 0));
        this._predefinePanel.add((Component)this._statePredefineSelector, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 2), 0, 0));
        this._intervalPanel.setLayout(new GridBagLayout());
        this._intervalPanel.add((Component)this._minLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._minValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._maxLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._maxValue, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_VALUE")), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._defaultValue, new GridBagConstraints(5, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._intFloatPanel.setLayout(new GridBagLayout());
        this._intFloatPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_VALUE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intFloatPanel.add((Component)this._intFloatValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._boolPanel.setLayout(new GridBagLayout());
        this._boolPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_VALUE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._boolPanel.add((Component)this._stateBoolSelector, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._enumPanel.setLayout(new GridBagLayout());
        this._enumPanel.add((Component)this._valueEnumTypeState, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._enumPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_VALUE")), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._enumPanel.add((Component)this._stateEnumSelector, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._stateNameLabel.setForeground(Color.black);
        this._stateTypeLabel.setForeground(Color.black);
        this._minLabel.setForeground(Color.black);
        this._maxLabel.setForeground(Color.black);
        this._stateTypeSelector.addItem("bool");
        this._stateTypeSelector.addItem("enum");
        this._stateTypeSelector.addItem(ResMsgVoc.getString("VOC_INTERVAL"));
        this._stateTypeSelector.addItem(ResMsgOcas.getString("OCAS_PREDEFINE"));
        this._stateTypeSelector.addItem("int");
        this._stateTypeSelector.addItem("float");
        this._stateBoolSelector.addItem("true");
        this._stateBoolSelector.addItem("false");
        this._predefinePanel.setVisible(false);
        this._intervalPanel.setVisible(false);
        this._intFloatPanel.setVisible(false);
        this._enumPanel.setVisible(false);
        this._ctrlTableModel = new StateTableModel();
        this._ctrlTable = new StateTable(this._ctrlTableModel);
        this._ctrlTable.setSelectionMode(2);
        this._ctrlTable.setRowHeight(20);
        this._ctrlTable.setDefaultEditor(String.class, new StateTableCellEditor(this._listValueCombo));
        this._ctrlTable.setDefaultRenderer(String.class, new AltaDefaultTableCellRenderer());
        this._ctrlTable.setDefaultRenderer(AltaType.class, new AltaTypeTableCellRenderer());
        this._popupMenu.add(this._ctrlEdit);
        this._popupMenu.addSeparator();
        this._popupMenu.add(this._ctrlDel);
        this._popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AltaStatePanel.this.selectState();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.setLayout(new GridBagLayout());
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        this.add((Component)scrollTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 2, 5), 0, 0));
        if (!this._appl.isReader()) {
            this.add((Component)panelStateButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
            this.add((Component)panelStateType, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 5, 5), 0, 0));
            scrollTable.setComponentPopupMenu(this._popupMenu);
        }
        this.selectState();
        this.defineActions();
    }

    @Override
    public void focusTreatment() {
        super.focusTreatment();
        this._stateName.requestFocus();
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaStatePanel.this.addState();
            }
        }.setDesc(ResMsgOcas.getString("CMD_STATE_ADD"));
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] viewIndices;
                if (AltaStatePanel.this._currentComponent != null && (viewIndices = AltaStatePanel.this._ctrlTable.getSelectedRows()).length != 0) {
                    int[] modelIndices = new int[viewIndices.length];
                    for (int i = viewIndices.length - 1; i >= 0; --i) {
                        modelIndices[i] = AltaStatePanel.this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
                    }
                    Arrays.sort(modelIndices);
                    if (AltaStatePanel.this._ctrlTable.isEditing()) {
                        AltaStatePanel.this._ctrlTable.removeEditor();
                    }
                    List<AltaState> states = AltaStatePanel.this.getAltaComponent().getStates();
                    boolean withDBType = false;
                    for (int i = modelIndices.length - 1; i >= 0; --i) {
                        AltaState st = states.remove(modelIndices[i]);
                        if (!(st.getType() instanceof DBType)) continue;
                        withDBType = true;
                    }
                    AltaStatePanel.this._ctrlTable.clearSelection();
                    AltaStatePanel.this.refreshTable();
                    AltaStatePanel.this.getAltaComponent().setModified(true);
                    if (withDBType) {
                        AltaStatePanel.this.getAltaComponent().updateDependTimeUpdt(AltaStatePanel.this._appl.getDAOFactory(), AltaStatePanel.this.getAltaComponent().getWorkingRelations());
                    }
                }
            }
        }.setDesc(ResMsgOcas.getString("CMD_STATE_DEL"));
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaStatePanel.this.doEditType();
            }
        }.setDesc(ResMsgOcas.getString("CMD_TYPE_EDIT"));
    }

    private void defineActions() {
        this._stateName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AltaStatePanel.this.addState();
                }
            }
        });
        this._listValueListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int viewIndex = AltaStatePanel.this._ctrlTable.getSelectedRow();
                if (viewIndex != -1) {
                    int modelIndex = AltaStatePanel.this._ctrlTable.convertRowIndexToModel(viewIndex);
                    AltaState state = AltaStatePanel.this._currentComponent.getStates().get(modelIndex);
                    if (AltaStatePanel.this._listValueCombo.getSelectedItem() != null) {
                        state.setDefaultValue((String)AltaStatePanel.this._listValueCombo.getSelectedItem());
                    }
                    AltaStatePanel.this._listValueCombo.removeItemListener(AltaStatePanel.this._listValueListener);
                    AltaStatePanel.this.refreshTable();
                    viewIndex = AltaStatePanel.this._ctrlTable.convertRowIndexToView(modelIndex);
                    AltaStatePanel.this._ctrlTable.setRowSelectionInterval(viewIndex, viewIndex);
                    AltaStatePanel.this.getAltaComponent().setModified(true);
                }
            }
        };
        this._valueEnumTypeState.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                if (e.getOppositeComponent() == null || e.getOppositeComponent() == ((DBInternalFrame)SwingUtilities.getAncestorOfClass(DBInternalFrame.class, AltaStatePanel.this)).getCloseButton()) {
                    return;
                }
                AltaStatePanel.this.updateStateEnumSelector(e.getOppositeComponent() == AltaStatePanel.this._stateEnumSelector);
            }
        });
        this._predefineType.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                if (e.getOppositeComponent() == null || e.getOppositeComponent() == ((DBInternalFrame)SwingUtilities.getAncestorOfClass(DBInternalFrame.class, AltaStatePanel.this)).getCloseButton()) {
                    return;
                }
                AltaStatePanel.this.updateStatePredefineSelector(AltaStatePanel.this._predefineType.getText(), e.getOppositeComponent() == AltaStatePanel.this._statePredefineSelector);
            }
        });
        this._stateTypeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (AltaStatePanel.this._stateTypeSelector.getSelectedIndex()) {
                    case 0: {
                        AltaStatePanel.this._intFloatPanel.setVisible(false);
                        AltaStatePanel.this._intervalPanel.setVisible(false);
                        AltaStatePanel.this._predefinePanel.setVisible(false);
                        AltaStatePanel.this._boolPanel.setVisible(true);
                        AltaStatePanel.this._enumPanel.setVisible(false);
                        AltaStatePanel.this._emptyPanel.setVisible(false);
                        AltaStatePanel.this._stateBoolSelector.setSelectedItem("false");
                        break;
                    }
                    case 4: 
                    case 5: {
                        AltaStatePanel.this._intFloatPanel.setVisible(true);
                        AltaStatePanel.this._intervalPanel.setVisible(false);
                        AltaStatePanel.this._predefinePanel.setVisible(false);
                        AltaStatePanel.this._boolPanel.setVisible(false);
                        AltaStatePanel.this._enumPanel.setVisible(false);
                        AltaStatePanel.this._emptyPanel.setVisible(false);
                        AltaStatePanel.this._intFloatValue.setText("");
                        break;
                    }
                    case 1: {
                        AltaStatePanel.this._intFloatPanel.setVisible(false);
                        AltaStatePanel.this._intervalPanel.setVisible(false);
                        AltaStatePanel.this._predefinePanel.setVisible(false);
                        AltaStatePanel.this._boolPanel.setVisible(false);
                        AltaStatePanel.this._enumPanel.setVisible(true);
                        AltaStatePanel.this._emptyPanel.setVisible(false);
                        AltaStatePanel.this._valueEnumTypeState.setText("");
                        AltaStatePanel.this._stateEnumSelector.removeAllItems();
                        break;
                    }
                    case 2: {
                        AltaStatePanel.this._intFloatPanel.setVisible(false);
                        AltaStatePanel.this._intervalPanel.setVisible(true);
                        AltaStatePanel.this._predefinePanel.setVisible(false);
                        AltaStatePanel.this._boolPanel.setVisible(false);
                        AltaStatePanel.this._enumPanel.setVisible(false);
                        AltaStatePanel.this._emptyPanel.setVisible(false);
                        AltaStatePanel.this._minValue.setText("");
                        AltaStatePanel.this._maxValue.setText("");
                        AltaStatePanel.this._defaultValue.setText("");
                        break;
                    }
                    case 3: {
                        AltaStatePanel.this._intFloatPanel.setVisible(false);
                        AltaStatePanel.this._intervalPanel.setVisible(false);
                        AltaStatePanel.this._predefinePanel.setVisible(true);
                        AltaStatePanel.this._boolPanel.setVisible(false);
                        AltaStatePanel.this._enumPanel.setVisible(false);
                        AltaStatePanel.this._emptyPanel.setVisible(false);
                        AltaStatePanel.this._predefineType.setText("");
                        AltaStatePanel.this._statePredefineSelector.removeAllItems();
                        break;
                    }
                    default: {
                        AltaStatePanel.this._intFloatPanel.setVisible(false);
                        AltaStatePanel.this._intervalPanel.setVisible(false);
                        AltaStatePanel.this._predefinePanel.setVisible(false);
                        AltaStatePanel.this._boolPanel.setVisible(false);
                        AltaStatePanel.this._enumPanel.setVisible(false);
                        AltaStatePanel.this._emptyPanel.setVisible(true);
                    }
                }
            }
        });
        this._allocateStateTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaStatePanel.this.allocateState();
            }
        });
        this._ctrlTable.getActionMap().put("DELETE", this._ctrlDel);
        this._ctrlTable.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        this._selectPredefineType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeDlgChooser dlg = AltaStatePanel.getDlgChooser(SwingUtilities.getWindowAncestor(AltaStatePanel.this._selectPredefineType), AltaStatePanel.this._appl);
                DAOFolder daoFolder = AltaStatePanel.this._appl.getDAOFactory().createFolderDAO();
                DBFolder dbFolder = daoFolder.findFolder("TYPE_FAMILIES", AltaStatePanel.this._predefineType.getText());
                if (dbFolder != null) {
                    dlg.setSelectFolder(dbFolder);
                }
                dlg.setVisible(true);
                if (dlg.getResult() && (dbFolder = dlg.getSelectFolder()) != null) {
                    DBFolder foldToWrite = dbFolder;
                    AltaStatePanel.this._predefineType.setText(dbFolder.getRefPath());
                    EventQueue.invokeLater(() -> AltaStatePanel.this.updateStatePredefineSelector(foldToWrite.getRefPath(), false));
                }
            }
        });
    }

    protected void doEditType() {
        if (this._ctrlTable.getSelectedRow() == -1) {
            return;
        }
        if (this.getAltaComponent() == null) {
            return;
        }
        int rowView = this._ctrlTable.getSelectedRow();
        AltaType type = this.getAltaComponent().getStates().get(this._ctrlTable.convertRowIndexToModel(rowView)).getType();
        if (!(type instanceof DBType)) {
            return;
        }
        if (((DBType)type).getDBFolder() == null) {
            return;
        }
        DBFolderTreeActivable tree = this._appl.getTopWindow().getFolders().getTree(DBFolder.Family.TYPE);
        if (tree != null) {
            tree.edit(((DBType)type).getDBFolder(), false);
        }
    }

    public void refreshTable() {
        this._ctrlTableModel.fireTableDataChanged();
    }

    public void updateStatePredefineSelector(String text, boolean isClickOnCB) {
        AltaType defaultType = AltaTypeParser.getType(text, this._appl.getDAOFactory());
        if (defaultType != null) {
            if (defaultType instanceof DBEnum) {
                this.updateWithNewValues(false, defaultType, isClickOnCB);
            } else {
                this._predefineType.requestFocusInWindow();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._predefineType), ResMsgOcas.getString("INFO_MODEL_TYPE_STRUCT_NOT_GOOD_FOR_STATE"), ResMsgVoc.getString("VOC_ERROR"), 0);
            }
        } else {
            this._predefineType.requestFocusInWindow();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._predefineType), ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
        }
    }

    public void updateStateEnumSelector(boolean isClickOnEnumCB) {
        String text = this._valueEnumTypeState.getText();
        if (text.isEmpty()) {
            this._valueEnumTypeState.requestFocusInWindow();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._valueEnumTypeState), ResMsgOcas.getString("MODEL_EDIT_ERROR_NO_ENUM"), ResMsgVoc.getString("VOC_ERROR"), 0);
        } else if (text.indexOf(" ") != -1) {
            this._valueEnumTypeState.requestFocusInWindow();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._valueEnumTypeState), ResMsgOcas.getString("MODEL_EDIT_ERROR_SPACE"), ResMsgVoc.getString("VOC_ERROR"), 0);
        } else {
            AltaType dbType = AltaTypeParser.getType(text, this._appl.getDAOFactory());
            if (dbType == null) {
                String convertEnumType = AltaTypeEnum.convertInEnumType(text);
                if (convertEnumType == null) {
                    this._valueEnumTypeState.requestFocusInWindow();
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._valueEnumTypeState), ResMsgOcas.getString("TYPE_SPECIFY_ERROR"), ResMsgVoc.getString("VOC_ERROR"), 0);
                } else {
                    dbType = new AltaTypeEnum("{" + convertEnumType + "}");
                }
            }
            if (dbType != null) {
                this.updateWithNewValues(true, dbType, isClickOnEnumCB);
            }
        }
    }

    private void updateWithNewValues(boolean isForEnum, AltaType dbType, boolean isClickOnCB) {
        int posXOnParent;
        String valSelect = "";
        String[] newValues = new String[dbType.getValueCount()];
        JComboBox<String> box = isForEnum ? this._stateEnumSelector : this._statePredefineSelector;
        JPanel parent = isForEnum ? this._enumPanel : this._predefinePanel;
        int n = posXOnParent = isForEnum ? 2 : 3;
        if (box.getSelectedItem() != null) {
            valSelect = (String)box.getSelectedItem();
        }
        DefaultComboBoxModel oldModel = (DefaultComboBoxModel)this._stateEnumSelector.getModel();
        boolean sameValues = dbType.getValueCount() == this._stateEnumSelector.getModel().getSize();
        for (int i = 0; i < dbType.getValueCount(); ++i) {
            String newValue;
            newValues[i] = newValue = dbType.getValueAt(i);
            if (!sameValues) continue;
            String oldVal = (String)oldModel.getElementAt(i);
            sameValues &= oldVal.equals(newValue);
        }
        if (sameValues) {
            return;
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(newValues);
        parent.remove(box);
        box = new JComboBox<String>(model);
        box.setSelectedItem(valSelect);
        parent.add(box, new GridBagConstraints(posXOnParent, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        parent.validate();
        parent.repaint();
        box.repaint();
        parent.requestFocus();
        if (isForEnum) {
            this._stateEnumSelector = box;
        } else {
            this._statePredefineSelector = box;
        }
        JComboBox<String> finalBox = box;
        if (isClickOnCB) {
            EventQueue.invokeLater(() -> {
                finalBox.showPopup();
                finalBox.setPopupVisible(true);
            });
        }
    }

    SelectedType getSelectedType() {
        Object defValue = null;
        switch (this._stateTypeSelector.getSelectedIndex()) {
            case 0: {
                defValue = this._stateBoolSelector.getSelectedItem() != null ? "" + this._stateBoolSelector.getSelectedItem() : "false";
                return new SelectedType(AltaTypeBool.getInstance(), (String)defValue);
            }
            case 1: {
                if (this._valueEnumTypeState.getText().equals("")) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_NO_ENUM"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (this._valueEnumTypeState.getText().indexOf(" ") != -1) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_SPACE"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                String convertEnumType = AltaTypeEnum.convertInEnumType(this._valueEnumTypeState.getText());
                AltaType defaultType = null;
                if (convertEnumType != null) {
                    defaultType = new AltaTypeEnum("{" + convertEnumType + "}");
                } else {
                    defaultType = AltaTypeParser.getType(this._valueEnumTypeState.getText(), this._appl.getDAOFactory());
                    if (defaultType == null) {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    }
                }
                if (defaultType == null) break;
                if (this._stateEnumSelector.getSelectedItem() != null) {
                    defValue = (String)this._stateEnumSelector.getSelectedItem();
                    if (defaultType.valueExist((String)defValue)) {
                        return new SelectedType(defaultType, (String)defValue);
                    }
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_DEFAULT_VALUE"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                defValue = defaultType.getDefaultValue();
                return new SelectedType(defaultType, (String)defValue);
            }
            case 2: {
                int minValue = Integer.MIN_VALUE;
                int maxValue = Integer.MIN_VALUE;
                int defaultValue = Integer.MIN_VALUE;
                try {
                    minValue = Integer.parseInt(this._minValue.getText());
                    maxValue = Integer.parseInt(this._maxValue.getText());
                    defaultValue = this._defaultValue.getText().isEmpty() ? minValue : Integer.parseInt(this._defaultValue.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (minValue < 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MIN"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (maxValue < 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAX"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (minValue >= maxValue) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAXMIN_2"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (defaultValue < 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_DEFAULT_VALUE"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (defaultValue < minValue || defaultValue > maxValue) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAXMIN_DEFAULT_VALUE"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                return new SelectedType(new AltaTypeBound(minValue, maxValue), Integer.toString(defaultValue));
            }
            case 3: {
                AltaType defaultType = AltaTypeParser.getType(this._predefineType.getText(), this._appl.getDAOFactory());
                if (defaultType == null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (defaultType instanceof DBEnum) {
                    if (this._statePredefineSelector.getSelectedItem() != null) {
                        defValue = (String)this._statePredefineSelector.getSelectedItem();
                        if (defaultType.valueExist((String)defValue)) {
                            return new SelectedType(defaultType, (String)defValue);
                        }
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_DEFAULT_VALUE"), ResMsgVoc.getString("VOC_ERROR"), 0);
                        break;
                    }
                    defValue = defaultType.getDefaultValue();
                    return new SelectedType(defaultType, (String)defValue);
                }
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("INFO_MODEL_TYPE_STRUCT_NOT_GOOD_FOR_STATE"), ResMsgVoc.getString("VOC_ERROR"), 0);
                break;
            }
            case 4: {
                if (this._intFloatValue.getText().isEmpty()) {
                    return new SelectedType(AltaTypeInt.getInstance(), "0");
                }
                try {
                    int def = Integer.parseInt(this._intFloatValue.getText());
                    return new SelectedType(AltaTypeInt.getInstance(), Integer.toString(def));
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgVoc.msgFormat("MSG_PARSE_INT", this._intFloatValue.getText()), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
            }
            case 5: {
                if (this._intFloatValue.getText().equals("")) {
                    return new SelectedType(AltaTypeFloat.getInstance(), "0.0");
                }
                try {
                    float def = Float.parseFloat(this._intFloatValue.getText());
                    return new SelectedType(AltaTypeFloat.getInstance(), Float.toString(def));
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgVoc.msgFormat("MSG_PARSE_FLOAT", this._intFloatValue.getText()), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
            }
            default: {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_TYPE_EMPTY"), ResMsgVoc.getString("VOC_ERROR"), 0);
            }
        }
        return null;
    }

    public void addState() {
        String name;
        if (this._currentComponent == null) {
            return;
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && this._currentComponent.getStates().size() >= DemoLimits.Limit.COMPONENT_STATES.getLimit()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgOcas.getString("DEMO_COMPONENT_STATES"), JOptionCecilia.getTopTitleOf(this._ctrlTable), 0);
            return;
        }
        if (this._stateName.getText().isEmpty()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_STATE_EMPTY"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return;
        }
        if (this._ctrlTable.isEditing()) {
            this._ctrlTable.removeEditor();
        }
        if ((name = this.validateName(this._stateName.getText())) == null) {
            return;
        }
        SelectedType selectType = this.getSelectedType();
        if (selectType == null) {
            return;
        }
        AltaState state = new AltaState(name, selectType._type, selectType._default);
        this._currentComponent.getStates().add(state);
        int idx = this._currentComponent.getStates().size() - 1;
        this.refreshTable();
        idx = this._ctrlTable.convertRowIndexToView(idx);
        this._ctrlTable.setRowSelectionInterval(idx, idx);
        this.getAltaComponent().setModified(true);
        if (state.getType() instanceof DBType) {
            this.getAltaComponent().updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
        }
    }

    protected void allocateState() {
        SelectedType selectType;
        if (this._currentComponent == null) {
            return;
        }
        int[] viewIndices = this._ctrlTable.getSelectedRows();
        if (viewIndices == null || viewIndices.length == 0) {
            return;
        }
        if (this._ctrlTable.isEditing()) {
            this._ctrlTable.removeEditor();
        }
        if ((selectType = this.getSelectedType()) == null) {
            return;
        }
        boolean changeWithDBType = false;
        int[] modelIndices = new int[viewIndices.length];
        for (int i = 0; i < viewIndices.length; ++i) {
            modelIndices[i] = this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
            AltaState state = this._currentComponent.getStates().get(modelIndices[i]);
            if (!state.getType().equals(selectType._type)) {
                if (state.getType() instanceof DBType || selectType._type instanceof DBType) {
                    changeWithDBType = true;
                }
                state.setType(selectType._type);
                state.setDefaultValue(selectType._default);
                continue;
            }
            state.setDefaultValue(selectType._default);
        }
        this.refreshTable();
        ListSelectionModel selectModel = this._ctrlTable.getSelectionModel();
        selectModel.setValueIsAdjusting(true);
        selectModel.clearSelection();
        for (int i = 0; i < modelIndices.length; ++i) {
            int rowView = this._ctrlTable.convertRowIndexToView(modelIndices[i]);
            selectModel.addSelectionInterval(rowView, rowView);
        }
        selectModel.setValueIsAdjusting(false);
        this.getAltaComponent().setModified(true);
        if (changeWithDBType) {
            this.getAltaComponent().updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
        }
    }

    public AltaState getCommunStateSelectedRows() {
        if (this._currentComponent == null) {
            return null;
        }
        this._minCommun = "";
        this._maxCommun = "";
        int[] indices = this._ctrlTable.getSelectedRows();
        if (indices == null || indices.length == 0) {
            return null;
        }
        if (indices.length == 1) {
            AltaState communState = this._currentComponent.getStates().get(this._ctrlTable.convertRowIndexToModel(indices[0]));
            if (communState.getType() instanceof AltaTypeBound) {
                this._minCommun = Integer.toString(((AltaTypeBound)communState.getType()).getMin());
                this._maxCommun = Integer.toString(((AltaTypeBound)communState.getType()).getMax());
            }
            return communState;
        }
        AltaState communState = this._currentComponent.getStates().get(this._ctrlTable.convertRowIndexToModel(indices[0])).getCopy();
        communState.setName("");
        AltaType type = communState.getType();
        boolean isBoolType = type instanceof AltaTypeBool;
        boolean isBoundType = type instanceof AltaTypeBound;
        boolean isIntType = type instanceof AltaTypeInt;
        boolean isFloatType = type instanceof AltaTypeFloat;
        boolean isEnumType = type instanceof AltaTypeEnum;
        boolean isPredefineType = type instanceof DBEnum;
        boolean identDefaultValue = true;
        if (isBoundType) {
            this._minCommun = Integer.toString(((AltaTypeBound)type).getMin());
            this._maxCommun = Integer.toString(((AltaTypeBound)type).getMax());
        }
        for (int i = 1; i < indices.length; ++i) {
            AltaState curState = this._currentComponent.getStates().get(this._ctrlTable.convertRowIndexToModel(indices[i]));
            AltaType curType = curState.getType();
            isBoolType = isBoolType && curType instanceof AltaTypeBool;
            isBoundType = isBoundType && curType instanceof AltaTypeBound;
            isIntType = isIntType && curType instanceof AltaTypeInt;
            isFloatType = isFloatType && curType instanceof AltaTypeFloat;
            isEnumType = isEnumType && curType instanceof AltaTypeEnum;
            boolean bl = isPredefineType = isPredefineType && curType instanceof DBEnum;
            if (isBoolType || isIntType || isFloatType) {
                if (!communState.getDefaultValue().equals(curState.getDefaultValue())) {
                    communState.setDefaultValue("");
                }
            } else if (isBoundType) {
                AltaType oldType = curState.getType();
                if (!Integer.toString(((AltaTypeBound)oldType).getMin()).equals(this._minCommun)) {
                    this._minCommun = "";
                }
                if (!Integer.toString(((AltaTypeBound)oldType).getMax()).equals(this._maxCommun)) {
                    this._maxCommun = "";
                }
            } else if (isEnumType) {
                ArrayList<String> enumValues = new ArrayList<String>();
                AltaType communType = communState.getType();
                AltaType oldType = curState.getType();
                for (int idx = 0; idx < communType.getValueCount(); ++idx) {
                    String elem = communType.getValueAt(idx);
                    if (!oldType.valueExist(elem)) continue;
                    enumValues.add(elem);
                }
                ((AltaTypeEnum)communType).setValues(enumValues);
            } else if (isPredefineType) {
                if (!communState.compareType(curState)) {
                    communState.setType(null);
                }
            } else {
                communState.setType(null);
            }
            if (!identDefaultValue || (identDefaultValue = communState.compareDefaultValue(curState))) continue;
            communState.setDefaultValue("");
        }
        return communState;
    }

    public void selectState() {
        if (this._ctrlTable.getSelectedRowCount() != 0) {
            this._ctrlDel.setEnabled(!this._appl.isReader());
            if (this._currentComponent != null) {
                this._currentState = this.getCommunStateSelectedRows();
                this._stateName.setText(this._currentState.getName());
                AltaType curType = this._currentState.getType();
                if (curType != null) {
                    boolean enableEditType = curType instanceof DBEnum;
                    this._ctrlEdit.setEnabled(enableEditType);
                    if (curType instanceof AltaTypeBool) {
                        this._stateTypeSelector.setSelectedIndex(0);
                        if (this._currentState.getDefaultValue().isEmpty()) {
                            this._stateBoolSelector.setSelectedIndex(-1);
                        } else {
                            this._stateBoolSelector.setSelectedItem(this._currentState.getDefaultValue());
                        }
                    } else if (curType instanceof AltaTypeEnum) {
                        AltaTypeEnum enumType = (AltaTypeEnum)curType;
                        this._stateTypeSelector.setSelectedIndex(1);
                        String enumeration = curType.getValue();
                        if (enumeration.indexOf("{") != -1) {
                            enumeration = enumeration.substring(1, enumeration.length() - 1);
                        }
                        this._valueEnumTypeState.setText(enumeration);
                        this._stateEnumSelector.removeAllItems();
                        for (int i = 0; i < enumType.getValueCount(); ++i) {
                            this._stateEnumSelector.addItem(enumType.getValueAt(i));
                        }
                        if (this._currentState.getDefaultValue().isEmpty()) {
                            this._stateEnumSelector.setSelectedIndex(-1);
                        } else {
                            this._stateEnumSelector.setSelectedItem(this._currentState.getDefaultValue());
                        }
                    } else if (curType instanceof AltaTypeBound) {
                        this._stateTypeSelector.setSelectedIndex(2);
                        this._minValue.setText(this._minCommun);
                        this._maxValue.setText(this._maxCommun);
                        this._defaultValue.setText(this._currentState.getDefaultValue());
                    } else if (curType instanceof DBEnum) {
                        DBEnum dbEnum = (DBEnum)curType;
                        this._stateTypeSelector.setSelectedIndex(3);
                        this._predefineType.setText(dbEnum.getRefPath());
                        this._statePredefineSelector.removeAllItems();
                        for (int i = 0; i < dbEnum.getValueCount(); ++i) {
                            this._statePredefineSelector.addItem(dbEnum.getValueAt(i));
                        }
                        if (this._currentState.getDefaultValue().isEmpty()) {
                            this._statePredefineSelector.setSelectedIndex(-1);
                        } else {
                            this._statePredefineSelector.setSelectedItem(this._currentState.getDefaultValue());
                        }
                    } else if (curType instanceof AltaTypeInt) {
                        this._stateTypeSelector.setSelectedIndex(4);
                        this._intFloatValue.setText(this._currentState.getDefaultValue());
                    } else if (curType instanceof AltaTypeFloat) {
                        this._stateTypeSelector.setSelectedIndex(5);
                        this._intFloatValue.setText(this._currentState.getDefaultValue());
                    }
                } else {
                    this._ctrlEdit.setEnabled(false);
                    this._stateTypeSelector.setSelectedIndex(-1);
                }
            } else {
                this._ctrlEdit.setEnabled(false);
                this._stateName.setText("");
                this._stateTypeSelector.setSelectedIndex(-1);
            }
        } else {
            this._ctrlDel.setEnabled(false);
            this._ctrlEdit.setEnabled(false);
            this._stateName.setText("");
            this._stateTypeSelector.setSelectedIndex(0);
            this._stateBoolSelector.setSelectedItem("false");
            this._intFloatValue.setText("");
            this._valueEnumTypeState.setText("");
            this._stateEnumSelector.removeAllItems();
            this._minValue.setText("");
            this._maxValue.setText("");
            this._defaultValue.setText("");
            this._predefineType.setText("");
            this._statePredefineSelector.removeAllItems();
        }
    }

    @Override
    public void setComponent(AltaComponent currentComponent) {
        super.setComponent(currentComponent);
        this.refreshTable();
    }

    public void updateLangage() {
        this._allocateStateTypeButton.setText(ResMsgVoc.getString("VOC_AFFECT"));
        this._stateNameLabel.setText(ResMsgVoc.getString("VOC_NAME"));
        this._stateTypeLabel.setText(ResMsgVoc.getString("VOC_TYPE"));
        this.refreshTable();
        this._ctrlEdit.setName(ResMsgOcas.getString("CMD_TYPE_EDIT"));
        this._ctrlDel.setName(ResMsgVoc.getString("VOC_DELETE"));
        this._ctrlAdd.setDesc(ResMsgOcas.getString("CMD_STATE_ADD"));
        this._ctrlEdit.setDesc(ResMsgOcas.getString("CMD_TYPE_EDIT"));
        this._ctrlDel.setDesc(ResMsgOcas.getString("CMD_STATE_DEL"));
        int type = this._stateTypeSelector.getSelectedIndex();
        this._stateTypeSelector.removeAllItems();
        this._stateTypeSelector.addItem("bool");
        this._stateTypeSelector.addItem("enum");
        this._stateTypeSelector.addItem(ResMsgVoc.getString("VOC_INTERVAL"));
        this._stateTypeSelector.addItem(ResMsgOcas.getString("OCAS_PREDEFINE"));
        this._stateTypeSelector.addItem("int");
        this._stateTypeSelector.addItem("float");
        this._stateTypeSelector.setSelectedIndex(type);
        this._selectPredefineType.setText("...");
    }

    public class StateTableEditor
    extends JTextField
    implements KeyListener {
        boolean enterHasBeenPressed;

        StateTableEditor() {
            super("");
            this.enterHasBeenPressed = false;
            this.addKeyListener(this);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            switch (e.getID()) {
                case 1005: {
                    if (!this.enterHasBeenPressed) {
                        this.validText();
                    }
                }
                case 1004: {
                    this.enterHasBeenPressed = false;
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.enterHasBeenPressed = true;
                this.validText();
            }
        }

        public void validText() {
            switch (AltaStatePanel.this._editingColumn) {
                case 0: {
                    AltaState state = AltaStatePanel.this._currentComponent.getStates().get(AltaStatePanel.this._editingRow);
                    String name = this.getText();
                    if (!state.getName().equals(name)) {
                        if ((name = AltaStatePanel.this.validateName(name)) != null) {
                            state.setName(name);
                            AltaStatePanel.this._stateName.setText(name);
                            AltaStatePanel.this.getAltaComponent().setModified(true);
                        }
                        AltaStatePanel.this.refreshTable();
                        int rowView = AltaStatePanel.this._ctrlTable.convertRowIndexToView(AltaStatePanel.this._editingRow);
                        AltaStatePanel.this._ctrlTable.setRowSelectionInterval(rowView, rowView);
                    }
                    if (AltaStatePanel.this._ctrlTable.getCellEditor() != null) {
                        AltaStatePanel.this._ctrlTable.getCellEditor().stopCellEditing();
                    }
                    AltaStatePanel.this._ctrlTable.setEditable(false);
                    break;
                }
                case 2: {
                    AltaState state = AltaStatePanel.this._currentComponent.getStates().get(AltaStatePanel.this._editingRow);
                    if (state.getType() instanceof AltaTypeInt) {
                        try {
                            Integer.parseInt(this.getText());
                            state.setDefaultValue(this.getText());
                            AltaStatePanel.this.refreshTable();
                            int rowView = AltaStatePanel.this._ctrlTable.convertRowIndexToView(AltaStatePanel.this._editingRow);
                            AltaStatePanel.this._ctrlTable.setRowSelectionInterval(rowView, rowView);
                            AltaStatePanel.this.getAltaComponent().setModified(true);
                        }
                        catch (NumberFormatException ex) {
                            AltaStatePanel.this.refreshTable();
                            int rowView = AltaStatePanel.this._ctrlTable.convertRowIndexToView(AltaStatePanel.this._editingRow);
                            AltaStatePanel.this._ctrlTable.setRowSelectionInterval(rowView, rowView);
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgVoc.msgFormat("MSG_PARSE_INT", this.getText()), ResMsgVoc.getString("VOC_ERROR"), 0);
                        }
                        break;
                    }
                    if (!(state.getType() instanceof AltaTypeFloat)) break;
                    try {
                        Float.parseFloat(this.getText());
                        state.setDefaultValue(this.getText());
                        AltaStatePanel.this.refreshTable();
                        int rowView = AltaStatePanel.this._ctrlTable.convertRowIndexToView(AltaStatePanel.this._editingRow);
                        AltaStatePanel.this._ctrlTable.setRowSelectionInterval(rowView, rowView);
                        AltaStatePanel.this.getAltaComponent().setModified(true);
                    }
                    catch (NumberFormatException ex) {
                        AltaStatePanel.this.refreshTable();
                        int rowView = AltaStatePanel.this._ctrlTable.convertRowIndexToView(AltaStatePanel.this._editingRow);
                        AltaStatePanel.this._ctrlTable.setRowSelectionInterval(rowView, rowView);
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgVoc.msgFormat("MSG_PARSE_FLOAT", this.getText()), ResMsgVoc.getString("VOC_ERROR"), 0);
                    }
                    break;
                }
            }
        }
    }

    public class StateTableModel
    extends AbstractTableModel {
        StateTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (AltaStatePanel.this._currentComponent == null) {
                return 0;
            }
            return AltaStatePanel.this._currentComponent.getStates().size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_VALUE");
                }
            }
            return "";
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return AltaType.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (AltaStatePanel.this._currentComponent == null) {
                return "";
            }
            switch (col) {
                case 0: {
                    return AltaStatePanel.this._currentComponent.getStates().get(row).getName();
                }
                case 1: {
                    return AltaStatePanel.this._currentComponent.getStates().get(row).getType();
                }
                case 2: {
                    return AltaStatePanel.this._currentComponent.getStates().get(row).getDefaultValue();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (AltaStatePanel.this._appl.isReader()) {
                return false;
            }
            if (!AltaStatePanel.this._ctrlTable.isEditable()) {
                return false;
            }
            if (AltaStatePanel.this._ctrlTable.getSelectedRowCount() != 1) {
                return false;
            }
            return col == 0 || col == 2;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }
    }

    public class StateTable
    extends CeciliaTable {
        public boolean _isEditable;

        public StateTable(StateTableModel model) {
            super(model);
            this._isEditable = false;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    StateTable.this._isEditable = false;
                }
            });
        }

        @Override
        public StateTableModel getModel() {
            return (StateTableModel)super.getModel();
        }

        @Override
        protected boolean withSorter() {
            return true;
        }

        @Override
        protected void doubleClickLeft(MouseEvent e) {
            int colView = this.columnAtPoint(e.getPoint());
            int colModel = this.convertColumnIndexToModel(colView);
            if (colModel == 1) {
                AltaStatePanel.this.doEditType();
            } else if (!AltaStatePanel.this._appl.isReader()) {
                this._isEditable = true;
                int rowView = this.rowAtPoint(e.getPoint());
                int rowModel = this.convertRowIndexToModel(rowView);
                if (colModel == 0 || colModel == 2) {
                    AltaStatePanel.this._editingRow = rowModel;
                    AltaStatePanel.this._editingColumn = colModel;
                    this.editCellAt(rowView, colView);
                    Component editor = this.getEditorComponent();
                    if (editor != null) {
                        editor.requestFocus();
                    }
                } else {
                    this._isEditable = false;
                }
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this._isEditable = false;
            super.editingCanceled(e);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this._isEditable = false;
            super.editingStopped(e);
        }

        public boolean isEditable() {
            return this._isEditable;
        }

        public void setEditable(boolean editable) {
            this._isEditable = editable;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            AltaStatePanel.this.selectState();
        }
    }

    public class StateTableCellEditor
    extends DefaultCellEditor {
        JComboBox _combo;

        StateTableCellEditor(JComboBox combo) {
            super(new JComboBox());
            this._combo = combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (row != -1) {
                switch (table.convertColumnIndexToModel(column)) {
                    case 0: {
                        AltaState state = AltaStatePanel.this._currentComponent.getStates().get(table.convertRowIndexToModel(row));
                        AltaStatePanel.this._stateNameEditor.setText(state.getName());
                        return AltaStatePanel.this._stateNameEditor;
                    }
                    case 2: {
                        AltaState state = AltaStatePanel.this._currentComponent.getStates().get(table.convertRowIndexToModel(row));
                        if (state.getType() instanceof AltaTypeInt || state.getType() instanceof AltaTypeFloat) {
                            AltaStatePanel.this._stateNameEditor.setText(state.getDefaultValue());
                            return AltaStatePanel.this._stateNameEditor;
                        }
                        AltaStatePanel.this._stateName.setText(state.getName());
                        this._combo.removeAllItems();
                        AltaType type = state.getType();
                        for (int idx = 0; idx < type.getValueCount(); ++idx) {
                            this._combo.addItem(type.getValueAt(idx));
                        }
                        this._combo.removeItemListener(AltaStatePanel.this._listValueListener);
                        this._combo.setSelectedItem(state.getDefaultValue());
                        this._combo.addItemListener(AltaStatePanel.this._listValueListener);
                        return this._combo;
                    }
                }
                this._combo.removeAllItems();
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static class SelectedType {
        AltaType _type;
        String _default;

        SelectedType(AltaType type, String def) {
            this._type = type;
            this._default = def;
        }
    }
}

