/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.action.UndoManager;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContainer;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.AlgaContentWriterXml;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.DBEquipmentHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.DBEquipmentReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaObjWithName;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeReaderRaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareObjWithNameResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AltaEquipment
extends AltaComponent {
    private static Logger _LOG = Logger.getLogger(AltaEquipment.class.getPackage().getName());
    Map<String, AltaSub> _mapSub;
    ArrayList<AltaSub> _lstSub;
    protected List<AltaSynchro> _lstSynchro;
    List<AltaLink> _lstLink;
    AlgaContent _content;
    public static final int PROP_DEF_MBSA_UNDO_LIMIT = 10;
    private static final String PROP_MBSA_UNDO_LIMIT = "cecilia.mbsa.gui.UndoLimit";
    UndoManager _undoMng;
    boolean _bChangeInternalStructure = false;
    Map<AltaFlow, AlgaPort> _mapPorts = new IdentityHashMap<AltaFlow, AlgaPort>();

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public AltaEquipment(DBFolder dbFolder) {
        super(dbFolder);
        this._mapSub = new LinkedHashMap<String, AltaSub>();
        this._lstSub = new ArrayList();
        this._lstSynchro = new ArrayList<AltaSynchro>();
        this._lstLink = new ArrayList<AltaLink>();
        this._content = new AlgaContent();
        this._undoMng = new UndoManager(Integer.getInteger(PROP_MBSA_UNDO_LIMIT, 10));
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.EQUIPMENT;
    }

    @Override
    protected String getNature() {
        return "equipment";
    }

    @Override
    protected String getRelation() {
        return "OA_EQUIP";
    }

    @Override
    public AltaEquipment getCopy() {
        AltaEquipment dest = new AltaEquipment(this._dbFolder);
        dest.copy(this, (CopyUtility)new CopyUtility.Default());
        return dest;
    }

    protected void copy(AltaEquipment src, CopyUtility util) {
        Object cpy;
        super.copy(src, util);
        Collection<AltaSub> lstSrc = src.getSubs();
        ArrayList<AltaSub> lstCopy = new ArrayList<AltaSub>(lstSrc.size());
        for (AltaSub altaSub : lstSrc) {
            cpy = altaSub.getCopy(util);
            util.setRef((Object)altaSub, cpy);
            lstCopy.add((AltaSub)cpy);
        }
        this.setSubs(lstCopy);
        lstSrc = src.getLinks();
        lstCopy = new ArrayList(lstSrc.size());
        for (AltaLink altaLink : lstSrc) {
            cpy = altaLink.getCopy(util);
            ((AltaLink)cpy).setEquipement(this);
            util.setRef((Object)altaLink, cpy);
            lstCopy.add((AltaSub)cpy);
        }
        this.setLinks(lstCopy);
        lstSrc = src.getSynchros();
        lstCopy = new ArrayList(lstSrc.size());
        for (AltaSynchro altaSynchro : lstSrc) {
            cpy = altaSynchro.getCopy();
            util.setRef((Object)altaSynchro, cpy);
            lstCopy.add((AltaSub)cpy);
        }
        this.setSynchros(lstCopy);
        this._content = src._content.getCopy(true, util);
        for (Map.Entry<AltaFlow, AlgaPort> port : src._mapPorts.entrySet()) {
            AltaFlow flow = (AltaFlow)util.getRef((Object)port.getKey());
            AlgaPort algaPort = (AlgaPort)util.getRef((Object)port.getValue());
            if (flow == null) {
                _LOG.warning("InternalCopyError : Don't find ref for flow " + port.getKey().getName());
                continue;
            }
            if (algaPort == null) {
                _LOG.warning("InternalCopyError : Don't find ref for port " + port.getKey().getName());
                continue;
            }
            this._mapPorts.put(flow, algaPort);
        }
    }

    @Override
    public String toString() {
        if (this._dbFolder == null) {
            return "<null>";
        }
        return this.getAltaRicaName();
    }

    public UndoManager getUndoManager() {
        return this._undoMng;
    }

    public boolean isChangeInternalStructure() {
        return this._bChangeInternalStructure;
    }

    public void setChangeInternalStructure(boolean value) {
        this._bChangeInternalStructure = value;
    }

    public Collection<AltaSub> getSubs() {
        return this._mapSub.values();
    }

    public List<AltaSub> getListSubs() {
        return this._lstSub;
    }

    public void setSubs(Collection<AltaSub> subs) {
        this._mapSub.clear();
        this._lstSub.clear();
        for (AltaSub sub : subs) {
            this._mapSub.put(sub.getName(), sub);
            this._lstSub.add(sub);
        }
        Collections.sort(this._lstSub, AltaSub.getNameComparator());
    }

    public AltaSub getSub(String name) {
        return this._mapSub.get(name);
    }

    private static <T> void insertSortedList(ArrayList<T> list, T element, Comparator<? super T> cmp, int imin, int imax) {
        int itmp = (imin + imax) / 2;
        if (cmp.compare(element, list.get(itmp)) < 0) {
            if (itmp == imin) {
                list.add(itmp, element);
            } else {
                AltaEquipment.insertSortedList(list, element, cmp, imin, itmp);
            }
        } else if (itmp == imin) {
            if (imax == list.size() - 1 && cmp.compare(element, list.get(imax)) > 0) {
                list.add(element);
            } else {
                list.add(imax, element);
            }
        } else {
            AltaEquipment.insertSortedList(list, element, cmp, itmp, imax);
        }
    }

    protected static <T> void insertSortedList(ArrayList<T> list, T add, Comparator<? super T> cmp) {
        if (list.isEmpty()) {
            list.add(add);
        } else {
            AltaEquipment.insertSortedList(list, add, cmp, 0, list.size() - 1);
        }
    }

    public void addSub(AltaSub sub) {
        this._mapSub.put(sub.getName(), sub);
        AltaEquipment.insertSortedList(this._lstSub, sub, AltaObjWithName.getNameComparator());
    }

    public void delSub(AltaSub sub) {
        if (!this._lstSub.remove(sub)) {
            _LOG.severe("Tentative de suppression d'un sous-composant '" + sub.getName() + "' qui n'appartient pas \u00e0 l'\u00e9quipement '" + this.getRefPath() + "' !");
        }
        this._mapSub.remove(sub.getName());
    }

    public List<AltaSynchro> getSynchros() {
        return this._lstSynchro;
    }

    public void setSynchros(List<AltaSynchro> syncs) {
        this._lstSynchro = syncs;
    }

    public List<AltaLink> getLinks() {
        return this._lstLink;
    }

    public void setLinks(List<AltaLink> links) {
        this._lstLink = links;
        for (int i = 0; i < this._lstLink.size(); ++i) {
            this._lstLink.get(i).setEquipement(this);
        }
    }

    public void addLink(AltaLink link) {
        this._lstLink.add(link);
        link.setEquipement(this);
    }

    public void delLink(AltaLink link) {
        if (!this._lstLink.remove(link)) {
            _LOG.severe("Tentative de suppression d'un lien '" + link.toString() + "' qui n'appartient pas \u00e0 l'\u00e9quipement '" + this.getRefPath() + "' !");
        }
    }

    public AlgaContent getContent() {
        return this._content;
    }

    @Override
    protected Set<DBRelation> createRelations(String typeSrc) {
        Set<DBRelation> relations = super.createRelations(typeSrc);
        for (AltaSub sub : this.getSubs()) {
            String typeDest = "OA_COMP";
            if (sub.getNode() instanceof AltaEquipment) {
                typeDest = "OA_EQUIP";
            }
            relations.add(new DBRelation(this._dbFolder, typeSrc, sub.getNode().getDBFolder(), typeDest));
        }
        for (int i = 0; i < this._lstSynchro.size(); ++i) {
            AltaEvent altaEvent = this._lstSynchro.get(i);
            altaEvent.addRelation(this._dbFolder, typeSrc, relations);
        }
        this._content.addRelation(this._dbFolder, typeSrc, relations);
        return relations;
    }

    @Override
    public ObjectWithName getFieldWithName(String name) {
        int i;
        ObjectWithName obj = super.getFieldWithName(name);
        if (obj != null) {
            return obj;
        }
        for (i = this._lstSynchro.size() - 1; i >= 0; --i) {
            obj = this._lstSynchro.get(i);
            if (!obj.getName().equals(name)) continue;
            return obj;
        }
        for (i = this._lstSub.size() - 1; i >= 0; --i) {
            obj = this._lstSub.get(i);
            if (!obj.getName().equals(name)) continue;
            return obj;
        }
        return null;
    }

    public ObjectWithName findFieldFromPath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, ".", true);
        AltaComponent curNode = this;
        String lastToken = st.nextToken();
        if (lastToken.startsWith(".")) {
            return null;
        }
        while (st.hasMoreTokens()) {
            if (curNode instanceof AltaEquipment) {
                AltaSub sub = curNode.getSub(lastToken);
                if (sub == null) {
                    return null;
                }
                curNode = sub.getNode();
                lastToken = st.nextToken();
                if (!lastToken.startsWith(".")) {
                    return null;
                }
                if (lastToken.length() > 1) {
                    return null;
                }
                lastToken = st.nextToken();
                continue;
            }
            return null;
        }
        return ((AltaNode)curNode).getFieldWithName(lastToken);
    }

    @Override
    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = super.update(daoFactory, logMng);
        ArrayList<AltaSub> chgSubs = new ArrayList<AltaSub>(this._lstSub.size());
        for (AltaSub altaSub : this._lstSub) {
            if (!altaSub.update(daoFactory, logMng)) {
                result = false;
                continue;
            }
            chgSubs.add(altaSub);
        }
        if (chgSubs.size() < this._lstSub.size()) {
            this.setSubs(chgSubs);
        }
        for (AltaSynchro obj : this._lstSynchro) {
            if (obj.update(daoFactory, logMng, this)) continue;
            result = false;
        }
        ArrayList<AltaLink> chgLinks = new ArrayList<AltaLink>(this._lstLink.size());
        for (AltaLink altaLink : this._lstLink) {
            if (altaLink.update(logMng)) {
                chgLinks.add(altaLink);
                if (altaLink.verify()) continue;
                result = false;
                continue;
            }
            result = false;
        }
        if (chgLinks.size() < this._lstLink.size()) {
            this.setLinks(chgLinks);
        }
        if (!this._content.update(daoFactory, logMng)) {
            result = false;
        }
        return result;
    }

    public AlgaPort createPort(AltaFlow flow) {
        AlgaPort port = this._mapPorts.get(flow);
        if (port == null) {
            port = new AlgaPort().setFlow(flow).setAutomaticPosition(true);
            this.computeAutomaticPosition(port, flow.getX(), flow.getY());
            this._mapPorts.put(flow, port);
        }
        return port;
    }

    public void addPort(AlgaPort addPort) {
        AlgaPort oldPort = this._mapPorts.get(addPort.getFlow());
        if (oldPort != null) {
            _LOG.severe("Port deja existant pour l'equipement courant:" + addPort.getFlow().getName());
        }
        this._mapPorts.put(addPort.getFlow(), addPort);
    }

    public void deletePort(AltaFlow flow) {
        this._mapPorts.remove(flow);
    }

    public AlgaPort getGraphic(AltaFlow flow) {
        return this._mapPorts.get(flow);
    }

    public void computeAutomaticPosition(AlgaPort port, int fx, int fy) {
        int w = this._content.getWidth();
        int h = this._content.getHeight();
        int margeH = 20 + port.getH() / 2;
        int margeW = 20 + port.getW() / 2;
        if (fx == 0) {
            port.setCX(margeW);
            double y = (double)fy / (double)this.getHeight() * (double)(h - 2 * margeH);
            port.setCY((int)(y + (double)margeH));
        } else if (fx == this.getWidth()) {
            port.setCX(w - margeW);
            double y = (double)fy / (double)this.getHeight() * (double)(h - 2 * margeH);
            port.setCY((int)(y + (double)margeH));
            port.addTransform(AlgaTransform.Type.MIRRORV);
        } else if (fy == 0) {
            port.setCY(margeW);
            double x = (double)fx / (double)this.getWidth() * (double)(w - 2 * margeH);
            port.setCX((int)(x + (double)margeH));
            port.addTransform(AlgaTransform.Type.ROTATE);
            port.addTransform(AlgaTransform.Type.MIRRORH);
        } else if (fy == this.getHeight()) {
            port.setCY(h - margeW);
            double x = (double)fx / (double)this.getWidth() * (double)(w - 2 * margeH);
            port.setCX((int)(x + (double)margeH));
            port.addTransform(AlgaTransform.Type.ROTATE);
        } else {
            _LOG.info("Positionnement automatique incoherent pour le port:" + port.getFlow().getName());
            double x = (double)fx / (double)this.getWidth() * (double)(w - 2 * margeH);
            port.setCX((int)(x + (double)margeH));
            double y = (double)fy / (double)this.getHeight() * (double)(h - 2 * margeH);
            port.setCY((int)(y + (double)margeH));
        }
    }

    @Override
    public String getAltaRicaName() {
        StringBuilder dbPath = new StringBuilder(64);
        dbPath.append("eq");
        this._dbFolder.getParent().getPathUntilSystem(dbPath);
        return dbPath.toString().replace('/', '_');
    }

    @Override
    protected void writeAltaRicaDeclaration(Appendable out, boolean expandLink) throws IOException {
        out.append("node ").append(this.getAltaRicaName()).append("\n");
        this.writeAltaRicaFlows(out, expandLink);
        if (!this._lstSynchro.isEmpty()) {
            out.append(" event\n");
            for (AltaEvent altaEvent : this._lstSynchro) {
                out.append("  ").append(altaEvent.getName()).append(";\n");
            }
        }
        if (!this.getSubs().isEmpty()) {
            out.append(" sub\n");
            for (AltaSub altaSub : this.getSubs()) {
                out.append("  ").append(altaSub.getName()).append(" : ");
                out.append(altaSub.getNode().getAltaRicaName()).append(";\n");
            }
        }
    }

    @Override
    protected void writeAltaRicaDefinition(Appendable out) throws IOException {
        if (!this._lstSynchro.isEmpty()) {
            out.append(" sync\n");
            for (AltaSynchro sync : this._lstSynchro) {
                out.append("  <").append(sync.getName());
                List<String> events = sync.getEvents();
                String sep = sync.getSeparator();
                for (int i = 0; i < events.size(); ++i) {
                    out.append(sep).append(events.get(i));
                }
                out.append("> ;\n");
            }
        }
        if (!this._lstLink.isEmpty()) {
            out.append(" assert\n");
            for (AltaLink link : this._lstLink) {
                link.appendTo(out.append("  "));
                link.appendFrom(out.append(" = ")).append(" ;\n");
            }
        }
    }

    @Override
    protected void writeAltaRicaExtern(Appendable out) throws IOException {
        StringBuilder outEvents = new StringBuilder();
        for (AltaEvent altaEvent : this._lstSynchro) {
            altaEvent.writeAltaRicaExtern(outEvents);
        }
        if (outEvents.length() > 0) {
            out.append(" extern\n").append(outEvents.toString());
        }
    }

    @Override
    protected void doGenerateCode(File file, GenerateAltaricaCode generator) {
        generator.generateEquipment(this, file);
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        this.toXML_Header(out, "cec.equipment", indent);
        this.toXML_Content(out, indent);
        this.toXML_Footer(out, "cec.equipment", indent);
    }

    protected void toXML_Content(Appendable out, String indent) throws IOException {
        int i;
        String indent1 = indent + "  ";
        for (AltaSub sub : this.getSubs()) {
            if (sub.getGraphic() == null) {
                _LOG.warning("Presence d'un sub sans lien graphique : " + sub.getName());
                continue;
            }
            out.append(indent).append("  <").append("alta.sub");
            DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), sub.getName()).append("'");
            DBObjectXmlUtility.writeDBFolder(out, sub.getNode().getDBFolder(), null);
            out.append("/>\n");
        }
        for (i = 0; i < this._lstLink.size(); ++i) {
            AltaLink link = this._lstLink.get(i);
            link.setID(i);
            link.toXML(out, indent1);
        }
        for (i = 0; i < this._lstSynchro.size(); ++i) {
            this._lstSynchro.get(i).toXML(out, indent1);
        }
        AlgaContentWriterXml writer = new AlgaContentWriterXml(out, this._content, this);
        writer.write(indent1);
    }

    @Override
    protected DBNodeHandlerXml createHandlerXml(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        return new DBEquipmentHandlerXml(logMng, null, cecFactory);
    }

    @Override
    protected void copyFromHandlerXml(DBNodeHandlerXml saxHandler, DBLogs.DBLogsManager logMng) {
        DBEquipmentHandlerXml xmlHandler = (DBEquipmentHandlerXml)saxHandler;
        super.copyFromHandlerXml(saxHandler, logMng);
        this._lstSynchro = new ArrayList<AltaSynchro>(xmlHandler.getSyncs());
        this.setSubs(xmlHandler.getSubs());
        this.setLinks(new ArrayList<AltaLink>(xmlHandler.getLinks()));
        this._content = xmlHandler.getContent();
        for (AltaLink link : this._lstLink) {
            if (link.verify()) continue;
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_INVALID", link), true);
        }
        this.verifyPostRead();
    }

    @Override
    protected DBNodeReaderRaw createReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        return new DBEquipmentReaderRaw(dbFolder, logMng);
    }

    @Override
    protected void copyFromReaderRaw(DBNodeReaderRaw nodeReaderRaw, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        DBEquipmentReaderRaw readerRaw = (DBEquipmentReaderRaw)nodeReaderRaw;
        super.copyFromReaderRaw(readerRaw, cecFactory, logMng);
        this._lstSynchro = new ArrayList<AltaSynchro>(readerRaw.getSyncs());
        this.setSubs(readerRaw.getSubs());
        this.setLinks(new ArrayList<AltaLink>(readerRaw.getLinks()));
        ArrayList<AlgaSheet> sheets = new ArrayList<AlgaSheet>(readerRaw.getSheets());
        if (sheets.size() == 0) {
            this.logMsg("Il n'y a pas de calque", Level.FINE);
            sheets.add(new AlgaSheet(1, "Default layeur", 1, true, true));
        }
        this._content.setSheets(sheets);
        this.verifyPostRead();
    }

    private void verifyPostRead() {
        this.defineCurrentSheet();
        this._content.computeSize(null);
        this.verifyEquipmentPort();
        this.computeControlPoints();
    }

    private void defineCurrentSheet() {
        if (this._content.getCurrentSheet() != null) {
            return;
        }
        AlgaSheet firstSelected = null;
        AlgaSheet firstValid = null;
        for (AlgaSheet sheet : this._content.getSheets()) {
            if (firstValid != null || !sheet.isSelected()) continue;
            if (sheet.isVisible()) {
                firstValid = sheet;
                break;
            }
            _LOG.info("Le calque courant ne semble pas visible.");
            if (firstSelected != null) continue;
            firstSelected = sheet;
        }
        if (firstValid == null) {
            firstValid = firstSelected;
        }
        if (firstValid == null) {
            _LOG.info("Aucun calque courant.");
            firstValid = this._content.getSheets().get(0);
        }
        this._content.setCurrentSheet(firstValid);
    }

    private void verifyEquipmentPort() {
        this._mapPorts.clear();
        for (AlgaSheet sheet : this._content.getSheets()) {
            this.verifyEquipmentPort(sheet);
        }
        for (AltaFlow flow : this.getFlows()) {
            if (flow.getOrientation() == AltaFlow.Orientation.LOCAL || this._mapPorts.containsKey(flow)) continue;
            _LOG.fine("Aucun port n'est defini pour le flux: " + flow.getName());
            AlgaPort port = this.createPort(flow);
            this._content.getCurrentSheet().add(port, Integer.MAX_VALUE);
        }
    }

    private void verifyEquipmentPort(AlgaContainer sheet) {
        for (AlgaGraph grf : sheet.getGraphs()) {
            if (grf instanceof AlgaContainer) {
                this.verifyEquipmentPort((AlgaContainer)grf);
            }
            if (!(grf instanceof AlgaPort)) continue;
            AlgaPort port = (AlgaPort)grf;
            if (this._mapPorts.containsKey(port.getFlow())) {
                _LOG.warning("Un port est deja defini au sein d'un equipement: " + port.getFlow().getName());
                continue;
            }
            this._mapPorts.put(port.getFlow(), port);
        }
    }

    public void computeControlPoints() {
        for (AlgaSheet sheet : this._content.getSheets()) {
            this.computeControlPoints(sheet);
        }
    }

    private void computeControlPoints(AlgaContainer sheet) {
        for (AlgaGraph grf : sheet.getGraphs()) {
            if (grf instanceof AlgaContainer) {
                this.computeControlPoints((AlgaContainer)grf);
            }
            grf.computeControlPoints();
        }
    }

    public void updateLinksLogs(String login, List<AltaLink> links) {
        if (links == null) {
            return;
        }
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(login, this.getLogs());
        for (AltaLink link : links) {
            String nameLink = link.toString();
            String msgError = ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_INVALID", nameLink);
            DBLogs.Log log = logMng.getLog(DBLogs.DBLevel.ERROR, msgError);
            if (!link.verify() && log == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, msgError, true);
                continue;
            }
            if (this.getLinks().contains(link) && !link.verify() || log == null) continue;
            logMng.removeLog(log);
        }
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                Function<AltaEquipment, String> func = eqp -> {
                    if (eqp.getLinks() == null) {
                        return "";
                    }
                    List listLinks = eqp.getLinks().stream().map(e -> e.toString()).sorted().collect(Collectors.toList());
                    StringBuilder sb = new StringBuilder();
                    for (String link : listLinks) {
                        sb.append(link).append('\n');
                    }
                    if (sb.length() > 0) {
                        sb.setLength(sb.length() - 1);
                    }
                    return sb.toString();
                };
                return new CompareResultString(ResMsgVoc.getString("VOC_LINK"), func.apply(AltaEquipment.this), func.apply((AltaEquipment)wrap));
            }
        });
        return list;
    }

    @Override
    public DBComparaisons getCompareConflict(DAOFactory factoryWrap, DBWrap wrap, boolean forImport) {
        DBComparaisons comparaisons = super.getCompareConflict(factoryWrap, wrap, forImport);
        CompareUtils.addConflictInDBWrap(comparaisons, this, wrap, ResMsgVoc.getString("VOC_SYNCS"), obj -> ((ObjectWithName)obj).getName(), equip -> ((AltaEquipment)equip).getSynchros(), CompareObjWithNameResult.class);
        CompareUtils.addConflictInDBWrap(comparaisons, this, wrap, ResMsgVoc.getString("VOC_GRAPHICS"), obj -> ((ObjectWithName)obj).getName(), equip -> ((AltaEquipment)equip).getListSubs(), CompareObjWithNameResult.class);
        return comparaisons;
    }
}

