/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.DBIconRenderer;
import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaObjWithName;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.List;

public class AltaSub
extends AltaObjWithName {
    AltaComponent _node;
    AlgaNode _graphic;
    int _x;
    int _y;
    boolean _isEquipment;

    public AltaSub(AltaComponent node, String name) {
        super(name);
        this._node = node;
        this._graphic = null;
        this._y = 0;
        this._x = 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AltaSub)) {
            return false;
        }
        AltaSub other = (AltaSub)obj;
        if (!this.getNode().equals(other.getNode())) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        return this.getY() == other.getY();
    }

    @Override
    public int hashCode() {
        int hash = this._node.hashCode();
        hash = hash * 3 + this._name.hashCode();
        hash = hash * 5 + this._x;
        hash = hash * 7 + this._y;
        return hash;
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public AltaSub setX(int x) {
        this._x = x;
        return this;
    }

    public AltaSub setY(int y) {
        this._y = y;
        return this;
    }

    public AltaComponent getNode() {
        return this._node;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public AltaSub setName(String name) {
        this._name = name;
        return this;
    }

    public void setEquipment(boolean isEquipement) {
        this._isEquipment = isEquipement;
    }

    public AlgaNode getGraphic() {
        return this._graphic;
    }

    public AltaSub setGraphic(AlgaNode graph) {
        this._graphic = graph;
        return this;
    }

    public void paint(Graphics g) {
        Color oldColor = g.getColor();
        DBIconRenderer dbIconRenderer = this._node.getIconRenderer();
        dbIconRenderer.paint((Graphics2D)g, this._x, this._y, this._node.getWidth(), this._node.getHeight());
        List<AltaFlow> flows = this._node.getFlows();
        if (!flows.isEmpty()) {
            for (int i = 0; i < flows.size(); ++i) {
                AltaFlow flow = flows.get(i);
                if (flow.getOrientation() == AltaFlow.Orientation.LOCAL) continue;
                if (flow.getOrientation() == AltaFlow.Orientation.IN) {
                    g.setColor(Color.white);
                    g.fillRect(this._x + flow.getX() - 3, this._y + flow.getY() - 3, 6, 6);
                }
                if (flow.isSelected()) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                if (flow.getOrientation() == AltaFlow.Orientation.OUT) {
                    g.drawRect(this._x + flow.getX() - 3, this._y + flow.getY() - 3, 6, 6);
                    g.fillRect(this._x + flow.getX() - 3, this._y + flow.getY() - 3, 6, 6);
                    continue;
                }
                g.drawRect(this._x + flow.getX() - 3, this._y + flow.getY() - 3, 6, 6);
            }
        }
        g.setColor(oldColor);
        this.paintLabel(g);
    }

    @Override
    public AltaSub getCopy() {
        AltaSub comp = new AltaSub(this._node, this._name);
        comp.copy(this);
        return comp;
    }

    public AltaSub getCopy(CopyUtility util) {
        AltaSub comp = new AltaSub(this._node, this._name);
        comp.copy(this);
        util.setRef((Object)this, (Object)comp);
        return comp;
    }

    protected void copy(AltaSub src) {
        this._x = src._x;
        this._y = src._y;
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        this._node = (AltaComponent)DBWrap.createOrFind(daoFactory, this._node.getDBFolder(), logMng, AltaComponent.class);
        return this._node != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(" [").append(this.getX()).append(',').append(this.getY()).append(']');
        return sb.toString();
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        String nature = this._node instanceof AltaEquipment ? ResMsgVoc.getString("VOC_EQUIPMENT") : ResMsgVoc.getString("VOC_COMPONENT");
        sb.append(CompareUtils.getTextForCompare(nature, this._node.getRefPath()));
        if (this.getGraphic() != null) {
            StringBuilder coords = new StringBuilder();
            if (this.getGraphic().getParent() instanceof AlgaSheet) {
                coords.append('(').append(((AlgaSheet)this.getGraphic().getParent()).getName()).append(") ");
            }
            coords.append('[').append(this.getGraphic().getX()).append(';').append(this.getGraphic().getY()).append(']');
            sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_COORDINATES"), coords.toString()));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLabel(Graphics g) {
        if (this._node.getTextPosition() == NamePosition.NONE) {
            return;
        }
        Font font = g.getFont();
        if (this._isEquipment) {
            font = font.deriveFont(Collections.singletonMap(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD));
        }
        String name = this._name;
        Rectangle rect = this.prepareTextBounds(g, font, name);
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        try {
            g.setColor(g.getColor());
            g.setFont(font);
            g.drawString(name, (int)Math.round(rect.getX()), (int)Math.round(rect.getY()));
        }
        finally {
            g.setColor(oldColor);
            g.setFont(oldFont);
        }
    }

    private Rectangle prepareTextBounds(Graphics g, Font f, String name) {
        FontMetrics fmetrics = g.getFontMetrics(f);
        int x = this._x;
        int y = this._y;
        int w = this._node.getWidth();
        int h = this._node.getHeight();
        int wtext = fmetrics.stringWidth(name);
        int htext = fmetrics.getHeight();
        NamePosition np = this._node.getTextPosition();
        switch (np) {
            default: {
                x += (w - wtext) / 2;
                y -= 3;
                break;
            }
            case BOTTOM: {
                x += (w - wtext) / 2;
                y = y + h + htext;
                break;
            }
            case NONE: {
                htext = 0;
                wtext = 0;
                x = this.getX() + w / 2;
                y = this.getY() + h / 2;
                break;
            }
            case CENTER: {
                x += (w - wtext) / 2;
                y += (h + htext) / 2;
                break;
            }
            case RIGHT: {
                x = x + w + 3;
                y += (h + htext) / 2;
                break;
            }
            case LEFT: {
                x = x - wtext - 3;
                y += (h + htext) / 2;
            }
        }
        return new Rectangle(x, y, wtext, htext);
    }
}

