/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaImage;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public abstract class AlgaContainer
extends AlgaGraph {
    ArrayList<AlgaGraph> _graphs = new ArrayList();

    public Collection<AlgaGraph> getGraphs() {
        return this._graphs;
    }

    public void setGraphs(Collection<AlgaGraph> graphs) {
        this._graphs = new ArrayList<AlgaGraph>(graphs);
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            this._graphs.get(i).setParent(this);
        }
    }

    public int indexOf(AlgaGraph grf) {
        return this._graphs.indexOf(grf);
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        return "";
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaContainer) {
            AlgaContainer src = (AlgaContainer)grfsrc;
            if (withDepth) {
                this._graphs = new ArrayList(src.getGraphs().size());
                for (AlgaGraph grf : src.getGraphs()) {
                    if (!util.selectForCopy((Object)grf)) continue;
                    AlgaGraph cpy = grf.getCopy(withDepth, util);
                    this._graphs.add(cpy);
                    cpy.setParent(this);
                }
            } else {
                this._graphs = new ArrayList<AlgaGraph>(src.getGraphs());
            }
        }
    }

    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        int nbrGrf = this._graphs.size();
        switch (context.getLinkDisplay()) {
            case FG: {
                AlgaGraph graph;
                int i;
                for (i = 0; i < nbrGrf; ++i) {
                    graph = this._graphs.get(i);
                    if (graph.isLink()) continue;
                    graph.paint(g, context);
                }
                for (i = 0; i < nbrGrf; ++i) {
                    graph = this._graphs.get(i);
                    if (!graph.isLink()) continue;
                    graph.paint(g, context);
                }
                break;
            }
            case BG: {
                AlgaGraph graph;
                int i;
                for (i = 0; i < nbrGrf; ++i) {
                    graph = this._graphs.get(i);
                    if (!graph.isLink()) continue;
                    graph.paint(g, context);
                }
                for (i = 0; i < nbrGrf; ++i) {
                    graph = this._graphs.get(i);
                    if (graph.isLink()) continue;
                    graph.paint(g, context);
                }
                break;
            }
            case RELATIVE: {
                for (int i = 0; i < nbrGrf; ++i) {
                    this._graphs.get(i).paint(g, context);
                }
                break;
            }
        }
    }

    public void add(AlgaGraph graph, int idx) {
        if (idx == Integer.MAX_VALUE) {
            this._graphs.add(graph);
        } else if (idx < 0) {
            this._graphs.add(0, graph);
        } else {
            this._graphs.add(idx, graph);
        }
        graph.setParent(this);
    }

    public int remove(AlgaGraph graph) {
        int idx = this._graphs.indexOf(graph);
        if (idx >= 0) {
            this._graphs.remove(idx).setParent(null);
        }
        return idx;
    }

    @Override
    public void translate(int deltaX, int deltaY) {
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            this._graphs.get(i).translate(deltaX, deltaY);
        }
    }

    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaGraph grf = this._graphs.get(i);
            if (grf instanceof AlgaContainer) {
                ((AlgaContainer)grf).addRelation(dbSrcFolder, typeSrcRelation, relations);
            }
            if (!(grf instanceof AlgaImage)) continue;
            DBFolder dbImgFolder = ((AlgaImage)grf).getDBIcon().getDBFolder();
            relations.add(new DBRelation(dbSrcFolder, typeSrcRelation, dbImgFolder, "OA_IMAG"));
        }
    }

    @Override
    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = true;
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaGraph grf = this._graphs.get(i);
            if (grf.update(daoFactory, logMng)) continue;
            this._graphs.remove(i).setParent(null);
            result = false;
        }
        return result;
    }
}

