/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Rectangle;

public abstract class AlgaDraw
extends AlgaGraph {
    int _cx;
    int _cy;
    int _w;
    int _h;
    AlgaTransform _transform;
    transient Rectangle _selectBounds = new Rectangle();

    public AlgaDraw() {
        this._transform = new AlgaTransform();
    }

    public int getCX() {
        return this._cx;
    }

    @Override
    public int getX() {
        if (this._transform.isRotate()) {
            return this._cx - this.getH() / 2;
        }
        return this._cx - this.getW() / 2;
    }

    @Override
    public void setX(int x) {
        this._cx = this._transform.isRotate() ? x + this.getH() / 2 : x + this.getW() / 2;
    }

    public AlgaDraw setCX(int cx) {
        this._cx = cx;
        return this;
    }

    public int getCY() {
        return this._cy;
    }

    @Override
    public int getY() {
        if (this._transform.isRotate()) {
            return this._cy - this.getW() / 2;
        }
        return this._cy - this.getH() / 2;
    }

    @Override
    public void setY(int y) {
        this._cy = this._transform.isRotate() ? y + this.getW() / 2 : y + this.getH() / 2;
    }

    public AlgaDraw setCY(int cy) {
        this._cy = cy;
        return this;
    }

    @Override
    public int getW() {
        return this._w;
    }

    public AlgaDraw setW(int w) {
        this._w = w;
        return this;
    }

    @Override
    public int getWUser() {
        if (this._transform.isRotate()) {
            return this.getH();
        }
        return this.getW();
    }

    public AlgaDraw setWUser(int w) {
        if (this._transform.isRotate()) {
            return this.setH(w);
        }
        return this.setW(w);
    }

    @Override
    public int getH() {
        return this._h;
    }

    public AlgaDraw setH(int h) {
        this._h = h;
        return this;
    }

    @Override
    public int getHUser() {
        if (this._transform.isRotate()) {
            return this.getW();
        }
        return this.getH();
    }

    public AlgaDraw setHUser(int h) {
        if (this._transform.isRotate()) {
            return this.setW(h);
        }
        return this.setH(h);
    }

    public void addTransform(AlgaTransform.Type typeTransform) {
        this._transform.add(typeTransform);
    }

    public AlgaTransform getTransform() {
        return this._transform;
    }

    public AlgaDraw setTransform(AlgaTransform trsf) {
        this._transform = trsf;
        return this;
    }

    @Override
    public Rectangle getSelectBounds() {
        return this._selectBounds;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaDraw) {
            AlgaDraw src = (AlgaDraw)grfsrc;
            this._cx = src._cx;
            this._cy = src._cy;
            this._w = src._w;
            this._h = src._h;
            this._transform = src._transform.getCopy();
            this._selectBounds = new Rectangle(src.getSelectBounds());
        }
    }

    @Override
    public void computeControlPoints() {
        if (this._transform.isRotate()) {
            this._selectBounds.x = this._cx - this.getH() / 2;
            this._selectBounds.y = this._cy - this.getW() / 2;
            this._selectBounds.width = this.getH();
            this._selectBounds.height = this.getW();
        } else {
            this._selectBounds.x = this._cx - this.getW() / 2;
            this._selectBounds.y = this._cy - this.getH() / 2;
            this._selectBounds.width = this.getW();
            this._selectBounds.height = this.getH();
        }
    }

    @Override
    public void translate(int deltaX, int deltaY) {
        this._cx += deltaX;
        this._cy += deltaY;
    }
}

