/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContainer;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;

public abstract class AlgaGraph {
    public static final int HITPOINT_NONE = -10;
    public static final int HITPOINT_RECT = -9;
    public static final int HITPOINT_SELECT = -1;
    public static final int HITPOINT_TOPLEFT = 0;
    public static final int HITPOINT_TOPRIGHT = 1;
    public static final int HITPOINT_BOTTOMRIGHT = 2;
    public static final int HITPOINT_BOTTOMLEFT = 3;
    public static final int PORT_SIZE = 6;
    AlgaContainer _parent = null;
    boolean _locked = false;
    boolean _selected;
    Color _background;
    Color _foreground;
    boolean _opaque;
    int _flag = 0;

    protected void copy(AlgaGraph src, boolean withDepth, CopyUtility util) {
        this._locked = src._locked;
        this._selected = src._selected;
        if (src._background != null) {
            this._background = new Color(src._background.getRGB());
        }
        if (src._foreground != null) {
            this._foreground = new Color(src._foreground.getRGB());
        }
        this._opaque = src._opaque;
    }

    public int getX() {
        return -1;
    }

    public int getY() {
        return -1;
    }

    public int getW() {
        return -1;
    }

    public int getWUser() {
        return this.getW();
    }

    public int getH() {
        return -1;
    }

    public int getHUser() {
        return this.getH();
    }

    public boolean isLink() {
        return false;
    }

    public boolean isVisio() {
        return false;
    }

    public void setX(int x) {
        throw new UnsupportedOperationException();
    }

    public void setY(int y) {
        throw new UnsupportedOperationException();
    }

    public Rectangle getBounds(Graphics g) {
        return this.getSelectBounds();
    }

    public Shape getSelectShape() {
        return new Rectangle(this.getSelectBounds());
    }

    public abstract Rectangle getSelectBounds();

    public abstract AlgaGraph getCopy(boolean var1, CopyUtility var2);

    public abstract void computeControlPoints();

    public abstract void paint(Graphics2D var1, AlgaContext var2);

    public abstract void translate(int var1, int var2);

    public abstract String getTooltip(AltaEquipment var1, int var2, int var3);

    public AlgaContainer getParent() {
        return this._parent;
    }

    public AlgaGraph setParent(AlgaContainer parent) {
        this._parent = parent;
        return this;
    }

    public boolean isLocked() {
        return this._locked;
    }

    public AlgaGraph setLocked(boolean locked) {
        this._locked = locked;
        return this;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public AlgaGraph setSelected(boolean selected) {
        if (this._selected != selected) {
            this._selected = selected;
        }
        return this;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public AlgaGraph setForeground(Color color) {
        this._foreground = color;
        return this;
    }

    public boolean isOpaque() {
        return this._opaque;
    }

    public AlgaGraph setOpaque(boolean opaque) {
        this._opaque = opaque;
        return this;
    }

    public int getBackgroundCode() {
        if (this._opaque) {
            return -1;
        }
        return this._background.getRGB();
    }

    public Color getBackground() {
        return this._background;
    }

    public AlgaGraph setBackground(Color color) {
        this._background = color;
        return this;
    }

    public int getFlag() {
        return this._flag;
    }

    public void setFlag(int flag) {
        this._flag = flag;
    }

    public void paintSelectionCorner(Graphics2D g, AlgaContext context, int rectx, int recty, int rectwidth, int rectheight) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setStroke(context.getStroke(2, -1, -1, false));
        g.setColor(context.getColorSelect(this.isLocked()));
        int m = 3;
        int x = rectx;
        int y = recty;
        g.drawLine(x - m, y, x - m, y - m);
        g.drawLine(x - m, y - m, x, y - m);
        g.drawLine(x += rectwidth, y - m, x + m, y - m);
        g.drawLine(x + m, y - m, x + m, y);
        g.drawLine(x + m, y += rectheight, x + m, y + m);
        g.drawLine(x + m, y + m, x, y + m);
        g.drawLine(x -= rectwidth, y + m, x - m, y + m);
        g.drawLine(x - m, y + m, x - m, y);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    public void paintSelectionCorner(Graphics2D g, AlgaContext context, Rectangle rect) {
        this.paintSelectionCorner(g, context, rect.x, rect.y, rect.width, rect.height);
    }

    protected boolean isAround(int cx, int cy, int x, int y) {
        if (Math.abs(cx - x) > 4) {
            return false;
        }
        return Math.abs(cy - y) <= 4;
    }

    protected int getHitBound(Rectangle r, int x, int y) {
        if (this.isAround(r.x, r.y, x, y)) {
            return 0;
        }
        if (this.isAround(r.x + r.width, r.y, x, y)) {
            return 1;
        }
        if (this.isAround(r.x + r.width, r.y + r.height, x, y)) {
            return 2;
        }
        if (this.isAround(r.x, r.y + r.height, x, y)) {
            return 3;
        }
        return -10;
    }

    protected int getHitPoint(int x, int y) {
        Rectangle r = this.getSelectBounds();
        if (this.isSelected()) {
            int result;
            Rectangle possible = new Rectangle(r);
            possible.grow(4, 4);
            if (possible.contains(x, y) && (result = this.getHitBound(r, x, y)) != -10) {
                return result;
            }
        }
        if (this.contains(x, y)) {
            return -1;
        }
        return -10;
    }

    public boolean contains(int x, int y) {
        return this.getSelectBounds().contains(x, y);
    }

    public AltaContentView.DelegateMouse getCtrlMouse(int x, int y, AltaContentView view) {
        return null;
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        return true;
    }
}

