/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContainer;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AlgaGroup
extends AlgaContainer {
    Rectangle _bound = new Rectangle();

    @Override
    public int getX() {
        return this._bound.x;
    }

    @Override
    public int getY() {
        return this._bound.y;
    }

    @Override
    public int getW() {
        return this._bound.width;
    }

    @Override
    public int getH() {
        return this._bound.height;
    }

    @Override
    public Rectangle getSelectBounds() {
        return this._bound;
    }

    @Override
    public AlgaGroup getCopy(boolean withDepth, CopyUtility util) {
        AlgaGroup result = new AlgaGroup();
        result.copy(this, withDepth, util);
        return result;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaGroup) {
            AlgaGroup src = (AlgaGroup)grfsrc;
            this._bound = new Rectangle(src.getSelectBounds());
        }
    }

    @Override
    public boolean isVisio() {
        return true;
    }

    @Override
    public void computeControlPoints() {
        int ymin = Integer.MAX_VALUE;
        int xmin = Integer.MAX_VALUE;
        int ymax = 0;
        int xmax = 0;
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaGraph graph = (AlgaGraph)this._graphs.get(i);
            graph.computeControlPoints();
            Rectangle rect = graph.getSelectBounds();
            int x = rect.x;
            if (x < 0) {
                System.out.println("X<0: " + graph.toString());
            } else if (x < xmin) {
                xmin = x;
            }
            int y = rect.y;
            if (y < 0) {
                System.out.println("Y<0: " + graph.toString());
            } else if (y < ymin) {
                ymin = y;
            }
            if ((x += rect.width) > xmax) {
                xmax = x;
            }
            if ((y += rect.height) <= ymax) continue;
            ymax = y;
        }
        this._bound.x = xmin;
        this._bound.y = ymin;
        this._bound.width = xmax - xmin;
        this._bound.height = ymax - ymin;
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        return "[Group]";
    }

    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        super.paint(g, context);
        if (this.isSelected() && context.isDisplay()) {
            this.paintSelectionCorner(g, context, this._bound);
        }
    }
}

