/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse.DelegateMousePathMovePoint;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.Iterator;

public class AlgaLink
extends AlgaPoints {
    AltaLink _logLink = null;
    boolean _bDrawArrow = false;
    boolean _bPipeStyle = false;
    transient String _tooltipLink;
    private static final int ARROW_SIZE = 8;
    private static final double NOARROW_DISTANCE = 24.0;
    private static GeneralPath ARROW_SHAPE = new GeneralPath();

    @Override
    public boolean isLink() {
        return true;
    }

    public AltaLink getLogical() {
        return this._logLink;
    }

    public AlgaLink setLogical(AltaLink logLink) {
        if (logLink == null) {
            throw new NullPointerException();
        }
        this._logLink = logLink;
        return this;
    }

    @Override
    public AlgaLink getCopy(boolean withDepth, CopyUtility util) {
        AlgaLink result = new AlgaLink();
        result.copy(this, withDepth, util);
        return result;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaLink) {
            AlgaLink src = (AlgaLink)grfsrc;
            this.setLogical((AltaLink)util.getRef((Object)src.getLogical()));
            this._bDrawArrow = src._bDrawArrow;
            this._bPipeStyle = src._bPipeStyle;
            this._tooltipLink = src._tooltipLink;
        }
    }

    @Override
    public AlgaGraph setSelected(boolean selected) {
        if (!selected) {
            Iterator<Pt> iterPt = this.iteratePoint();
            while (iterPt.hasNext()) {
                iterPt.next().setSelected(false);
            }
        }
        return super.setSelected(selected);
    }

    @Override
    public int getNbrPoints() {
        return super.getNbrPoints() + 2;
    }

    @Override
    protected boolean pointContains(int x, int y) {
        Pt pt = this.getFirstPt();
        if (Math.abs(pt._x - x) <= 3 && Math.abs(pt._y - y) <= 3) {
            return false;
        }
        pt = this.getLastPt();
        if (Math.abs(pt._x - x) <= 3 && Math.abs(pt._y - y) <= 3) {
            return false;
        }
        return super.pointContains(x, y);
    }

    public Pt getFirstPt() {
        AlgaWithPorts node = this._logLink.getFromGraphic();
        return node.getPoint(this._logLink.getFromFlow());
    }

    public Pt getLastPt() {
        AlgaWithPorts node = this._logLink.getToGraphic();
        return node.getPoint(this._logLink.getToFlow());
    }

    @Override
    public Iterator<Pt> iteratePoint() {
        return new LinkPointIterator(super.iteratePoint());
    }

    @Override
    public void insertPoint(Pt point, int index) {
        this._points.add(index - 1, point);
    }

    @Override
    public Pt removePoint(int index) {
        return (Pt)this._points.remove(index - 1);
    }

    public boolean isDrawArrow() {
        return this._bDrawArrow;
    }

    public AlgaLink setDrawArrow(boolean arrow) {
        this._bDrawArrow = arrow;
        return this;
    }

    public boolean isPipeStyle() {
        return this._bPipeStyle;
    }

    public AlgaLink setPipeStyle(boolean pipe) {
        this._bPipeStyle = pipe;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._logLink == null) {
            sb.append("null => null");
        } else {
            sb.append(this._logLink.toString());
        }
        sb.append(" ");
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public void computeControlPoints() {
        super.computeControlPoints();
        StringBuilder sb = new StringBuilder();
        try {
            this._logLink.appendFrom(sb);
            if (this._logLink.isRecord()) {
                if (((DBRecord)this._logLink.getFromFlow().getType()).hasInverseField()) {
                    sb.append(" <=> ");
                } else {
                    sb.append("  => ");
                }
            } else {
                sb.append("  -> ");
            }
            this._logLink.appendTo(sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._tooltipLink = sb.toString();
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        return this._tooltipLink;
    }

    public String getTooltip() {
        return this._tooltipLink;
    }

    @Override
    public AltaContentView.DelegateMouse getCtrlMouse(int x, int y, AltaContentView view) {
        int result;
        if (!this.isLocked() && this.isSelected() && view instanceof AltaContentEditView && (result = this.getHitPoint(x, y, false)) != -10 && result != 0 && result != this.getNbrPoints() * 2) {
            return new DelegateMousePathMovePoint(this, result);
        }
        return super.getCtrlMouse(x, y, view);
    }

    protected Color getColor(AlgaContext context) {
        return context.getColorLink(this._logLink, this.isSelected(), this.isLocked());
    }

    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        this.paintLink(g, context);
        if (context.itsCompatiblePolicyLabel(AlgaContext.PolicyLabel.LINK)) {
            this.paintLabel(g, context);
        }
        if (this.isDrawArrow()) {
            this.paintArrows(g, context);
        }
        if (context.isDisplay() && this.isSelected()) {
            this.paintSelection(g, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintLink(Graphics2D g, AlgaContext context) {
        block15: {
            boolean withStyle = false;
            GeneralPath path = new GeneralPath();
            Iterator<Pt> iterPt = this.iteratePoint();
            Pt pt = iterPt.next();
            path.moveTo(pt.getX(), pt.getY());
            while (iterPt.hasNext()) {
                pt = iterPt.next();
                withStyle |= pt.getStyle() != Pt.Style.NONE;
                path.lineTo(pt.getX(), pt.getY());
            }
            Stroke oldStroke = g.getStroke();
            Color oldColor = g.getColor();
            try {
                if (this._logLink.isRecord()) {
                    g.setStroke(context.getStroke(5, -1, -1, false));
                } else {
                    g.setStroke(context.getStroke(3, -1, -1, false));
                }
                g.setColor(Color.white);
                g.draw(path);
                if (this._logLink.isRecord()) {
                    g.setStroke(context.getStroke(3, -1, -1, false));
                } else {
                    g.setStroke(context.getStroke(1, -1, -1, false));
                }
                g.setColor(this.getColor(context));
                g.draw(path);
                if (this._logLink.isRecord() && this.isPipeStyle()) {
                    g.setStroke(context.getStroke(1, -1, -1, false));
                    g.setColor(Color.white);
                    g.draw(path);
                }
                g.setColor(this.getColor(context));
                if (!withStyle) break block15;
                Iterator<Pt> iterPt2 = this.iteratePoint();
                iterPt2.next();
                while (iterPt2.hasNext()) {
                    Pt next = iterPt2.next();
                    if (!iterPt2.hasNext()) {
                        break;
                    }
                    switch (next.getStyle()) {
                        case RECT: {
                            g.fillRect(next._x - 3, next._y - 3, 6, 6);
                            break;
                        }
                        case CIRCLE: {
                            g.fillOval(next._x - 3, next._y - 3, 6, 6);
                            break;
                        }
                    }
                }
            }
            finally {
                g.setStroke(oldStroke);
                g.setColor(oldColor);
            }
        }
    }

    protected String getLabel() {
        if (this._logLink.getFromField() != null) {
            return this._logLink.getFromField().getType().toLabel();
        }
        if (this._logLink.getToField() != null) {
            return this._logLink.getToField().getType().toLabel();
        }
        return this._logLink.getFromFlow().getType().toLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintLabel(Graphics2D g, AlgaContext context) {
        String label = this.getLabel();
        Font font = context.getFont(null, 0, -1);
        FontMetrics fmetrics = g.getFontMetrics(font);
        double w = fmetrics.getStringBounds(label, g).getWidth();
        Iterator<Pt> iterPt = this.iteratePoint();
        Pt pt = iterPt.next();
        int p0x = pt.getX();
        int p0y = pt.getY();
        pt = iterPt.next();
        int p1x = pt.getX();
        int p1y = pt.getY();
        int x = 0;
        int y = 0;
        int d = 5;
        double theta = Math.atan((double)Math.abs(p1y - p0y) / (double)Math.abs(p1x - p0x));
        double D = Math.sqrt(Math.pow(p0x - p1x, 2.0) + Math.pow(p0y - p1y, 2.0));
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double a = 1.0 - Math.sqrt(sin);
        if (p1x > p0x) {
            if (p1y > p0y) {
                x = (int)((double)((p0x + p1x) / 2) - w / 2.0 * a * cos * Math.min(1.0, D / w) + (double)d * sin);
                y = (int)((double)((p0y + p1y) / 2) - w / 2.0 * a * sin * Math.min(1.0, D / w) - (double)d * cos);
            } else {
                x = (int)((double)((p0x + p1x) / 2) + w / 2.0 * a * cos * Math.min(1.0, D / w) - (double)d * sin - w);
                y = (int)((double)((p0y + p1y) / 2) - w / 2.0 * a * sin * Math.min(1.0, D / w) - (double)d * cos);
            }
        } else if (p1y > p0y) {
            x = (int)((double)((p0x + p1x) / 2) + w / 2.0 * a * cos * Math.min(1.0, D / w) - (double)d * sin - w);
            y = (int)((double)((p0y + p1y) / 2) - w / 2.0 * a * sin * Math.min(1.0, D / w) - (double)d * cos);
        } else {
            x = (int)((double)((p0x + p1x) / 2) - w / 2.0 * a * cos * Math.min(1.0, D / w) + (double)d * sin);
            y = (int)((double)((p0y + p1y) / 2) - w / 2.0 * a * sin * Math.min(1.0, D / w) - (double)d * cos);
        }
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        try {
            g.setColor(this.getColor(context));
            g.setFont(font);
            g.drawString(label, x, y);
        }
        finally {
            g.setColor(oldColor);
            g.setFont(oldFont);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSelection(Graphics2D g, AlgaContext context) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setStroke(context.getStroke(1, -1, -1, false));
        Color currColor = context.getColorSelect(this.isLocked());
        g.setColor(currColor);
        if (this.isLocked()) {
            Iterator<Pt> iterPt = this.iteratePoint();
            iterPt.next();
            while (iterPt.hasNext()) {
                Pt next = iterPt.next();
                if (!iterPt.hasNext()) continue;
                switch (next.getStyle()) {
                    case CIRCLE: {
                        g.drawOval(next._x - 3, next._y - 3, 6, 6);
                        break;
                    }
                    case RECT: 
                    case NONE: {
                        g.drawRect(next._x - 3, next._y - 3, 6, 6);
                    }
                }
            }
        } else {
            Iterator<Pt> iterPt = this.iteratePoint();
            Pt prev = iterPt.next();
            while (iterPt.hasNext()) {
                Pt next = iterPt.next();
                if (iterPt.hasNext()) {
                    if (next.isSelected()) {
                        g.setColor(Color.cyan);
                    }
                    switch (next.getStyle()) {
                        case CIRCLE: {
                            g.fillOval(next._x - 3, next._y - 3, 6, 6);
                            break;
                        }
                        case RECT: 
                        case NONE: {
                            g.fillRect(next._x - 3, next._y - 3, 6, 6);
                        }
                    }
                    if (next.isSelected()) {
                        g.setColor(currColor);
                    }
                }
                AffineTransform oldTransf = g.getTransform();
                try {
                    g.translate((prev._x + next._x) / 2, (prev._y + next._y) / 2);
                    g.fill(MIDDLE_HIT_SHAPE);
                }
                finally {
                    g.setTransform(oldTransf);
                }
                prev = next;
            }
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintArrows(Graphics2D g, AlgaContext context) {
        Color oldColor = g.getColor();
        try {
            boolean pipe = false;
            boolean inverse = false;
            if (this._logLink.isRecord()) {
                pipe = this.isPipeStyle();
                DBRecord type = (DBRecord)this._logLink.getFromFlow().getType();
                if (type.hasInverseField()) {
                    inverse = true;
                }
            }
            g.setColor(this.getColor(context));
            Iterator<Pt> iterPt = this.iteratePoint();
            Pt current = iterPt.next();
            while (iterPt.hasNext()) {
                Pt next = iterPt.next();
                this.paintArrow(g, context, current, next, pipe);
                if (inverse) {
                    this.paintArrow(g, context, next, current, pipe);
                }
                current = next;
            }
        }
        finally {
            g.setColor(oldColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintArrow(Graphics2D g, AlgaContext context, Pt pt1, Pt pt2, boolean pipe) {
        double diffY;
        double diffX = pt2.getX() - pt1.getX();
        double dist = Math.sqrt(diffX * diffX + (diffY = (double)(pt2.getY() - pt1.getY())) * diffY);
        if (dist < 24.0) {
            return;
        }
        double angle = -1.0;
        angle = diffY == 0.0 ? (diffX > 0.0 ? 0.0 : Math.PI) : (diffX == 0.0 ? (diffY < 0.0 ? 4.71238898038469 : 1.5707963267948966) : (diffY > 0.0 ? (diffX > 0.0 ? Math.atan(diffY / diffX) : Math.PI - Math.atan(diffY / -diffX)) : (diffX > 0.0 ? -Math.atan(-diffY / diffX) : Math.PI + Math.atan(-diffY / -diffX))));
        AffineTransform oldTransf = g.getTransform();
        try {
            g.translate((pt1.getX() + pt2.getX()) / 2, (pt1.getY() + pt2.getY()) / 2);
            g.rotate(angle);
            if (!pipe) {
                g.fill(ARROW_SHAPE);
            }
            g.draw(ARROW_SHAPE);
        }
        finally {
            g.setTransform(oldTransf);
        }
    }

    @Override
    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        if (this._logLink.toBeDeleted()) {
            return false;
        }
        this.computeControlPoints();
        return true;
    }

    static {
        ARROW_SHAPE.moveTo(-4.0f, -4.0f);
        ARROW_SHAPE.lineTo(4.0f, 0.0f);
        ARROW_SHAPE.lineTo(-4.0f, 4.0f);
        ARROW_SHAPE.closePath();
        ARROW_SHAPE.append(new Line2D.Double(-8.0, 0.0, 8.0, 0.0), false);
    }

    private class LinkPointIterator
    implements Iterator<Pt> {
        boolean _bFirst;
        boolean _bLast;
        Iterator<Pt> _delegate;

        LinkPointIterator(Iterator<Pt> delegate) {
            this._delegate = delegate;
            this._bLast = false;
            this._bFirst = false;
        }

        @Override
        public boolean hasNext() {
            return !this._bLast;
        }

        @Override
        public Pt next() {
            if (!this._bFirst) {
                this._bFirst = true;
                return AlgaLink.this.getFirstPt();
            }
            if (this._delegate.hasNext()) {
                return this._delegate.next();
            }
            if (!this._bLast) {
                this._bLast = true;
                return AlgaLink.this.getLastPt();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

