/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse.DelegateMousePathMovePoint;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AlgaPoints
extends AlgaGraph {
    protected Rectangle _bound;
    private transient Rectangle _boundWithMarge;
    ArrayList<Pt> _points = new ArrayList();
    protected static GeneralPath MIDDLE_HIT_SHAPE = new GeneralPath();

    @Override
    public int getX() {
        return this._bound.x;
    }

    @Override
    public int getY() {
        return this._bound.y;
    }

    @Override
    public int getW() {
        return this._bound.width;
    }

    @Override
    public int getH() {
        return this._bound.height;
    }

    @Override
    public Rectangle getSelectBounds() {
        return this._bound;
    }

    public AlgaPoints() {
        this._bound = new Rectangle();
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaPoints) {
            AlgaPoints src = (AlgaPoints)grfsrc;
            if (withDepth) {
                this._points = new ArrayList(src._points.size());
                for (Pt srcPt : src._points) {
                    this._points.add(srcPt.getCopy());
                }
            } else {
                this._points = new ArrayList<Pt>(src._points);
            }
            this._bound = new Rectangle(src.getSelectBounds());
            this._boundWithMarge = new Rectangle(src._boundWithMarge);
        }
    }

    public ArrayList<Pt> getPoints() {
        return this._points;
    }

    public AlgaPoints setPoints(ArrayList<Pt> points) {
        this._points = points;
        return this;
    }

    public int getNbrPoints() {
        return this._points.size();
    }

    public Iterator<Pt> iteratePoint() {
        return this._points.iterator();
    }

    public void addPoint(Pt point) {
        this._points.add(point);
    }

    public void insertPoint(Pt point, int index) {
        this._points.add(index, point);
    }

    public Pt removePoint(int index) {
        return this._points.remove(index);
    }

    public boolean isClosePath() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this._points.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this._points.get(i).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void computeControlPoints() {
        int ymin = Integer.MAX_VALUE;
        int xmin = Integer.MAX_VALUE;
        int ymax = 0;
        int xmax = 0;
        Iterator<Pt> iterPt = this.iteratePoint();
        while (iterPt.hasNext()) {
            Pt graph = iterPt.next();
            int x = graph.getX();
            int y = graph.getY();
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y <= ymax) continue;
            ymax = y;
        }
        this._bound.x = xmin;
        this._bound.y = ymin;
        this._bound.width = xmax - xmin;
        if (this._bound.width == 0) {
            this._bound.width = 1;
        }
        this._bound.height = ymax - ymin;
        if (this._bound.height == 0) {
            this._bound.height = 1;
        }
        this._boundWithMarge = new Rectangle(this._bound);
        this._boundWithMarge.grow(4, 4);
    }

    @Override
    public void translate(int deltaX, int deltaY) {
        for (int i = this._points.size() - 1; i >= 0; --i) {
            this._points.get(i).translate(deltaX, deltaY);
        }
    }

    protected boolean pointContains(int x, int y) {
        Pt first;
        Iterator<Pt> iterPt = this.iteratePoint();
        Pt prev = first = iterPt.next();
        while (iterPt.hasNext()) {
            Pt next = iterPt.next();
            if (AlgaPoints.pointIsInside(x, y, prev._x, prev._y, next._x, next._y, 4)) {
                return true;
            }
            prev = next;
        }
        return this.isClosePath() && AlgaPoints.pointIsInside(x, y, prev._x, prev._y, first._x, first._y, 4);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this._boundWithMarge.contains(x, y)) {
            return this.pointContains(x, y);
        }
        return false;
    }

    @Override
    public Shape getSelectShape() {
        GeneralPath path = new GeneralPath();
        Iterator<Pt> iterPt = this.iteratePoint();
        Pt pt = iterPt.next();
        path.moveTo(pt.getX(), pt.getY());
        while (iterPt.hasNext()) {
            pt = iterPt.next();
            path.lineTo(pt.getX(), pt.getY());
        }
        if (this.isClosePath()) {
            path.closePath();
        }
        return path;
    }

    protected int getHitPoint(int x, int y, boolean close) {
        int idx = 0;
        Iterator<Pt> iterPt = this.iteratePoint();
        Pt first = iterPt.next();
        if (this.isAround(first._x, first._y, x, y)) {
            return idx * 2;
        }
        Pt prev = first;
        while (iterPt.hasNext()) {
            Pt next = iterPt.next();
            ++idx;
            if (this.isAround(next._x, next._y, x, y)) {
                return idx * 2;
            }
            if (this.isAround((prev._x + next._x) / 2, (prev._y + next._y) / 2, x, y)) {
                return idx * 2 - 1;
            }
            prev = next;
        }
        if (close && this.isAround((prev._x + first._x) / 2, (prev._y + first._y) / 2, x, y)) {
            return idx * 2 + 1;
        }
        return -10;
    }

    @Override
    public AltaContentView.DelegateMouse getCtrlMouse(int x, int y, AltaContentView view) {
        int result;
        if (!this.isLocked() && this.isSelected() && view instanceof AltaContentEditView && (result = this.getHitPoint(x, y, this.isClosePath())) != -10) {
            return new DelegateMousePathMovePoint(this, result);
        }
        return super.getCtrlMouse(x, y, view);
    }

    public static boolean pointIsInside(int Cx, int Cy, double Ax, double Ay, int Bx, int By, int marge) {
        double L2 = ((double)Bx - Ax) * ((double)Bx - Ax) + ((double)By - Ay) * ((double)By - Ay);
        double r = (((double)Cx - Ax) * ((double)Bx - Ax) + ((double)Cy - Ay) * ((double)By - Ay)) / L2;
        if (r < 0.0 || r > 1.0) {
            return false;
        }
        double s = ((Ay - (double)Cy) * ((double)Bx - Ax) - (Ax - (double)Cx) * ((double)By - Ay)) / L2;
        double d = Math.abs(s) * Math.sqrt(L2);
        return d <= (double)marge;
    }

    static {
        MIDDLE_HIT_SHAPE.moveTo(0.0f, -3.0f);
        MIDDLE_HIT_SHAPE.lineTo(3.0f, 0.0f);
        MIDDLE_HIT_SHAPE.lineTo(0.0f, 3.0f);
        MIDDLE_HIT_SHAPE.lineTo(-3.0f, 0.0f);
        MIDDLE_HIT_SHAPE.closePath();
    }
}

