/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class AlgaTransform {
    boolean _bMirrorH = false;
    boolean _bMirrorV = false;
    boolean _bRotate = false;

    public boolean withTransform() {
        if (this._bMirrorH) {
            return true;
        }
        if (this._bMirrorV) {
            return true;
        }
        return this._bRotate;
    }

    public boolean isRotate() {
        return this._bRotate;
    }

    public boolean isMirrorH() {
        return this._bMirrorH;
    }

    public boolean isMirrorV() {
        return this._bMirrorV;
    }

    public void add(Type typeTransform) {
        switch (typeTransform) {
            case MIRRORH: {
                this._bMirrorH = !this._bMirrorH;
                break;
            }
            case MIRRORV: {
                this._bMirrorV = !this._bMirrorV;
                break;
            }
            case ROTATE: {
                if (this._bMirrorH ^ this._bMirrorV) {
                    if (!this._bRotate) {
                        this._bMirrorH = !this._bMirrorH;
                        this._bMirrorV = !this._bMirrorV;
                    }
                } else if (this._bRotate) {
                    this._bMirrorH = !this._bMirrorH;
                    this._bMirrorV = !this._bMirrorV;
                }
                this._bRotate = !this._bRotate;
                break;
            }
            case ROTATE_INV: {
                if (this._bMirrorH ^ this._bMirrorV) {
                    if (this._bRotate) {
                        this._bMirrorH = !this._bMirrorH;
                        this._bMirrorV = !this._bMirrorV;
                    }
                } else if (!this._bRotate) {
                    this._bMirrorH = !this._bMirrorH;
                    this._bMirrorV = !this._bMirrorV;
                }
                this._bRotate = !this._bRotate;
            }
        }
    }

    public void prepareGraphics(Graphics2D g, double cx, double cy) {
        if (this._bMirrorH ^ this._bMirrorV) {
            AffineTransform tx = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 2.0 * cy);
            int nbrR = 0;
            if (this._bMirrorH) {
                nbrR = this._bRotate ? 3 : 0;
            } else {
                int n = nbrR = this._bRotate ? 1 : 2;
            }
            if (nbrR != 0) {
                tx.quadrantRotate(nbrR, cx, cy);
            }
            g.transform(tx);
        } else {
            int nbrR = 0;
            if (this._bMirrorH) {
                nbrR = this._bRotate ? 1 : 2;
            } else {
                int n = nbrR = this._bRotate ? 3 : 0;
            }
            if (nbrR != 0) {
                AffineTransform tx = AffineTransform.getQuadrantRotateInstance(nbrR, cx, cy);
                g.transform(tx);
            }
        }
    }

    public Pt convertPoint(int x, int y, int w, int h) {
        if (this._bRotate) {
            int t = y;
            y = w - x;
            x = t;
            if (this._bMirrorV) {
                x = h - x;
            }
            if (this._bMirrorH) {
                y = w - y;
            }
        } else {
            if (this._bMirrorV) {
                x = w - x;
            }
            if (this._bMirrorH) {
                y = h - y;
            }
        }
        return new Pt(x, y);
    }

    public Pt convertPointInverse(int x, int y, int w, int h) {
        if (this._bRotate) {
            if (this._bMirrorH) {
                y = w - y;
            }
            if (this._bMirrorV) {
                x = h - x;
            }
            int t = x;
            x = w - y;
            y = t;
        } else {
            if (this._bMirrorV) {
                x = w - x;
            }
            if (this._bMirrorH) {
                y = h - y;
            }
        }
        return new Pt(x, y);
    }

    public AlgaTransform getCopy() {
        AlgaTransform cpy = new AlgaTransform();
        cpy._bMirrorH = this._bMirrorH;
        cpy._bMirrorV = this._bMirrorV;
        cpy._bRotate = this._bRotate;
        return cpy;
    }

    public static enum Type {
        MIRRORH,
        MIRRORV,
        ROTATE,
        ROTATE_INV;

    }
}

