/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AlgaSheetTableModel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AlgaSheetTablePanel;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;

public class AlgaSheetsDlg
extends JDialogCecilia {
    AlgaSheetTableModel _ctrlModel;
    AlgaSheetTablePanel _ctrlPanel;
    JButton _allVisibleButton;
    JButton _allInvisibleButton;

    public AlgaSheetsDlg(Window win) {
        super(win, true);
        this.setTitle(ResMsgOcas.getString("TITLE_ALTA_SHEETS"));
        this.make();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    public JTable getTable() {
        return this._ctrlPanel.getTable();
    }

    private void make() {
        this._ctrlModel = new AlgaSheetTableModel(new ArrayList<AlgaSheet>());
        this._ctrlPanel = new AlgaSheetTablePanel(this, this._ctrlModel);
        this._ctrlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._ctrlPanel, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        JPanel selectAllButtonPanel = new JPanel(new FlowLayout());
        AbstractAction actAllVisible = new AbstractAction(ResMsgVoc.getString("LAYERS_ALL_VISIBLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgaSheetsDlg.this.getSheets().forEach(o -> o.setVisible(true));
                AlgaSheetsDlg.this._ctrlModel.fireTableDataChanged();
                AlgaSheetsDlg.this._allVisibleButton.setEnabled(false);
                AlgaSheetsDlg.this._allInvisibleButton.setEnabled(true);
            }
        };
        AbstractAction actAllInvisible = new AbstractAction(ResMsgVoc.getString("LAYERS_ALL_INVISIBLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgaSheetsDlg.this.getSheets().stream().filter(o -> !o.isSelected()).forEach(o -> o.setVisible(false));
                AlgaSheetsDlg.this._ctrlModel.fireTableDataChanged();
                AlgaSheetsDlg.this._allInvisibleButton.setEnabled(false);
                AlgaSheetsDlg.this._allVisibleButton.setEnabled(true);
            }
        };
        this._allVisibleButton = new JButton(actAllVisible);
        this._allVisibleButton.setEnabled(false);
        this._allInvisibleButton = new JButton(actAllInvisible);
        this._allInvisibleButton.setEnabled(true);
        this._ctrlPanel.setVisibleButtons(this._allVisibleButton, this._allInvisibleButton);
        selectAllButtonPanel.add(this._allVisibleButton);
        selectAllButtonPanel.add(this._allInvisibleButton);
        panel.add((Component)selectAllButtonPanel, "North");
        panel.add((Component)this.createButPanel(), "South");
        this.getContentPane().add((Component)panel, "South");
        this.pack();
    }

    public void setSheets(List<AlgaSheet> sheets, boolean bReadOnly) {
        CopyUtility.ByPass bypass = new CopyUtility.ByPass();
        ArrayList<AlgaSheet> copySheets = new ArrayList<AlgaSheet>(sheets.size());
        for (AlgaSheet srcSheet : sheets) {
            AlgaSheet cpySheet = srcSheet.getCopy(false, (CopyUtility)bypass);
            copySheets.add(cpySheet);
        }
        this._ctrlModel.setData(copySheets);
        this._ctrlModel.setReadOnly(bReadOnly);
    }

    public List<AlgaSheet> getSheets() {
        return this._ctrlModel.getData();
    }

    @Override
    protected boolean verifyParameters() {
        return true;
    }
}

