/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.action.UndoItem;
import com.dassault.cecilia.core.cecilia.action.UndoManager;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.dbobj.mbsa.ResIcoOcas;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaClipboard;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaClipboardTransferable;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdCreateEqpFromSelec;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdDelete;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdEditVisio;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdFormCreate;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdGraphAlign;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdGraphDistribute;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdGraphMove;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdGroupAssociate;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdGroupDissociate;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdLinkArrow;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdLinkBody;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdLinkConvert;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdLinkStyle;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdLock;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdMoveIntoSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdNodeText;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdOrder;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdPaste;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdPathBreakStyle;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdRename;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdReplace;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdTransform;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AltaContentEditPanel
extends AltaContentPanel {
    int _popupX;
    int _popupY;
    JPopupMenu _popupMenu;
    AbstractAction _actionUndo;
    AbstractAction _actionRedo;
    AbstractAction _actionDelete;
    AbstractAction _actionPaste;
    CeciliaAction _actionRename;
    CeciliaAction _actionReplace;
    JMenu _subMenuGraphic;
    CeciliaAction _actionGraphicAddLine;
    CeciliaAction _actionGraphicAddText;
    CeciliaAction _actionGraphicAddImage;
    CeciliaAction _actionGraphicAddCircle;
    CeciliaAction _actionGraphicAddRect;
    CeciliaAction _actionGraphicAddRoundRect;
    CeciliaAction _actionGraphicAddPolygone;
    CeciliaAction _actionGraphicAddArrowI1;
    CeciliaAction _actionGraphicAddArrowI2;
    CeciliaAction _actionGraphicAddArrowL1;
    CeciliaAction _actionGraphicAddArrowL2;
    CeciliaAction _actionGraphicAddArrowT3;
    CeciliaAction _actionGroupAssociate;
    CeciliaAction _actionGroupDissociate;
    JMenu _subMenuLink;
    JMenu _subMenuLinkStyle;
    JMenu _subMenuLinkBody;
    JMenu _subMenuLinkArrow;
    JMenu _subMenuLinkBreak;
    AbstractAction _actionLinkStyleD;
    AbstractAction _actionLinkStyleV;
    AbstractAction _actionLinkStyleH;
    AbstractAction _actionLinkStyleBL;
    AbstractAction _actionLinkStyleTR;
    AbstractAction _actionLinkStyleTL;
    AbstractAction _actionLinkStyleBR;
    AbstractAction _actionLinkBodyFill;
    AbstractAction _actionLinkBodyPipe;
    AbstractAction _actionLinkArrowWith;
    AbstractAction _actionLinkArrowNone;
    CeciliaAction _actionLinkBreakNone;
    CeciliaAction _actionLinkBreakCircle;
    CeciliaAction _actionLinkBreakRect;
    CeciliaAction _actionLinkConvertCode;
    JMenu _subMenuText;
    CeciliaAction _actionPositionLeft;
    CeciliaAction _actionPositionRight;
    CeciliaAction _actionPositionTop;
    CeciliaAction _actionPositionBottom;
    CeciliaAction _actionPositionCenter;
    CeciliaAction _actionPositionNone;
    JMenu _subMenuAlign;
    AbstractAction _actionAlignLeft;
    AbstractAction _actionAlignRight;
    AbstractAction _actionAlignHorizontal;
    AbstractAction _actionAlignTop;
    AbstractAction _actionAlignBottom;
    AbstractAction _actionAlignVertical;
    AbstractAction _actionAlignCenter;
    JMenu _subMenuDistrib;
    AbstractAction _actionDistribVerti;
    AbstractAction _actionDistribHoriz;
    JMenu _subMenuOrder;
    AbstractAction _actionOrderFirst;
    AbstractAction _actionOrderLast;
    AbstractAction _actionMirrorHorizontal;
    AbstractAction _actionMirrorVertical;
    AbstractAction _actionMirrorRotate;
    AbstractAction _actionLockLock;
    AbstractAction _actionLockUnlock;
    AbstractAction _actionCreateEqpFromSelection;
    JMenu _subMenuSheet;
    ArrayList<JMenuItem> _menuItemsMoveInSheet = new ArrayList();
    int _nbrUnlocked = 0;
    int _nbrNodeUnlocked = 0;

    public AltaContentEditPanel(CeciliaAppl appl) {
        super(appl);
    }

    @Override
    public void setModified(boolean value) {
        this.getAltaComponent().setModified(value);
    }

    @Override
    protected boolean isReadOnly() {
        return this.getAppl().isReader();
    }

    @Override
    public void make() {
        super.make();
        this._contentView.addAltaChangeSelectListener(new AltaContentView.AltaChangeSelectListener(){

            @Override
            public void changeSelect() {
                AltaContentEditPanel.this.refreshActions();
            }
        });
        this.createActions();
        this.createPopupMenu();
        this._scrollView.setComponentPopupMenu(this._popupMenu);
        this._contentView.setComponentPopupMenu(this._popupMenu);
    }

    private void createActions() {
        class AddGraphicAction
        extends CeciliaAction {
            AlgaForm.Type _param;

            AddGraphicAction(ImageIcon icon, String label, AlgaForm.Type param) {
                super(icon, label);
                this._param = param;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdFormCreate cmd = new OCmdFormCreate(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, this._param, AltaContentEditPanel.this._popupX, AltaContentEditPanel.this._popupY);
                cmd.realiseDo();
            }
        }
        this._actionGraphicAddLine = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_LINE"), ResMsgOcas.getString("DRAW_LINE"), AlgaForm.Type.LINE);
        this._actionGraphicAddText = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_TEXT"), ResMsgOcas.getString("KEY_0822"), AlgaForm.Type.TEXT);
        this._actionGraphicAddImage = new AddGraphicAction(ResIcoOcas.getImageIcon("ICONE_PI"), ResMsgOcas.getString("KEY_0575"), AlgaForm.Type.IMAGE);
        this._actionGraphicAddCircle = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_CERCLE"), ResMsgOcas.getString("DRAW_CIRCLE"), AlgaForm.Type.OVALE);
        this._actionGraphicAddRect = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_RECTANGLE"), ResMsgOcas.getString("DRAW_RECT"), AlgaForm.Type.RECTANGLE);
        this._actionGraphicAddRoundRect = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_RECTANGLE_ROUND"), ResMsgOcas.getString("DRAW_RECTROUND"), AlgaForm.Type.ROUND_RECTANGLE);
        this._actionGraphicAddPolygone = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_POLYGONE"), ResMsgOcas.getString("DRAW_POLYGON"), AlgaForm.Type.POLYGONE);
        this._actionGraphicAddArrowI1 = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_ARROW_1H"), ResMsgOcas.getString("DRAW_ARROW_RIGHT"), AlgaForm.Type.ARROW_SIMPLE);
        this._actionGraphicAddArrowI2 = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_ARROW_2H"), ResMsgOcas.getString("DRAW_ARROW_DOUBLE_H"), AlgaForm.Type.ARROW_DOUBLE);
        this._actionGraphicAddArrowL1 = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_ARROW_1L"), ResMsgOcas.getString("DRAW_ARROW_RIGHT_ANGLE"), AlgaForm.Type.ARROW_R_SIMPLE);
        this._actionGraphicAddArrowL2 = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_ARROW_2L"), ResMsgOcas.getString("DRAW_ARROW_DOUBLE_RIGHT_ANGLE"), AlgaForm.Type.ARROW_R_DOUBLE);
        this._actionGraphicAddArrowT3 = new AddGraphicAction(ResIcoOcas.getImageIcon("CMD_DRAW_ARROW_3"), ResMsgOcas.getString("DRAW_ARROW_TRIPLE"), AlgaForm.Type.ARROW_TRIPLE);
        this._actionGroupAssociate = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_GRF_GROUP"), ResMsgVoc.getString("VOC_ASSOCIATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdGroupAssociate cmd = new OCmdGroupAssociate(AltaContentEditPanel.this);
                cmd.realiseDo();
            }
        };
        this._actionGroupDissociate = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_GRF_UNGROUP"), ResMsgVoc.getString("VOC_DISSOCIATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdGroupDissociate cmd = new OCmdGroupDissociate(AltaContentEditPanel.this);
                cmd.realiseDo();
            }
        };
        class LinkStyleAction
        extends AContentEditAction {
            OCmdLinkStyle.Style _style;

            LinkStyleAction(OCmdLinkStyle.Style style) {
                super(style.toString());
                this._style = style;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdLinkStyle cmd = new OCmdLinkStyle(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, this._style);
                cmd.realiseDo();
            }
        }
        this._actionLinkStyleD = new LinkStyleAction(OCmdLinkStyle.Style.D);
        this._actionLinkStyleBL = new LinkStyleAction(OCmdLinkStyle.Style.BL);
        this._actionLinkStyleTR = new LinkStyleAction(OCmdLinkStyle.Style.TR);
        this._actionLinkStyleTL = new LinkStyleAction(OCmdLinkStyle.Style.TL);
        this._actionLinkStyleBR = new LinkStyleAction(OCmdLinkStyle.Style.BR);
        this._actionLinkStyleV = new LinkStyleAction(OCmdLinkStyle.Style.V);
        this._actionLinkStyleH = new LinkStyleAction(OCmdLinkStyle.Style.H);
        this._actionLinkBodyFill = new AContentEditAction("LinkBodyFill"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdLinkBody cmd = new OCmdLinkBody(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, false);
                cmd.realiseDo();
            }
        };
        this._actionLinkBodyPipe = new AContentEditAction("LinkBodyPipe"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdLinkBody cmd = new OCmdLinkBody(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, true);
                cmd.realiseDo();
            }
        };
        this._actionLinkArrowNone = new AContentEditAction("LinkArrowNone"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdLinkArrow cmd = new OCmdLinkArrow(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, false);
                cmd.realiseDo();
            }
        };
        this._actionLinkArrowWith = new AContentEditAction("LinkArrowWith"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdLinkArrow cmd = new OCmdLinkArrow(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, true);
                cmd.realiseDo();
            }
        };
        this._actionLinkBreakNone = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_LINK_BREAK_NONE"), ResMsgVoc.getString("VOC_AUCUN")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdPathBreakStyle cmd = new OCmdPathBreakStyle(AltaContentEditPanel.this, Pt.Style.NONE);
                cmd.realiseDo();
            }
        };
        this._actionLinkBreakCircle = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_LINK_BREAK_POINT"), ResMsgOcas.getString("DRAW_CIRCLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdPathBreakStyle cmd = new OCmdPathBreakStyle(AltaContentEditPanel.this, Pt.Style.CIRCLE);
                cmd.realiseDo();
            }
        };
        this._actionLinkBreakRect = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_LINK_BREAK_RECT"), ResMsgOcas.getString("DRAW_RECT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdPathBreakStyle cmd = new OCmdPathBreakStyle(AltaContentEditPanel.this, Pt.Style.RECT);
                cmd.realiseDo();
            }
        };
        this._actionLinkConvertCode = new CeciliaAction(ResIcoOcas.getImageIcon("LIENS_PI"), ResMsgOcas.getString("MENU_TRANSFORM_LINK_TO_ASSERT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdLinkConvert cmd = new OCmdLinkConvert(AltaContentEditPanel.this);
                cmd.realiseDo();
            }
        };
        class AlignAction
        extends AContentEditAction {
            OCmdGraphMove.Move _param;

            AlignAction(OCmdGraphMove.Move param) {
                super("Align" + param);
                this._param = param;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdGraphAlign cmd = new OCmdGraphAlign(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, this._param);
                cmd.realiseDo();
            }
        }
        this._actionAlignLeft = new AlignAction(OCmdGraphMove.Move.LEFT);
        this._actionAlignRight = new AlignAction(OCmdGraphMove.Move.RIGHT);
        this._actionAlignHorizontal = new AlignAction(OCmdGraphMove.Move.HORIZONTAL);
        this._actionAlignTop = new AlignAction(OCmdGraphMove.Move.TOP);
        this._actionAlignBottom = new AlignAction(OCmdGraphMove.Move.BOTTOM);
        this._actionAlignVertical = new AlignAction(OCmdGraphMove.Move.VERTICAL);
        this._actionAlignCenter = new AlignAction(OCmdGraphMove.Move.CENTER);
        class DistribAction
        extends AContentEditAction {
            OCmdGraphMove.Move _param;

            public DistribAction(OCmdGraphMove.Move param) {
                super("Distribute" + param);
                this._param = param;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdGraphDistribute cmd = new OCmdGraphDistribute(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, this._param);
                cmd.realiseDo();
            }
        }
        this._actionDistribVerti = new DistribAction(OCmdGraphMove.Move.VERTICAL);
        this._actionDistribHoriz = new DistribAction(OCmdGraphMove.Move.HORIZONTAL);
        class TransformAction
        extends AContentEditAction {
            AlgaTransform.Type _param;

            TransformAction(AlgaTransform.Type param) {
                super("Transform" + param);
                this._param = param;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdTransform cmd = new OCmdTransform(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, this._param);
                cmd.realiseDo();
            }
        }
        this._actionMirrorHorizontal = new TransformAction(AlgaTransform.Type.MIRRORH);
        this._actionMirrorVertical = new TransformAction(AlgaTransform.Type.MIRRORV);
        this._actionMirrorRotate = new TransformAction(AlgaTransform.Type.ROTATE);
        this._actionOrderFirst = new AContentEditAction(OCmdOrder.Type.FIRST.toString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdOrder cmd = new OCmdOrder(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, OCmdOrder.Type.FIRST);
                cmd.realiseDo();
            }
        };
        this._actionOrderLast = new AContentEditAction(OCmdOrder.Type.LAST.toString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdOrder cmd = new OCmdOrder(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, OCmdOrder.Type.LAST);
                cmd.realiseDo();
            }
        };
        this._actionLockLock = new AContentEditAction("Lock"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdLock cmd = new OCmdLock(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, true);
                cmd.realiseDo();
            }
        };
        this._actionLockUnlock = new AContentEditAction("Unlock"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdLock cmd = new OCmdLock(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, false);
                cmd.realiseDo();
            }
        };
        this._actionCreateEqpFromSelection = new AContentEditAction("CreateEqp"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdCreateEqpFromSelec cmd = new OCmdCreateEqpFromSelec(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this);
                cmd.realiseDo();
            }
        };
        class PositionTextAction
        extends CeciliaAction {
            NamePosition _param;

            PositionTextAction(ImageIcon icon, String label, NamePosition param) {
                super(icon, label);
                this._param = param;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdNodeText cmd = new OCmdNodeText(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, this._param);
                cmd.realiseDo();
            }
        }
        this._actionPositionLeft = new PositionTextAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_L"), ResMsgVoc.getString("VOC_LEFT"), NamePosition.LEFT);
        this._actionPositionRight = new PositionTextAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_R"), ResMsgVoc.getString("VOC_RIGHT"), NamePosition.RIGHT);
        this._actionPositionTop = new PositionTextAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_T"), ResMsgOcas.getString("MENU_BRING_FOREWARD"), NamePosition.TOP);
        this._actionPositionBottom = new PositionTextAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_B"), ResMsgOcas.getString("MENU_SEND_BACKWARD"), NamePosition.BOTTOM);
        this._actionPositionCenter = new PositionTextAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_C"), ResMsgVoc.getString("VOC_CENTER"), NamePosition.CENTER);
        this._actionPositionNone = new PositionTextAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_N"), ResMsgOcas.getString("TEXT_POSITION_NONE"), NamePosition.NONE);
        this._actionRename = new CeciliaAction(ResIcoCore.getImageIcon("RENOMER_PI"), ResMsgVoc.getString("VOC_RENAME")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgaGraph grf = AltaContentEditPanel.this.getContent().getSelectedGraph();
                if (grf == null || grf.isLocked() || !(grf instanceof AlgaNode)) {
                    return;
                }
                AlgaNode node = (AlgaNode)grf;
                OCmdRename cmd = new OCmdRename(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this, node);
                cmd.realiseDo();
            }
        }.setKey(KeyStroke.getKeyStroke("F2"));
        this._actionReplace = new CeciliaAction(ResIcoOcas.getImageIcon("REMPLACER_PI"), ResMsgOcas.getString("MENU_REPLACE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdReplace cmd = new OCmdReplace(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this);
                cmd.realiseDo();
            }
        };
        this._actionDelete = new AContentEditAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdDelete cmd = new OCmdDelete(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this);
                cmd.realiseDo();
            }
        };
        this._actionPaste = new AContentEditAction("Paste"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCmdPaste cmd = new OCmdPaste(AltaContentEditPanel.this.getAppl(), AltaContentEditPanel.this);
                cmd.realiseDo();
            }
        };
        this._actionUndo = new AContentEditAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                class UndoThread
                extends CThread {
                    public UndoThread(Component c) {
                        super(c);
                    }

                    @Override
                    protected void firstDo() {
                        UndoManager undoMng = AltaContentEditPanel.this.getAltaComponent().getUndoManager();
                        if (undoMng.undoable()) {
                            undoMng.undo();
                            AltaContentEditPanel.this._gui.getDelegateAction("UNDO").setEnabled(undoMng.undoable());
                            AltaContentEditPanel.this._gui.getDelegateAction("REDO").setEnabled(undoMng.redoable());
                        }
                    }
                }
                UndoThread thread = new UndoThread(AltaContentEditPanel.this);
                thread.realiseDo();
            }
        };
        this._actionRedo = new AContentEditAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                class RedoThread
                extends CThread {
                    public RedoThread(Component c) {
                        super(c);
                    }

                    @Override
                    protected void firstDo() {
                        UndoManager undoMng = AltaContentEditPanel.this.getAltaComponent().getUndoManager();
                        if (undoMng.redoable()) {
                            undoMng.redo();
                            AltaContentEditPanel.this._gui.getDelegateAction("UNDO").setEnabled(undoMng.undoable());
                            AltaContentEditPanel.this._gui.getDelegateAction("REDO").setEnabled(undoMng.redoable());
                        }
                    }
                }
                RedoThread thread = new RedoThread(AltaContentEditPanel.this);
                thread.realiseDo();
            }
        };
    }

    private void createPopupMenu() {
        this._popupMenu = new JPopupMenu();
        this._subMenuGraphic = new JMenu(ResMsgVoc.getString("VOC_GRAPHICS"));
        this._subMenuLink = new JMenu(ResMsgVoc.getString("VOC_LINK"));
        this._subMenuLinkStyle = new JMenu(ResMsgVoc.getString("VOC_STYLE"));
        this._subMenuLinkBody = new JMenu(ResMsgVoc.getString("VOC_BODY"));
        this._subMenuLinkArrow = new JMenu(ResMsgVoc.getString("VOC_ARROWS"));
        this._subMenuLinkBreak = new JMenu(ResMsgVoc.getString("VOC_BREAK"));
        this._subMenuText = new JMenu(ResMsgOcas.getString("MENU_TEXT"));
        this._subMenuAlign = new JMenu(ResMsgOcas.getString("MENU_ALIGN"));
        this._subMenuDistrib = new JMenu(ResMsgOcas.getString("MENU_DISTR"));
        this._subMenuOrder = new JMenu(ResMsgVoc.getString("VOC_ORDER"));
        this._subMenuSheet = new JMenu(ResMsgVoc.getString("VOC_LAYER"));
        if (this.isReadOnly()) {
            this._popupMenu.add(this._actionEdit.createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("COPY").createMenuItem());
        } else {
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("UNDO").createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("REDO").createMenuItem());
            this._popupMenu.addSeparator();
            this._popupMenu.add(this._actionEdit.createMenuItem());
            this._popupMenu.add(this._actionRename.createMenuItem());
            this._popupMenu.add(this._actionReplace.createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("DELETE").createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("COPY").createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("PASTE").createMenuItem());
            this._popupMenu.addSeparator();
            this._popupMenu.add(this._subMenuGraphic);
            this._subMenuGraphic.add(this._actionGraphicAddLine.createMenuItem());
            this._subMenuGraphic.add(this._actionGraphicAddText.createMenuItem());
            this._subMenuGraphic.add(this._actionGraphicAddImage.createMenuItem());
            this._subMenuGraphic.addSeparator();
            this._subMenuGraphic.add(this._actionGraphicAddCircle.createMenuItem());
            this._subMenuGraphic.add(this._actionGraphicAddRect.createMenuItem());
            this._subMenuGraphic.add(this._actionGraphicAddRoundRect.createMenuItem());
            this._subMenuGraphic.add(this._actionGraphicAddPolygone.createMenuItem());
            this._subMenuGraphic.addSeparator();
            this._subMenuGraphic.add(this._actionGraphicAddArrowI1.createMenuItem());
            this._subMenuGraphic.add(this._actionGraphicAddArrowI2.createMenuItem());
            this._subMenuGraphic.add(this._actionGraphicAddArrowL1.createMenuItem());
            this._subMenuGraphic.add(this._actionGraphicAddArrowL2.createMenuItem());
            this._subMenuGraphic.add(this._actionGraphicAddArrowT3.createMenuItem());
            this._subMenuGraphic.addSeparator();
            this._subMenuGraphic.add(this._actionGroupAssociate.createMenuItem());
            this._subMenuGraphic.add(this._actionGroupDissociate.createMenuItem());
            this._popupMenu.add(this._subMenuLink);
            this._subMenuLink.add(this._subMenuLinkStyle);
            this._subMenuLinkStyle.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_DIRECT").createMenuItem());
            this._subMenuLinkStyle.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_TOP_LEFT").createMenuItem());
            this._subMenuLinkStyle.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_TOP_RIGHT").createMenuItem());
            this._subMenuLinkStyle.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_BOTTOM_LEFT").createMenuItem());
            this._subMenuLinkStyle.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_BOTTOM_RIGHT").createMenuItem());
            this._subMenuLinkStyle.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_VERTICAL").createMenuItem());
            this._subMenuLinkStyle.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_HORIZONTAL").createMenuItem());
            this._subMenuLink.add(this._subMenuLinkBody);
            this._subMenuLinkBody.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_BODY_FILL").createMenuItem());
            this._subMenuLinkBody.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_BODY_PIPE").createMenuItem());
            this._subMenuLink.add(this._subMenuLinkArrow);
            this._subMenuLinkArrow.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_ARROW_DEL").createMenuItem());
            this._subMenuLinkArrow.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LINK_ARROW_ADD").createMenuItem());
            this._subMenuLink.add(this._subMenuLinkBreak);
            this._subMenuLinkBreak.add(this._actionLinkBreakNone.createMenuItem());
            this._subMenuLinkBreak.add(this._actionLinkBreakCircle.createMenuItem());
            this._subMenuLinkBreak.add(this._actionLinkBreakRect.createMenuItem());
            this._subMenuLink.add(this._actionLinkConvertCode.createMenuItem());
            this._popupMenu.add(this._subMenuText);
            this._subMenuText.add(this._actionPositionTop.createMenuItem());
            this._subMenuText.add(this._actionPositionBottom.createMenuItem());
            this._subMenuText.add(this._actionPositionLeft.createMenuItem());
            this._subMenuText.add(this._actionPositionRight.createMenuItem());
            this._subMenuText.add(this._actionPositionCenter.createMenuItem());
            if (!Boolean.getBoolean("cecilia.BackwardCompatibility.62x")) {
                this._subMenuText.add(this._actionPositionNone.createMenuItem());
            }
            this._popupMenu.add(this._subMenuAlign);
            this._subMenuAlign.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_ALIGN_LEFT").createMenuItem());
            this._subMenuAlign.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_ALIGN_VERTICAL").createMenuItem());
            this._subMenuAlign.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_ALIGN_RIGHT").createMenuItem());
            this._subMenuAlign.addSeparator();
            this._subMenuAlign.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_ALIGN_CENTER").createMenuItem());
            this._subMenuAlign.addSeparator();
            this._subMenuAlign.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_ALIGN_TOP").createMenuItem());
            this._subMenuAlign.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_ALIGN_HORIZONTAL").createMenuItem());
            this._subMenuAlign.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_ALIGN_BOTTOM").createMenuItem());
            this._popupMenu.add(this._subMenuDistrib);
            this._subMenuDistrib.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_DISTRIB_HORIZONTALLY").createMenuItem());
            this._subMenuDistrib.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_DISTRIB_VERTICALLY").createMenuItem());
            this._popupMenu.add(this._subMenuOrder);
            this._subMenuOrder.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_ORDER_FIRST").createMenuItem());
            this._subMenuOrder.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_ORDER_LAST").createMenuItem());
            this._subMenuSheet.setIcon(ResIcoOcas.getImageIcon("SHEET_IMG"));
            this._popupMenu.add(this._subMenuSheet);
            this._popupMenu.addSeparator();
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_MIRROR_HORIZONTAL").createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_MIRROR_VERTICAL").createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_MIRROR_ROTATE").createMenuItem());
            this._popupMenu.addSeparator();
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_CREATE_EQUIP_FROM_SELECTION").createMenuItem());
            this._popupMenu.addSeparator();
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LOCK_LOCK").createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_VIEW_LOCK_UNLOCK").createMenuItem());
        }
        this._popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AltaContentEditPanel.this.updateSheetsMenu();
                Point pt = AltaContentEditPanel.this._contentView.getMousePosition();
                if (pt != null) {
                    AltaContentEditPanel.this._popupX = pt.x;
                    AltaContentEditPanel.this._popupY = pt.y;
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void updateSheetsMenu() {
        int i;
        if (this.isReadOnly()) {
            return;
        }
        boolean change = false;
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (i = 0; i < sheets.size(); ++i) {
            JMenuItem item;
            AlgaSheet sheet = sheets.get(i);
            if (this._menuItemsMoveInSheet.size() < i + 1) {
                item = new MoveIntoSheetAction(sheet.getName(), i).createMenuItem();
                this._menuItemsMoveInSheet.add(item);
                change = true;
                continue;
            }
            item = this._menuItemsMoveInSheet.get(i);
            if (item.getText().equals(sheet.getName())) continue;
            item.setText(sheet.getName());
            change = true;
        }
        if (!change) {
            boolean bl = change = sheets.size() != this._subMenuSheet.getMenuComponentCount();
        }
        if (change) {
            this._subMenuSheet.removeAll();
            for (i = 0; i < sheets.size(); ++i) {
                this._subMenuSheet.add(this._menuItemsMoveInSheet.get(i));
            }
        }
    }

    public int getNbrUnlocked() {
        return this._nbrUnlocked;
    }

    public int getNbrNodeUnlocked() {
        return this._nbrNodeUnlocked;
    }

    @Override
    protected void refreshActions() {
        super.refreshActions();
        int nbrDrawUnlocked = 0;
        int nbrTextUnlocked = 0;
        int nbrAlignUnlocked = 0;
        int nbrAlignLocked = 0;
        int nbrDeleteUnlocked = 0;
        int nbrLocked = 0;
        this._nbrUnlocked = 0;
        this._nbrNodeUnlocked = 0;
        int nbrLinkUnlocked = 0;
        int nbrLinkDirect = 0;
        int nbrLinkRight = 0;
        int nbrLinkAntiSlash = 0;
        int nbrLinkSlash = 0;
        int nbrLinkRecord = 0;
        int nbrLinkRecordPipe = 0;
        int nbrLinkArrow = 0;
        int nbrBreak = 0;
        int nbrBreakCircle = 0;
        int nbrBreakRect = 0;
        int nbrVisioUnlocked = 0;
        int nbrGroupUnlocked = 0;
        int nbrSelected = 0;
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected()) continue;
                if (graph instanceof AlgaNode) {
                    ++nbrSelected;
                }
                if (graph.isLocked()) {
                    ++nbrLocked;
                    if (graph instanceof AlgaPoints) continue;
                    ++nbrAlignLocked;
                    continue;
                }
                ++this._nbrUnlocked;
                if (graph.isVisio()) {
                    ++nbrVisioUnlocked;
                }
                if (graph instanceof AlgaGroup) {
                    ++nbrGroupUnlocked;
                }
                if (!(graph instanceof AlgaPoints)) {
                    ++nbrAlignUnlocked;
                } else {
                    Iterator<Pt> iterPt = ((AlgaPoints)graph).iteratePoint();
                    while (iterPt.hasNext()) {
                        Pt pt = iterPt.next();
                        if (!pt.isSelected()) continue;
                        ++nbrBreak;
                        switch (pt.getStyle()) {
                            case CIRCLE: {
                                ++nbrBreakCircle;
                                break;
                            }
                            case RECT: {
                                ++nbrBreakRect;
                            }
                        }
                    }
                }
                if (!(graph instanceof AlgaPort)) {
                    ++nbrDeleteUnlocked;
                }
                if (graph instanceof AlgaWithPorts) {
                    ++nbrTextUnlocked;
                }
                if (graph instanceof AlgaDraw) {
                    ++nbrDrawUnlocked;
                }
                if (graph instanceof AlgaNode) {
                    ++this._nbrNodeUnlocked;
                }
                if (!(graph instanceof AlgaLink)) continue;
                ++nbrLinkUnlocked;
                AlgaLink link = (AlgaLink)graph;
                if (link.getNbrPoints() == 2) {
                    ++nbrLinkDirect;
                }
                Pt first = link.getFirstPt();
                Pt last = link.getLastPt();
                if (first.getX() == last.getX()) {
                    ++nbrLinkRight;
                } else if (first.getY() == last.getY()) {
                    ++nbrLinkRight;
                } else {
                    boolean antislash;
                    boolean bl = antislash = first.getX() > last.getX() == first.getY() > last.getY();
                    if (antislash) {
                        ++nbrLinkAntiSlash;
                    } else {
                        ++nbrLinkSlash;
                    }
                }
                if (link.isDrawArrow()) {
                    ++nbrLinkArrow;
                }
                if (!link.getLogical().isRecord()) continue;
                ++nbrLinkRecord;
                if (!link.isPipeStyle()) continue;
                ++nbrLinkRecordPipe;
            }
        }
        this._gui.getDelegateAction("DELETE").setEnabled(this._actionDelete, nbrDeleteUnlocked > 0);
        this._actionRename.setEnabled(this._nbrNodeUnlocked == 1);
        this._actionReplace.setEnabled(this._nbrNodeUnlocked >= 1);
        this._actionEdit.setEnabled(this._nbrNodeUnlocked == 1 && nbrVisioUnlocked == 0 || this._nbrNodeUnlocked == 0 && nbrVisioUnlocked >= 1);
        boolean enabled = nbrLinkUnlocked > 0;
        this._subMenuLink.setEnabled(enabled);
        this._actionLinkConvertCode.setEnabled(enabled);
        this._subMenuLinkArrow.setEnabled(enabled);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_ARROW_ADD").setEnabled(this._actionLinkArrowWith, enabled && nbrLinkUnlocked != nbrLinkArrow);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_ARROW_DEL").setEnabled(this._actionLinkArrowNone, enabled && nbrLinkArrow > 0);
        this._subMenuLinkStyle.setEnabled(enabled);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_DIRECT").setEnabled(this._actionLinkStyleD, enabled && nbrLinkUnlocked != nbrLinkDirect);
        enabled = nbrLinkUnlocked > 0 && nbrLinkUnlocked != nbrLinkRight;
        this._gui.getDelegateAction("OCAS_VIEW_LINK_HORIZONTAL").setEnabled(this._actionLinkStyleH, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_VERTICAL").setEnabled(this._actionLinkStyleV, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_TOP_LEFT").setEnabled(this._actionLinkStyleTL, enabled && nbrLinkSlash > 0);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_TOP_RIGHT").setEnabled(this._actionLinkStyleTR, enabled && nbrLinkAntiSlash > 0);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BOTTOM_LEFT").setEnabled(this._actionLinkStyleBL, enabled && nbrLinkAntiSlash > 0);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BOTTOM_RIGHT").setEnabled(this._actionLinkStyleBR, enabled && nbrLinkSlash > 0);
        enabled = nbrLinkUnlocked > 0 && nbrLinkRecord > 0;
        this._subMenuLinkBody.setEnabled(enabled);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BODY_FILL").setEnabled(this._actionLinkBodyFill, enabled && nbrLinkRecordPipe > 0);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BODY_PIPE").setEnabled(this._actionLinkBodyPipe, enabled && nbrLinkRecordPipe != nbrLinkRecord);
        enabled = nbrLinkUnlocked > 0 && nbrBreak > 0;
        this._subMenuLinkBreak.setEnabled(enabled);
        this._actionLinkBreakNone.setEnabled(enabled && nbrBreakCircle + nbrBreakRect > 0);
        this._actionLinkBreakCircle.setEnabled(enabled && nbrBreak - nbrBreakCircle > 0);
        this._actionLinkBreakRect.setEnabled(enabled && nbrBreak - nbrBreakRect > 0);
        enabled = nbrAlignUnlocked > 0 && nbrAlignUnlocked + nbrAlignLocked > 1;
        this._subMenuAlign.setEnabled(enabled);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_LEFT").setEnabled(this._actionAlignLeft, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_RIGHT").setEnabled(this._actionAlignRight, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_HORIZONTAL").setEnabled(this._actionAlignHorizontal, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_TOP").setEnabled(this._actionAlignTop, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_BOTTOM").setEnabled(this._actionAlignBottom, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_VERTICAL").setEnabled(this._actionAlignVertical, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_CENTER").setEnabled(this._actionAlignCenter, enabled);
        this._subMenuDistrib.setEnabled(enabled);
        this._gui.getDelegateAction("OCAS_VIEW_DISTRIB_HORIZONTALLY").setEnabled(this._actionDistribHoriz, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_DISTRIB_VERTICALLY").setEnabled(this._actionDistribVerti, enabled);
        this._actionGroupAssociate.setEnabled(nbrVisioUnlocked >= 1);
        this._actionGroupDissociate.setEnabled(nbrGroupUnlocked >= 1);
        enabled = nbrTextUnlocked > 0;
        this._subMenuText.setEnabled(enabled);
        this._actionPositionTop.setEnabled(enabled);
        this._actionPositionBottom.setEnabled(enabled);
        this._actionPositionLeft.setEnabled(enabled);
        this._actionPositionRight.setEnabled(enabled);
        this._actionPositionCenter.setEnabled(enabled);
        this._actionPositionNone.setEnabled(enabled);
        enabled = this._nbrUnlocked > 0;
        this._subMenuOrder.setEnabled(enabled);
        this._gui.getDelegateAction("OCAS_VIEW_ORDER_FIRST").setEnabled(this._actionOrderFirst, enabled);
        this._gui.getDelegateAction("OCAS_VIEW_ORDER_LAST").setEnabled(this._actionOrderLast, enabled);
        this._subMenuSheet.setEnabled(enabled);
        this._gui.getDelegateAction("OCAS_VIEW_MIRROR_HORIZONTAL").setEnabled(this._actionMirrorHorizontal, nbrDrawUnlocked > 0);
        this._gui.getDelegateAction("OCAS_VIEW_MIRROR_VERTICAL").setEnabled(this._actionMirrorVertical, nbrDrawUnlocked > 0);
        this._gui.getDelegateAction("OCAS_VIEW_MIRROR_ROTATE").setEnabled(this._actionMirrorRotate, nbrDrawUnlocked > 0);
        this._gui.getDelegateAction("OCAS_VIEW_LOCK_LOCK").setEnabled(this._actionLockLock, this._nbrUnlocked > 0);
        this._gui.getDelegateAction("OCAS_VIEW_LOCK_UNLOCK").setEnabled(this._actionLockUnlock, nbrLocked > 0);
        this._gui.getDelegateAction("OCAS_VIEW_CREATE_EQUIP_FROM_SELECTION").setEnabled(this._actionCreateEqpFromSelection, nbrSelected > 1 && nbrLocked == 0);
        this.refreshActionPaste();
    }

    protected void refreshActionPaste() {
        Transferable transferable = this.getAppl().getLocalClipboard(false).getContents(this);
        boolean canPaste = transferable != null && transferable.isDataFlavorSupported(AltaClipboardTransferable.DB_FLAVOR);
        this._gui.getDelegateAction("PASTE").setEnabled(this._actionPaste, canPaste);
    }

    @Override
    protected AltaContentView createContentView() {
        return new AltaContentEditView(this, this.createContext());
    }

    @Override
    public AltaContentEditView getView() {
        return (AltaContentEditView)super.getView();
    }

    @Override
    protected boolean doEdit() {
        if (!super.doEdit()) {
            OCmdEditVisio cmd = new OCmdEditVisio(this.getAppl(), this);
            cmd.realiseDo();
            return true;
        }
        return false;
    }

    @Override
    protected boolean doCopy() {
        if (!super.doCopy()) {
            return false;
        }
        AltaClipboard cb = new AltaClipboard();
        if (cb.copyFrom(this.getAltaComponent())) {
            AltaClipboardTransferable transferable = new AltaClipboardTransferable(cb);
            this.getAppl().getLocalClipboard(false).setContents(transferable, null);
            this.refreshActionPaste();
            return true;
        }
        return false;
    }

    @Override
    public void toDoWhenActivated() {
        UndoManager undoMng = this.getAltaComponent().getUndoManager();
        this._gui.getDelegateAction("UNDO").addDelegate(this._actionUndo).setEnabled(undoMng.undoable());
        this._gui.getDelegateAction("REDO").addDelegate(this._actionRedo).setEnabled(undoMng.redoable());
        this._gui.getDelegateAction("PASTE").addDelegate(this._actionPaste);
        this._gui.getDelegateAction("DELETE").addDelegate(this._actionDelete);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_DIRECT").addDelegate(this._actionLinkStyleD);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_TOP_LEFT").addDelegate(this._actionLinkStyleTL);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_TOP_RIGHT").addDelegate(this._actionLinkStyleTR);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BOTTOM_LEFT").addDelegate(this._actionLinkStyleBL);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BOTTOM_RIGHT").addDelegate(this._actionLinkStyleBR);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_HORIZONTAL").addDelegate(this._actionLinkStyleH);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_VERTICAL").addDelegate(this._actionLinkStyleV);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BODY_FILL").addDelegate(this._actionLinkBodyFill);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BODY_PIPE").addDelegate(this._actionLinkBodyPipe);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_ARROW_DEL").addDelegate(this._actionLinkArrowNone);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_ARROW_ADD").addDelegate(this._actionLinkArrowWith);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_LEFT").addDelegate(this._actionAlignLeft);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_RIGHT").addDelegate(this._actionAlignRight);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_HORIZONTAL").addDelegate(this._actionAlignHorizontal);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_TOP").addDelegate(this._actionAlignTop);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_BOTTOM").addDelegate(this._actionAlignBottom);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_VERTICAL").addDelegate(this._actionAlignVertical);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_CENTER").addDelegate(this._actionAlignCenter);
        this._gui.getDelegateAction("OCAS_VIEW_DISTRIB_HORIZONTALLY").addDelegate(this._actionDistribHoriz);
        this._gui.getDelegateAction("OCAS_VIEW_DISTRIB_VERTICALLY").addDelegate(this._actionDistribVerti);
        this._gui.getDelegateAction("OCAS_VIEW_ORDER_FIRST").addDelegate(this._actionOrderFirst);
        this._gui.getDelegateAction("OCAS_VIEW_ORDER_LAST").addDelegate(this._actionOrderLast);
        this._gui.getDelegateAction("OCAS_VIEW_MIRROR_HORIZONTAL").addDelegate(this._actionMirrorHorizontal);
        this._gui.getDelegateAction("OCAS_VIEW_MIRROR_VERTICAL").addDelegate(this._actionMirrorVertical);
        this._gui.getDelegateAction("OCAS_VIEW_MIRROR_ROTATE").addDelegate(this._actionMirrorRotate);
        this._gui.getDelegateAction("OCAS_VIEW_CREATE_EQUIP_FROM_SELECTION").addDelegate(this._actionCreateEqpFromSelection);
        this._gui.getDelegateAction("OCAS_VIEW_LOCK_LOCK").addDelegate(this._actionLockLock);
        this._gui.getDelegateAction("OCAS_VIEW_LOCK_UNLOCK").addDelegate(this._actionLockUnlock);
        super.toDoWhenActivated();
    }

    @Override
    public void toDoWhenDeActivated() {
        this._gui.getDelegateAction("UNDO").delDelegate(this._actionUndo).setEnabled(false);
        this._gui.getDelegateAction("REDO").delDelegate(this._actionRedo).setEnabled(false);
        this._gui.getDelegateAction("DELETE").delDelegate(this._actionDelete).setEnabled(false);
        this._gui.getDelegateAction("PASTE").delDelegate(this._actionPaste).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_DIRECT").delDelegate(this._actionLinkStyleD).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_TOP_LEFT").delDelegate(this._actionLinkStyleTL).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_TOP_RIGHT").delDelegate(this._actionLinkStyleTR).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BOTTOM_LEFT").delDelegate(this._actionLinkStyleBL).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BOTTOM_RIGHT").delDelegate(this._actionLinkStyleBR).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_HORIZONTAL").delDelegate(this._actionLinkStyleH).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_VERTICAL").delDelegate(this._actionLinkStyleV).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BODY_FILL").delDelegate(this._actionLinkBodyFill).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_BODY_PIPE").delDelegate(this._actionLinkBodyPipe).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_ARROW_DEL").delDelegate(this._actionLinkArrowNone).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LINK_ARROW_ADD").delDelegate(this._actionLinkArrowWith).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_LEFT").delDelegate(this._actionAlignLeft).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_RIGHT").delDelegate(this._actionAlignRight).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_HORIZONTAL").delDelegate(this._actionAlignHorizontal).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_TOP").delDelegate(this._actionAlignTop).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_BOTTOM").delDelegate(this._actionAlignBottom).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_VERTICAL").delDelegate(this._actionAlignVertical).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_ALIGN_CENTER").delDelegate(this._actionAlignCenter).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_DISTRIB_HORIZONTALLY").delDelegate(this._actionDistribHoriz).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_DISTRIB_VERTICALLY").delDelegate(this._actionDistribVerti).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_ORDER_FIRST").delDelegate(this._actionOrderFirst).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_ORDER_LAST").delDelegate(this._actionOrderLast).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_MIRROR_HORIZONTAL").delDelegate(this._actionMirrorHorizontal).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_MIRROR_VERTICAL").delDelegate(this._actionMirrorVertical).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_MIRROR_ROTATE").delDelegate(this._actionMirrorRotate).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_CREATE_EQUIP_FROM_SELECTION").delDelegate(this._actionCreateEqpFromSelection).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LOCK_LOCK").delDelegate(this._actionLockLock).setEnabled(false);
        this._gui.getDelegateAction("OCAS_VIEW_LOCK_UNLOCK").delDelegate(this._actionLockUnlock).setEnabled(false);
        super.toDoWhenDeActivated();
    }

    public void clearHisto() {
        UndoManager undoMng = this.getAltaComponent().getUndoManager();
        undoMng.clear();
        this._gui.getDelegateAction("UNDO").setEnabled(undoMng.undoable());
        this._gui.getDelegateAction("REDO").setEnabled(undoMng.redoable());
    }

    @Override
    public void addHisto(UndoItem cmd) {
        UndoManager undoMng = this.getAltaComponent().getUndoManager();
        undoMng.addCmd(cmd);
        this._gui.getDelegateAction("UNDO").setEnabled(undoMng.undoable());
        this._gui.getDelegateAction("REDO").setEnabled(undoMng.redoable());
    }

    class MoveIntoSheetAction
    extends CeciliaAction {
        int _idx;

        MoveIntoSheetAction(String labelKey, int idx) {
            super(labelKey);
            this._idx = idx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OCmdMoveIntoSheet cmd = new OCmdMoveIntoSheet(AltaContentEditPanel.this, this._idx);
            cmd.realiseDo();
        }
    }

    abstract class AContentEditAction
    extends AbstractAction {
        String _action;

        AContentEditAction(String act) {
            this._action = act;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("AContentE(");
            AltaContentEditPanel.this.getAltaComponent().getDBFolder().getPathUntilSystem(sb);
            return sb.append(", ").append(this._action).append(")").toString();
        }
    }
}

