/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.action.UndoItem;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.CaptureAction;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditWithZoomPanel;
import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContainer;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AlgaSheetsDlg;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdSheetsModify;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AltaContentPanel
extends AltaEditWithZoomPanel
implements AltaContentView.AltaHitGraphListener {
    public static final String PROP_INFO_WITH_INDEX = "cecilia.mbsa.content.InfoMsgWithIndex";
    private boolean _bInfoWithIndex = Boolean.getBoolean("cecilia.mbsa.content.InfoMsgWithIndex");
    private CeciliaAppl _appl;
    protected CeciliaAction _actionEdit;
    protected AbstractAction _actionCopy;
    protected AltaContentView _contentView;
    private JTextField _message;
    private JButton _sheetButton;
    private AlgaSheetsDlg _sheetDlg;
    private JComboBox _displayMode;
    AbstractAction _actionSelectAll = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectAllThread cmd = new SelectAllThread(AltaContentPanel.this);
            cmd.realiseDo();
        }
    };
    private static int ZOOM_CLIBOARD = 4;

    public AltaContentPanel(CeciliaAppl appl) {
        super(appl);
        this._appl = appl;
    }

    public CeciliaAppl getAppl() {
        return this._appl;
    }

    @Override
    public AltaEquipment getAltaComponent() {
        return (AltaEquipment)this._currentComponent;
    }

    protected boolean isReadOnly() {
        return true;
    }

    protected AlgaContext createContext() {
        AlgaContext context = new AlgaContext();
        context.setPaintingPort(true);
        context.setPrinting(false);
        context.setPolicyLabel(AlgaContext.PolicyLabel.NODE);
        return context;
    }

    public void changePreferencies(Preferencies prefs) {
        PluginWithOptions optsContent;
        PluginWithOptions opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            GeneralTextPreferencies gpref = (GeneralTextPreferencies)opts;
            AlgaContext context = this._contentView.getContext();
            context.setDefaultFontName(gpref.getFontType().toString());
            context.setDefaultFontSize(gpref.getFontSize());
            context.setDefaultFontType(0 + (gpref.getFontBold() ? 1 : 0));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AltaContentPanel.this._contentView.repaint();
                }
            });
        }
        if ((optsContent = prefs.getOptions(AltaContentDisplayPreferencies.PREF_KEY)) != null && optsContent instanceof AltaContentDisplayPreferencies) {
            AltaContentDisplayPreferencies contPref = (AltaContentDisplayPreferencies)optsContent;
            AlgaContext context = this._contentView.getContext();
            context.setPaintingPort(contPref.getPref("displayPorts").isSelected());
            AltaContentDisplayPreferencies.LinkDisplay display = contPref.getLinkDisplayOptions();
            context.setLinkDisplay(display);
        }
    }

    public void setModified(boolean value) {
    }

    protected AltaContentView createContentView() {
        return new AltaContentView(this.createContext());
    }

    public void make() {
        this._actionEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaContentPanel.this.doEdit();
            }
        };
        this._actionCopy = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaContentPanel.this.doCopy();
            }
        };
        this._contentView = this.createContentView();
        this.changePreferencies(this.getAppl().getPreferencies());
        this._scrollView = this._zoomDecorator.createScrollPane();
        this._message = new JTextField("");
        this._message.setEditable(false);
        this._contentView.addAltaHitGraphListener(this);
        this._contentView.setMessageField(this._message);
        this._sheetButton = new JButton(ResMsgVoc.getString("VOC_LAYERS"));
        this._sheetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaContentPanel.this._currentComponent == null) {
                    return;
                }
                if (AltaContentPanel.this._sheetDlg == null) {
                    AltaContentPanel.this._sheetDlg = new AlgaSheetsDlg(SwingUtilities.getWindowAncestor(AltaContentPanel.this._sheetButton));
                }
                OCmdSheetsModify cmd = new OCmdSheetsModify(AltaContentPanel.this.getAppl(), AltaContentPanel.this, AltaContentPanel.this._sheetDlg, AltaContentPanel.this.isReadOnly());
                cmd.realiseDo();
            }
        });
        JLabel lblDisplay = new JLabel(ResMsgVoc.getString("VOC_DISPLAY"));
        lblDisplay.setForeground(Color.black);
        this._displayMode = new JComboBox();
        this._displayMode.addItem(AlgaContext.PolicyLabel.NONE);
        this._displayMode.addItem(AlgaContext.PolicyLabel.NODE);
        this._displayMode.addItem(AlgaContext.PolicyLabel.LINK);
        this._displayMode.addItem(AlgaContext.PolicyLabel.ALL);
        this._displayMode.setSelectedIndex(1);
        this._displayMode.setEditable(false);
        this._displayMode.setRenderer(new AlgaContext.PolicyLabel.SpecificListCellRenderer());
        this._displayMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgaContext.PolicyLabel policy = (AlgaContext.PolicyLabel)((Object)AltaContentPanel.this._displayMode.getSelectedItem());
                if (policy != null && !policy.equals((Object)AltaContentPanel.this._contentView.getContext().getPolicyLabel())) {
                    AltaContentPanel.this._contentView.getContext().setPolicyLabel(policy);
                    AltaContentPanel.this._contentView.repaint();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this._scrollView, new GridBagConstraints(0, 0, 5, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 2, 10), 0, 0));
        this.add((Component)this._message, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 10, 2), 0, 0));
        this.add((Component)this._sheetButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 10, 10), 0, 0));
        this.add((Component)lblDisplay, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 10, 10), 0, 0));
        this.add((Component)this._displayMode, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 10, 10), 0, 0));
    }

    @Override
    public void changeHitGraph(AlgaGraph graph, int x, int y) {
        if (graph == null) {
            this._message.setText("");
            return;
        }
        StringBuilder buffer = new StringBuilder();
        this.changeHitGraph_getHeader_rec(buffer, graph);
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        buffer.append(graph.getTooltip(this.getAltaComponent(), x, y));
        this._message.setText(buffer.toString());
    }

    private void changeHitGraph_getHeader_rec(StringBuilder buffer, AlgaGraph graph) {
        AlgaContainer container = graph.getParent();
        if (container != null) {
            this.changeHitGraph_getHeader_rec(buffer, container);
            if (this._bInfoWithIndex) {
                int idx = container.indexOf(graph);
                if (idx >= 0) {
                    buffer.append("[");
                    if (container instanceof AlgaSheet) {
                        buffer.append(((AlgaSheet)container).getNumber()).append(",");
                    }
                    buffer.append(idx + 1).append("]");
                }
            } else if (container instanceof AlgaSheet) {
                buffer.append("[").append(((AlgaSheet)container).getNumber()).append("]");
            }
        }
    }

    @Override
    public void setComponent(AltaComponent currentComponent) {
        super.setComponent(currentComponent);
        this.refreshContent();
    }

    protected AlgaContent getContent() {
        return this.getAltaComponent().getContent();
    }

    public void refreshContent() {
        AlgaContent content = this.getContent();
        content.computeSize(this.getGraphics());
        this._contentView.setContent(content);
        this.repaint();
    }

    @Override
    public void toDoWhenDeActivated() {
        this._gui.getDelegateAction("SELECTALL").delDelegate(this._actionSelectAll).setEnabled(false);
        this._gui.getDelegateAction("COPY").delDelegate(this._actionCopy).setEnabled(false);
        super.toDoWhenDeActivated();
    }

    @Override
    public void toDoWhenActivated() {
        this._gui.getDelegateAction("SELECTALL").addDelegate(this._actionSelectAll);
        this._gui.getDelegateAction("COPY").addDelegate(this._actionCopy);
        super.toDoWhenActivated();
        this.refreshActions();
    }

    public final void doRefreshActions() {
        Container parent = SwingUtilities.getAncestorOfClass(JInternalFrame.class, this);
        if (parent != null && parent instanceof JInternalFrame && !((JInternalFrame)parent).isSelected()) {
            return;
        }
        parent = SwingUtilities.getAncestorOfClass(JTabbedPane.class, this);
        if (parent != null && parent instanceof JTabbedPane && ((JTabbedPane)parent).getSelectedComponent() != this) {
            return;
        }
        this.refreshActions();
    }

    protected void refreshActions() {
        int nbrSelect = 0;
        int nbrUnSelect = 0;
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (graph.isSelected()) {
                    ++nbrSelect;
                    continue;
                }
                ++nbrUnSelect;
            }
        }
        this._gui.getDelegateAction("COPY").setEnabled(this._actionCopy, nbrSelect > 0);
        this._gui.getDelegateAction("SELECTALL").setEnabled(this._actionSelectAll, nbrUnSelect > 0);
    }

    public AltaContentView getView() {
        return this._contentView;
    }

    public void refreshScroll(boolean raz) {
        Dimension currentSize = this._contentView.getSize();
        this.refreshContent();
        Dimension preferrSize = this._contentView.getPreferredSize();
        if (currentSize.equals(preferrSize)) {
            return;
        }
        this._contentView.setSize(preferrSize);
        this._zoomDecorator.refreshScroll(raz);
    }

    @Override
    public double getZoom() {
        return this._contentView.getZoom();
    }

    @Override
    public void setZoom(double value) {
        this._contentView.setZoom(value);
    }

    protected boolean editOnlyReadOnly() {
        return false;
    }

    protected boolean doEdit() {
        AlgaGraph grf = this.getContent().getSelectedGraph();
        if (grf != null && grf instanceof AlgaNode) {
            AltaSub sub = ((AlgaNode)grf).getLogical();
            DBFolder dbFolder = sub.getNode().getDBFolder();
            DBFolderTreeActivable tree = this.getAppl().getTopWindow().getFolders().getTree(dbFolder.getFamily());
            if (tree != null) {
                tree.edit(dbFolder, this.editOnlyReadOnly());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean transfertImageToClipboard() {
        int tl_y = Integer.MAX_VALUE;
        int tl_x = Integer.MAX_VALUE;
        int br_y = 0;
        int br_x = 0;
        BufferedImage image = new BufferedImage(100, 100, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        ArrayList<AlgaGraph> selectedGraphs = new ArrayList<AlgaGraph>();
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected()) continue;
                Rectangle rect = graph.getBounds(g);
                if (rect.x < tl_x) {
                    tl_x = rect.x;
                }
                if (rect.y < tl_y) {
                    tl_y = rect.y;
                }
                if (rect.x + rect.width > br_x) {
                    br_x = rect.x + rect.width;
                }
                if (rect.y + rect.height > br_y) {
                    br_y = rect.y + rect.height;
                }
                selectedGraphs.add(graph);
            }
        }
        if (selectedGraphs.isEmpty()) {
            return false;
        }
        int width = (br_x - tl_x + 20) * ZOOM_CLIBOARD;
        int height = (br_y - tl_y + 20) * ZOOM_CLIBOARD;
        image = new BufferedImage(width, height, 1);
        g = (Graphics2D)image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.scale(ZOOM_CLIBOARD, ZOOM_CLIBOARD);
        g.translate(-tl_x + 10, -tl_y + 10);
        AlgaContext context = this.getView().getContext();
        boolean oldValue = context.isPrinting();
        try {
            context.setPrinting(true);
            for (int i = selectedGraphs.size() - 1; i >= 0; --i) {
                AlgaGraph grf = (AlgaGraph)selectedGraphs.get(i);
                grf.paint(g, context);
            }
        }
        finally {
            context.setPrinting(oldValue);
        }
        final CaptureAction.TransferableImage transferableImage = new CaptureAction.TransferableImage(image);
        new Thread("System Clipboard"){

            @Override
            public void run() {
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferableImage, null);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return;
                }
            }
        }.start();
        return true;
    }

    protected boolean doCopy() {
        return this.transfertImageToClipboard();
    }

    public void addHisto(UndoItem cmd) {
    }

    @Override
    public Rectangle getSelectionRect() {
        Rectangle rectSelectedGraphs = this.getContent().getClipArea();
        if (rectSelectedGraphs == null) {
            return null;
        }
        double zoom = this.getZoom();
        double rectXZoomed = rectSelectedGraphs.getX() * zoom;
        double rectYZoomed = rectSelectedGraphs.getY() * zoom;
        double rectXMaxZoomed = rectSelectedGraphs.getWidth() * zoom;
        double rectYMaxZoomed = rectSelectedGraphs.getHeight() * zoom;
        return new Rectangle((int)rectXZoomed, (int)rectYZoomed, (int)rectXMaxZoomed, (int)rectYMaxZoomed);
    }

    @Override
    public JComponent getContentView() {
        return this._contentView;
    }

    class SelectAllThread
    extends CThread {
        public SelectAllThread(Component c) {
            super(c);
        }

        @Override
        protected void firstDo() {
            List<AlgaSheet> sheets = AltaContentPanel.this.getContent().getSheets();
            for (int i = sheets.size() - 1; i >= 0; --i) {
                AlgaSheet sheet = sheets.get(i);
                boolean select = sheet.isVisible();
                for (AlgaGraph graph : sheet.getGraphs()) {
                    graph.setSelected(select);
                }
            }
            AltaContentPanel.this._contentView.repaint();
            AltaContentPanel.this._contentView.fireChangeSelect();
        }
    }
}

