/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.tree.JTreeUtility;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaEquipmentTreeModel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaEquipmentTreeRenderer;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaEvt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaSubEventTableModel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaSubEventTablePanel;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class AltaSynchroEditDlg
extends JDialogCecilia {
    JTextField _ctrlName;
    JComboBox _ctrlType;
    JTextArea _ctrlRemark;
    AltaSubEventTableModel _ctrlEvtsModel;
    AltaSubEventTablePanel _ctrlEvtsPanel;
    JLabel _ctrlSystemPath;
    AltaEquipmentTreeModel _ctrlSystemModel;
    JTree _ctrlSystemTree;
    boolean _bEditable = true;
    AltaEquipment _system;
    String _initName;
    HashSet<String> _setNameTaboo = new HashSet();

    public AltaSynchroEditDlg(Window owner) {
        super(owner);
        this.make();
    }

    protected void make() {
        this.init();
        JPanel north = new JPanel(new GridBagLayout());
        JLabel lblName = new JLabel(ResMsgVoc.getString("VOC_NAME"));
        this._ctrlName = new JTextField();
        JLabel lblRemark = new JLabel(ResMsgVoc.getString("VOC_COMMENTS"));
        this._ctrlRemark = new JTextArea(3, 25);
        JScrollPane scrollRemark = new JScrollPane(this._ctrlRemark);
        north.add((Component)lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)lblRemark, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)scrollRemark, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        north.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this._ctrlEvtsModel = new AltaSubEventTableModel(new ArrayList<AltaEvt>(), north);
        this._ctrlEvtsPanel = new AltaSubEventTablePanel(this, this._ctrlEvtsModel){

            @Override
            protected void refreshCtrl() {
                int row;
                AltaEvt init;
                TreePath path;
                super.refreshCtrl();
                if (this.getSelectedRowCount() == 1 && (path = AltaSynchroEditDlg.this._ctrlSystemModel.constructTreePath((init = (AltaEvt)AltaSynchroEditDlg.this._ctrlEvtsModel.getItemAt(row = this.getSelectedRow())).getPath())) != null) {
                    AltaSynchroEditDlg.this._ctrlSystemTree.expandPath(path);
                    AltaSynchroEditDlg.this._ctrlSystemTree.scrollPathToVisible(path);
                    AltaSynchroEditDlg.this._ctrlSystemTree.setSelectionPath(path);
                }
            }
        };
        this._ctrlEvtsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10));
        this._ctrlSystemPath = new JLabel("Project/System/Model;1");
        this._ctrlSystemPath.setIcon(ResIcoCore.getImageIcon("FOLDER_MODEL_"));
        this._ctrlSystemPath.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this._ctrlSystemModel = new AltaEquipmentTreeModel();
        this._ctrlSystemModel.setFilter(AltaEquipmentTreeModel.VisibleField.EVENTS);
        this._ctrlSystemModel.setOnlySub(true);
        this._ctrlSystemTree = new JTree(this._ctrlSystemModel);
        this._ctrlSystemTree.setRootVisible(false);
        this._ctrlSystemTree.setCellRenderer(new AltaEquipmentTreeRenderer());
        this._ctrlSystemTree.getSelectionModel().setSelectionMode(1);
        this._ctrlSystemTree.setRowHeight(ResIcoAbstract.getIconSize());
        this._ctrlSystemTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!AltaSynchroEditDlg.this._bEditable) {
                    return;
                }
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                TreePath treepath = AltaSynchroEditDlg.this._ctrlSystemTree.getSelectionPath();
                if (treepath == null) {
                    return;
                }
                if (AltaSynchroEditDlg.this._ctrlSystemModel.isLeaf(treepath.getLastPathComponent())) {
                    String path = AltaSynchroEditDlg.this._ctrlSystemModel.constructPath(treepath);
                    AltaEvt addEvt = null;
                    ObjectWithName obj = AltaSynchroEditDlg.this._system.findFieldFromPath(path);
                    if (obj == null || !(obj instanceof AltaEvent)) {
                        return;
                    }
                    addEvt = new AltaEvt(path, false);
                    int idxInsert = -1;
                    for (int i = 0; idxInsert < 0 && i < AltaSynchroEditDlg.this._ctrlEvtsModel.getRowCount(); ++i) {
                        AltaEvt init = (AltaEvt)AltaSynchroEditDlg.this._ctrlEvtsModel.getItemAt(i);
                        int cmp = path.compareTo(init.getPath());
                        if (cmp == 0) {
                            AltaSynchroEditDlg.this._ctrlEvtsPanel.getTableCtrl().getSelectionModel().setSelectionInterval(i, i);
                            return;
                        }
                        if (cmp >= 0) continue;
                        idxInsert = i;
                    }
                    if (idxInsert < 0) {
                        AltaSynchroEditDlg.this._ctrlEvtsModel.addData(addEvt);
                        idxInsert = AltaSynchroEditDlg.this._ctrlEvtsModel.getRowCount() - 1;
                    } else {
                        AltaSynchroEditDlg.this._ctrlEvtsModel.insertData(addEvt, idxInsert);
                    }
                    AltaSynchroEditDlg.this._ctrlEvtsPanel.getTableCtrl().getSelectionModel().setSelectionInterval(idxInsert, idxInsert);
                }
            }
        });
        JPanel southWest = new JPanel(new BorderLayout());
        southWest.add((Component)this._ctrlSystemPath, "North");
        southWest.add((Component)new JScrollPane(this._ctrlSystemTree), "Center");
        southWest.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        JSplitPane southSplit = new JSplitPane(1, southWest, this._ctrlEvtsPanel);
        JSplitPane centerSplit = new JSplitPane(0, north, southSplit);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)centerSplit, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.setTitle(ResMsgOcas.getString("MENU_GLOBAL_SYNC"));
        this.setModal(true);
        this.pack();
        Dimension size = this.getSize();
        size.width += 120;
        this.setSize(size);
        southSplit.setDividerLocation(0.33);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    public void setSynchro(AltaSynchro sync, Collection<AltaSynchro> allSynchro, AltaEquipment equip) {
        this._system = equip;
        this._setNameTaboo.clear();
        for (AltaSynchro otherSynchro : allSynchro) {
            if (otherSynchro == sync) continue;
            this._setNameTaboo.add(otherSynchro.getName());
        }
        this._initName = sync.getName();
        this._ctrlName.setText(this._initName);
        this._ctrlRemark.setText(sync.getLabel());
        this._ctrlEvtsModel.populateWith(sync.getEvents(), this._system);
        this._ctrlSystemPath.setText(equip.getRefPath());
        JTreeUtility.Configuration config = JTreeUtility.saveConfiguration(this._ctrlSystemTree);
        this._ctrlSystemModel.setRoot(equip, true);
        JTreeUtility.loadConfiguration(this._ctrlSystemTree, config);
    }

    @Override
    protected boolean verifyParameters() {
        String errMsg;
        String name = this._ctrlName.getText().trim();
        if (name.isEmpty()) {
            String title = ResMsgVoc.getString("VOC_NAME");
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgCore.msgFormat("MSG_ERR_FIELD_EMPTY", title), this.getTitle(), 0);
            this._ctrlName.requestFocus();
            return false;
        }
        if (!this._initName.equals(name) && (errMsg = UtilOcas.validateNameAltaRica(name, this._system)) != null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), errMsg, ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        return true;
    }

    public void setEditable(boolean editable) {
        if (this._bEditable == editable) {
            return;
        }
        this._bEditable = editable;
        this._ctrlName.setEditable(editable);
        this._ctrlRemark.setEditable(editable);
        this._ctrlEvtsPanel.setEditable(editable);
    }

    @Override
    public String getName() {
        return this._ctrlName.getText().trim();
    }

    public String getLabel() {
        return this._ctrlRemark.getText();
    }

    public List<String> getEvents() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this._ctrlEvtsModel.getRowCount(); ++i) {
            AltaEvt init = (AltaEvt)this._ctrlEvtsModel.getItemAt(i);
            result.add(init.getPath());
        }
        return result;
    }
}

