/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AltaSynchroTableCellRenderer
extends DefaultTableCellRenderer {
    int _maxNbr = 5;

    public AltaSynchroTableCellRenderer() {
        this.setOpaque(true);
    }

    public int getMaxNbr() {
        return this._maxNbr;
    }

    public AltaSynchroTableCellRenderer setMaxNbr(int value) {
        if (value > 0 && value <= 100) {
            this._maxNbr = value;
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(final JTable table, Object value, boolean isSelected, boolean hasFocus, final int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!(value instanceof AltaSynchro)) {
            return this;
        }
        AltaSynchro sync = (AltaSynchro)value;
        List<String> events = sync.getEvents();
        if (events.isEmpty()) {
            this.setText("");
            this.setToolTipText(null);
        } else {
            Object text = null;
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (int i = 0; i < events.size(); ++i) {
                if (i > 0) {
                    sb.append("<br/>");
                }
                if (i == this._maxNbr) {
                    text = sb.toString() + "...</html>";
                }
                sb.append(events.get(i));
            }
            sb.append("</html>");
            if (text == null) {
                text = sb.toString();
            }
            this.setText((String)text);
            this.setToolTipText(sb.toString());
        }
        final int height = table.getRowHeight() * (events.isEmpty() ? 1 : Math.min(events.size(), this._maxNbr + 1));
        if (height != table.getRowHeight(row)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.setRowHeight(row, height);
                }
            });
        }
        return this;
    }
}

