/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdGraphMove;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OCmdGraphDistribute
extends OCmdGraphMove {
    private final double DOUBLE_CLOSE_TO_ONE = 0.99999999999;
    private final double NEGATIVE_NUMBER = -1.0E-10;
    private int _nbrPivot = 0;
    private AlgaGraph _firstPivot;
    private double _interval;

    public OCmdGraphDistribute(CeciliaAppl appl, AltaContentEditPanel c, OCmdGraphMove.Move distrib) {
        super(appl, c, distrib);
    }

    @Override
    protected boolean prepareDo() {
        List<AlgaSheet> sheets = this.getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected()) continue;
                this._graphs.add(graph);
            }
        }
        if (this._graphs.size() < 3) {
            return false;
        }
        Collections.sort(this._graphs, new ComparatorGraphsPosition(this._align));
        for (AlgaGraph graph : this._graphs) {
            if (!graph.isLocked()) continue;
            ++this._nbrPivot;
            if (this._firstPivot != null) continue;
            this._firstPivot = graph;
        }
        if (this._nbrPivot < 0 || this._nbrPivot > 2) {
            return false;
        }
        this.updateOldLocations();
        this._interval = this.computeInterval();
        return !this.graphOutOfBounds();
    }

    @Override
    public void redo() {
        this.actionDo();
        this.refreshAll();
    }

    @Override
    protected void actionDo() {
        double decimalPart = 0.0;
        boolean first = true;
        if (this._firstPivot != null) {
            AlgaGraph graphRef;
            AlgaGraph graphToMove;
            int i;
            int indexOfPivot = this._graphs.indexOf(this._firstPivot);
            int offset = 1;
            decimalPart = 1.0;
            for (i = indexOfPivot - 1; i >= 0; --i) {
                graphToMove = (AlgaGraph)this._graphs.get(i);
                assert (!graphToMove.isLocked()) : "\u00c0 aucun moment on doit avoir un autre pivot avant le premier.";
                offset = 0;
                if (this._interval - (double)((int)this._interval) != 0.0) {
                    if (first) {
                        --offset;
                        first = false;
                    }
                    if ((decimalPart -= this._interval - (double)((int)this._interval)) < -1.0E-10) {
                        --offset;
                        decimalPart += 1.0;
                    }
                }
                graphRef = (AlgaGraph)this._graphs.get(i + 1);
                if ((offset += this._align == OCmdGraphMove.Move.HORIZONTAL ? graphRef.getX() + graphRef.getWUser() / 2 - (int)this._interval : graphRef.getY() + graphRef.getHUser() / 2 - (int)this._interval) < 0) continue;
                if (this._align == OCmdGraphMove.Move.HORIZONTAL) {
                    this.moveGraphToNewPos(this._align, offset - graphToMove.getWUser() / 2, graphToMove);
                } else {
                    this.moveGraphToNewPos(this._align, offset - graphToMove.getHUser() / 2, graphToMove);
                }
                graphToMove.computeControlPoints();
            }
            decimalPart = 0.0;
            for (i = indexOfPivot + 1; i < this._graphs.size(); ++i) {
                graphToMove = (AlgaGraph)this._graphs.get(i);
                if (graphToMove.isLocked()) continue;
                graphRef = (AlgaGraph)this._graphs.get(i - 1);
                offset = this._align == OCmdGraphMove.Move.HORIZONTAL ? graphRef.getX() + graphRef.getWUser() / 2 + (int)this._interval : graphRef.getY() + graphRef.getHUser() / 2 + (int)this._interval;
                if ((decimalPart += this._interval - (double)((int)this._interval)) > 0.99999999999) {
                    ++offset;
                    decimalPart -= 1.0;
                }
                if (this._align == OCmdGraphMove.Move.HORIZONTAL) {
                    this.moveGraphToNewPos(this._align, offset - graphToMove.getWUser() / 2, graphToMove);
                } else {
                    this.moveGraphToNewPos(this._align, offset - graphToMove.getHUser() / 2, graphToMove);
                }
                graphToMove.computeControlPoints();
            }
        } else {
            this.distributeWithoutPivot_util(this._align, this._graphs);
        }
    }

    private final void distributeWithoutPivot_util(OCmdGraphMove.Move move, List<AlgaGraph> graphs) {
        assert (move == OCmdGraphMove.Move.HORIZONTAL || move == OCmdGraphMove.Move.VERTICAL) : "OCmdDistrib ne peut qu'avoir VERTICAL ou HORIZONTAL en param\u00e8tre";
        AlgaGraph graphRef = graphs.get(0);
        int sizeGraph = graphs.size() - 1;
        double decimalPart = 0.0;
        int posRef = move == OCmdGraphMove.Move.HORIZONTAL ? graphRef.getX() + graphRef.getWUser() / 2 : graphRef.getY() + graphRef.getHUser() / 2;
        for (int i = 1; i < sizeGraph; ++i) {
            int newCoord;
            AlgaGraph graph = (AlgaGraph)this._graphs.get(i);
            decimalPart += this._interval - (double)((int)this._interval);
            int n = newCoord = move == OCmdGraphMove.Move.HORIZONTAL ? posRef - graph.getWUser() / 2 + (int)this._interval : posRef - graph.getHUser() / 2 + (int)this._interval;
            if (decimalPart >= 0.99999999999) {
                ++newCoord;
                decimalPart -= 1.0;
            }
            if (move == OCmdGraphMove.Move.HORIZONTAL) {
                this.moveGraphToNewPos(move, newCoord, graph);
                posRef = graph.getX() + graph.getWUser() / 2;
            } else {
                this.moveGraphToNewPos(move, newCoord, graph);
                posRef = graph.getY() + graph.getHUser() / 2;
            }
            graph.computeControlPoints();
        }
    }

    public double computeInterval() {
        double sumInterval = 0.0;
        ArrayList<AlgaGraph> graphs = null;
        if (this._nbrPivot == 0 || this._nbrPivot == 1) {
            graphs = this._graphs;
        } else if (this._nbrPivot == 2) {
            boolean firstPivotCrossed = false;
            ArrayList<AlgaGraph> graphIntermediaire = new ArrayList<AlgaGraph>();
            for (AlgaGraph graph : this._graphs) {
                if (graph.isLocked()) {
                    if (!firstPivotCrossed) {
                        firstPivotCrossed = true;
                    } else {
                        graphIntermediaire.add(graph);
                        break;
                    }
                }
                if (!firstPivotCrossed) continue;
                graphIntermediaire.add(graph);
            }
            graphs = graphIntermediaire;
        }
        AlgaGraph firstGraph = (AlgaGraph)graphs.get(0);
        AlgaGraph lastGraph = (AlgaGraph)graphs.get(graphs.size() - 1);
        sumInterval = this._align == OCmdGraphMove.Move.HORIZONTAL ? (double)(lastGraph.getX() + lastGraph.getWUser() / 2 - (firstGraph.getX() + firstGraph.getWUser() / 2)) : (double)(lastGraph.getY() + lastGraph.getHUser() / 2 - (firstGraph.getY() + firstGraph.getHUser() / 2));
        return sumInterval /= (double)(graphs.size() - 1);
    }

    private boolean graphOutOfBounds() {
        if (this._graphs.indexOf(this._firstPivot) == 0) {
            return false;
        }
        if (this._firstPivot != null) {
            int fixedValue = this._align == OCmdGraphMove.Move.HORIZONTAL ? this._firstPivot.getX() : this._firstPivot.getY();
            return (double)fixedValue - this._interval < 0.0;
        }
        return false;
    }

    public static class ComparatorGraphsPosition
    implements Comparator<AlgaGraph> {
        private final OCmdGraphMove.Move _move;

        public ComparatorGraphsPosition(OCmdGraphMove.Move move) {
            this._move = move;
        }

        @Override
        public int compare(AlgaGraph graph1, AlgaGraph graph2) {
            int graph1X = graph1.getX() + graph1.getWUser() / 2;
            int graph1Y = graph1.getY() + graph1.getHUser() / 2;
            int graph2X = graph2.getX() + graph2.getWUser() / 2;
            int graph2Y = graph2.getY() + graph2.getHUser() / 2;
            switch (this._move) {
                case HORIZONTAL: {
                    return this.compareValues(graph1X, graph2X, graph1Y, graph2Y);
                }
                case VERTICAL: {
                    return this.compareValues(graph1Y, graph2Y, graph1X, graph2X);
                }
            }
            assert (false) : "OCmdDistrib ne peut qu'avoir VERTICAL ou HORIZONTAL en param\u00e8tre";
            return 0;
        }

        public int compareValues(int firstCoord1, int firstCoord2, int lastCoord1, int lastCoord2) {
            if (firstCoord1 > firstCoord2) {
                return 1;
            }
            if (firstCoord1 < firstCoord2) {
                return -1;
            }
            if (lastCoord1 > lastCoord2) {
                return 1;
            }
            if (lastCoord1 < lastCoord2) {
                return -1;
            }
            return 0;
        }
    }
}

