/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Rectangle;
import javax.swing.JOptionPane;

public class OCmdInsertSub
extends OCCmd {
    DBFolder _dbModel;
    AltaComponent _dbComponent;
    int _x;
    int _y;
    String _name;
    AltaSub _subLogical;
    AlgaNode _subGraphical;
    AlgaSheet _subSheet;

    public OCmdInsertSub(CeciliaAppl appl, AltaContentEditPanel c, DBFolder dbModel, int x, int y) {
        super(appl, c);
        this._dbModel = dbModel;
        this._x = x;
        this._y = y;
    }

    @Override
    protected boolean prepareDo() {
        if (!this._dbModel.isVersion()) {
            return false;
        }
        if (this._dbModel.getFamily() != DBFolder.Family.EQUIPMENT && this._dbModel.getFamily() != DBFolder.Family.COMPONENT) {
            return false;
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && this.getNode().getSubs().size() >= DemoLimits.Limit.EQUIPMENT_SUBS.getLimit()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getPanel()), ResMsgOcas.getString("DEMO_EQUIPMENT_SUBS"), JOptionCecilia.getTopTitleOf(this.getPanel()), 0);
            return false;
        }
        DBWrap dbWrap = this.getAppl().getDAOFactory().findOrCreateWrap(this._dbModel);
        if (dbWrap != null && dbWrap instanceof AltaComponent) {
            this._dbComponent = (AltaComponent)dbWrap;
            return true;
        }
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getPanel()), ResMsgOcas.msgFormat("MSG_RAW_COMPONENT_READ", this._dbModel.getRefPath()));
        return false;
    }

    @Override
    protected void firstDo() {
        String name = this._dbModel.getParent().getName();
        String separator = "";
        PluginWithOptions opts = this.getAppl().getPreferencies().getOptions(AltaContentDisplayPreferencies.PREF_KEY);
        if (opts != null && opts instanceof AltaContentDisplayPreferencies) {
            AltaContentDisplayPreferencies pref = (AltaContentDisplayPreferencies)opts;
            separator = pref.getSeparator();
        }
        int i = 1;
        while (true) {
            this._name = name + separator + i;
            if (this.getNode().getSub(this._name) == null) break;
            ++i;
        }
        this._subLogical = new AltaSub(this._dbComponent, this._name);
        this._subGraphical = new AlgaNode().setLogical(this._subLogical);
        this._subGraphical.setNamePosition(this._dbComponent.getTextPosition());
        double zoom = this.getView().getZoom();
        this._subGraphical.computeControlPoints();
        Rectangle bounds = this._subGraphical.getBounds(this.getView().getGraphics());
        if ((double)this._x / zoom - (double)(bounds.width / 2) < 0.0) {
            this._x = (int)((double)(bounds.width / 2) * zoom);
        }
        if ((double)this._y / zoom - (double)(bounds.height / 2) < 0.0) {
            this._y = (int)((double)(bounds.height / 2) * zoom);
        }
        this._subGraphical.setCX(Math.round((float)this._x / (float)zoom)).setCY(Math.round((float)this._y / (float)zoom));
        this._subGraphical.computeControlPoints();
        this._subSheet = this.getNode().getContent().getCurrentSheet();
        this.redo();
        this.getPanel().addHisto(this);
    }

    @Override
    public void redo() {
        this.getNode().addSub(this._subLogical);
        this._subSheet.add(this._subGraphical, Integer.MAX_VALUE);
        this.getContent().changeSelectGraphs(null, false);
        this._subGraphical.setSelected(true);
        this.refreshAll();
        this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
        this.getNode().setChangeInternalStructure(true);
    }

    @Override
    public void undo() {
        this._subSheet.remove(this._subGraphical);
        this.getNode().delSub(this._subLogical);
        this.refreshAll();
        this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
        this.getNode().setChangeInternalStructure(true);
    }
}

