/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.List;

public class OCmdLinkStyle
extends OCCmd {
    Style _style;
    List<AlgaLink> _graphs;
    List<ArrayList<Pt>> _oldPoints;

    public OCmdLinkStyle(CeciliaAppl appl, AltaContentEditPanel c, Style align) {
        super(appl, c);
        this._style = align;
        this._graphs = new ArrayList<AlgaLink>(32);
        this._oldPoints = new ArrayList<ArrayList<Pt>>(32);
    }

    @Override
    protected void firstDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected() || !(graph instanceof AlgaLink) || graph.isLocked()) continue;
                this._graphs.add((AlgaLink)graph);
                this._oldPoints.add(((AlgaLink)graph).getPoints());
            }
        }
        if (this._graphs.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void redo() {
        int i = this._graphs.size() - 1;
        while (true) {
            block16: {
                if (i < 0) {
                    this.refreshAll();
                    return;
                }
                AlgaLink graph = this._graphs.get(i);
                Pt first = graph.getFirstPt();
                Pt last = graph.getLastPt();
                ArrayList<Pt> points = new ArrayList<Pt>();
                switch (this._style) {
                    case D: {
                        break;
                    }
                    case V: {
                        int tmp;
                        if (first.getX() != last.getX() && first.getY() != last.getY()) {
                            tmp = (first.getX() + last.getX()) / 2;
                            points.add(new Pt(tmp, first.getY()));
                            points.add(new Pt(tmp, last.getY()));
                            break;
                        }
                        break block16;
                    }
                    case H: {
                        int tmp;
                        if (first.getX() != last.getX() && first.getY() != last.getY()) {
                            tmp = (first.getY() + last.getY()) / 2;
                            points.add(new Pt(first.getX(), tmp));
                            points.add(new Pt(last.getX(), tmp));
                            break;
                        }
                        break block16;
                    }
                    case BL: {
                        if (first.getX() > last.getX() == first.getY() > last.getY()) {
                            points.add(new Pt(Math.min(first.getX(), last.getX()), Math.max(first.getY(), last.getY())));
                            break;
                        }
                        break block16;
                    }
                    case TR: {
                        if (first.getX() > last.getX() == first.getY() > last.getY()) {
                            points.add(new Pt(Math.max(first.getX(), last.getX()), Math.min(first.getY(), last.getY())));
                            break;
                        }
                        break block16;
                    }
                    case TL: {
                        if (first.getX() > last.getX() != first.getY() > last.getY()) {
                            points.add(new Pt(Math.min(first.getX(), last.getX()), Math.min(first.getY(), last.getY())));
                            break;
                        }
                        break block16;
                    }
                    case BR: {
                        if (first.getX() > last.getX() == first.getY() > last.getY()) break block16;
                        points.add(new Pt(Math.max(first.getX(), last.getX()), Math.max(first.getY(), last.getY())));
                    }
                }
                graph.setPoints(points);
                graph.computeControlPoints();
            }
            --i;
        }
    }

    @Override
    public void undo() {
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaLink graph = this._graphs.get(i);
            graph.setPoints(this._oldPoints.get(i));
            graph.computeControlPoints();
        }
        this.refreshAll();
    }

    public static enum Style {
        D,
        BL,
        TR,
        TL,
        BR,
        V,
        H;

    }
}

