/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaFlowPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdDelete;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Point;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class OCmdModifyPorts
extends OCCmd {
    List<AltaLink> _links;
    AltaFlowPanel _flowPanel;
    List<AltaFlowPanel.PortModifier> _redoPorts;
    List<AltaFlowPanel.PortModifier> _undoPorts;
    Map<AlgaPort, AlgaPort> _modifyLocationPorts;
    List<AltaFlow> _deletePorts;
    OCmdDelete _deletePortsCmd;
    List<AlgaPort> _insertPorts;
    AlgaSheet _insertPortsSheet;
    protected static final int FLAG_LOCKED_VIRTUAL = 4;

    public OCmdModifyPorts(CeciliaAppl appl, AltaContentEditPanel contentPanel, AltaFlowPanel flowPanel, List<AltaFlowPanel.PortModifier> ports) {
        super(appl, contentPanel);
        this.setSource(flowPanel);
        this._flowPanel = flowPanel;
        this._redoPorts = new ArrayList<AltaFlowPanel.PortModifier>(ports);
        this._modifyLocationPorts = new IdentityHashMap<AlgaPort, AlgaPort>();
        this._links = new ArrayList<AltaLink>();
    }

    @Override
    protected boolean prepareDo() {
        LinkedHashMap<AltaFlow, AlgaPort> mapForLocation = new LinkedHashMap<AltaFlow, AlgaPort>();
        LinkedHashMap<AltaFlow, AltaFlowPanel.PortModifier> mapForDeleteLink = new LinkedHashMap<AltaFlow, AltaFlowPanel.PortModifier>();
        boolean changeLocation = false;
        boolean changeOrientationToLocal = false;
        boolean changeOrientationFromLocal = false;
        for (AltaFlowPanel.PortModifier port : this._redoPorts) {
            if (port.getOrientation() != null) {
                if (port.getOrientation() == AltaFlow.Orientation.LOCAL) {
                    if (!changeOrientationToLocal) {
                        this._deletePorts = new ArrayList<AltaFlow>(this._redoPorts.size());
                        changeOrientationToLocal = true;
                    }
                    this._deletePorts.add(port.getPort());
                } else {
                    if (port.getPort().getOrientation() == AltaFlow.Orientation.LOCAL) {
                        if (!changeOrientationFromLocal) {
                            this._insertPorts = new ArrayList<AlgaPort>(this._redoPorts.size());
                            this._insertPortsSheet = this.getNode().getContent().getCurrentSheet();
                            changeOrientationFromLocal = true;
                        }
                        AlgaPort algaPort = this.getNode().createPort(port.getPort());
                        algaPort.computeControlPoints();
                        this.getNode().deletePort(port.getPort());
                        this._insertPorts.add(algaPort);
                    }
                    mapForDeleteLink.put(port.getPort(), port);
                }
            } else if (port.getType() != null) {
                mapForDeleteLink.put(port.getPort(), port);
            }
            changeLocation = changeLocation || port.getLocation() != null;
        }
        if (this._deletePorts != null && !this._deletePorts.isEmpty()) {
            this._deletePortsCmd = new OCmdDelete(this.getAppl(), (AltaContentEditPanel)this.getPanel()){

                @Override
                protected void preparePort(AlgaPort port) {
                    if (!OCmdModifyPorts.this._deletePorts.contains(port.getFlow())) {
                        port.setFlag(4);
                    }
                }

                @Override
                protected boolean isSelectedGraph(AlgaGraph graph) {
                    if (graph instanceof AlgaPort) {
                        return OCmdModifyPorts.this._deletePorts.contains(((AlgaPort)graph).getFlow());
                    }
                    return false;
                }

                @Override
                protected boolean isLockedGraph(AlgaGraph graph) {
                    if (graph instanceof AlgaPort && OCmdModifyPorts.this._deletePorts.contains(((AlgaPort)graph).getFlow())) {
                        return false;
                    }
                    return super.isLockedGraph(graph);
                }
            };
            if (!this._deletePortsCmd.prepareDo()) {
                return false;
            }
        }
        if (!mapForDeleteLink.isEmpty() || changeLocation) {
            List<AlgaSheet> sheets = this.getContent().getSheets();
            boolean selectIndirectLocked = false;
            boolean selectIndirectInvisible = false;
            for (int i = sheets.size() - 1; i >= 0; --i) {
                AlgaSheet sheet = sheets.get(i);
                for (AlgaGraph graph : sheet.getGraphs()) {
                    if (graph instanceof AlgaLink && !mapForDeleteLink.isEmpty()) {
                        AlgaWithPorts port;
                        AltaLink link = ((AlgaLink)graph).getLogical();
                        boolean added = false;
                        if (!added && (port = link.getFromGraphic()) instanceof AlgaPort && mapForDeleteLink.containsKey(((AlgaPort)port).getFlow())) {
                            if (graph.isLocked()) {
                                selectIndirectLocked = true;
                                mapForDeleteLink.remove(((AlgaPort)port).getFlow());
                            } else {
                                if (!sheet.isVisible()) {
                                    selectIndirectInvisible = true;
                                }
                                added = true;
                                this._links.add(link);
                            }
                        }
                        if (!added && (port = link.getToGraphic()) instanceof AlgaPort && mapForDeleteLink.containsKey(((AlgaPort)port).getFlow())) {
                            if (graph.isLocked()) {
                                selectIndirectLocked = true;
                                mapForDeleteLink.remove(((AlgaPort)port).getFlow());
                            } else {
                                if (!sheet.isVisible()) {
                                    selectIndirectInvisible = true;
                                }
                                added = true;
                                this._links.add(link);
                            }
                        }
                    }
                    if (!(graph instanceof AlgaPort) || !changeLocation) continue;
                    AlgaPort port = (AlgaPort)graph;
                    mapForLocation.put(port.getFlow(), port);
                }
            }
            boolean withDifferentTypes = false;
            for (AltaFlowPanel.PortModifier port : mapForDeleteLink.values()) {
                AltaFlow flow = port.getPort();
                AltaType newType = port.getType();
                for (AltaLink link : this.getNode().getLinks()) {
                    AltaType typeToCheck = null;
                    if (link.getFromFlow() == flow) {
                        typeToCheck = !(newType instanceof DBRecord) && link.getFromFlow().getType() instanceof DBRecord ? link.getFromFlow().getType() : (link.getToFlow() == null ? null : link.getToFlow().getType());
                    } else if (link.getToFlow() == flow) {
                        if (!(newType instanceof DBRecord) && link.getToFlow().getType() instanceof DBRecord) {
                            typeToCheck = link.getToFlow().getType();
                        } else {
                            AltaType altaType = typeToCheck = link.getFromFlow() == null ? null : link.getFromFlow().getType();
                        }
                    }
                    if (typeToCheck == null || !link.verify() || typeToCheck.equivalents(newType)) continue;
                    withDifferentTypes = true;
                    break;
                }
                if (!withDifferentTypes) continue;
                break;
            }
            StringBuilder sb = new StringBuilder();
            if (withDifferentTypes) {
                if (sb.length() > 0) {
                    sb.append("<BR>");
                }
                sb.append(ResMsgOcas.getString("MSG_ERR_DELETE_PORT_INCLUDE_LINK"));
            }
            if (selectIndirectLocked) {
                if (sb.length() > 0) {
                    sb.append("<BR>");
                }
                sb.append(ResMsgOcas.getString("MSG_ERR_DELETE_PORT_LOCKED_INDIRECT"));
            }
            if (selectIndirectInvisible) {
                if (sb.length() > 0) {
                    sb.append("<BR>");
                }
                sb.append(ResMsgOcas.getString("MSG_ERR_DELETE_LINK_INVISIBLE"));
            }
            if (sb.length() > 0) {
                sb.insert(0, "<html>");
                if (mapForDeleteLink.isEmpty()) {
                    sb.append("</html>");
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getPanel()), sb.toString(), UIManager.getString("OptionPane.titleText"), 0);
                    return false;
                }
                sb.append("<BR>");
                sb.append(ResMsgOcas.getString("MSG_QST_DELETE_CONFIRM"));
                sb.append("</html>");
                int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this.getPanel()), sb.toString(), UIManager.getString("OptionPane.titleText"), 0);
                if (result != 0) {
                    return false;
                }
            }
        }
        ArrayList<AltaFlowPanel.PortModifier> filterRedoPorts = new ArrayList<AltaFlowPanel.PortModifier>(this._redoPorts.size());
        for (int i = 0; i < this._redoPorts.size(); ++i) {
            AltaFlowPanel.PortModifier port = this._redoPorts.get(i);
            if (port.getOrientation() != null) {
                if (port.getOrientation() == AltaFlow.Orientation.LOCAL) {
                    if (!this._deletePortsCmd.willBeDeleted(this.getNode().getGraphic(port.getPort()))) continue;
                    filterRedoPorts.add(port);
                    continue;
                }
                if (!mapForDeleteLink.containsKey(port.getPort())) continue;
                filterRedoPorts.add(port);
                continue;
            }
            if (port.getType() != null) {
                if (!mapForDeleteLink.containsKey(port.getPort())) continue;
                filterRedoPorts.add(port);
                continue;
            }
            filterRedoPorts.add(port);
        }
        this._redoPorts = filterRedoPorts;
        if (changeLocation) {
            for (int i = 0; i < this._redoPorts.size(); ++i) {
                AltaFlow log;
                AlgaPort grf;
                AltaFlowPanel.PortModifier port = this._redoPorts.get(i);
                Point pt = port.getLocation();
                if (pt == null || (grf = (AlgaPort)mapForLocation.get(log = port.getPort())) == null || !grf.isAutomaticPosition() || grf.isLocked()) continue;
                AlgaPort save = new AlgaPort().setFlow(log);
                this._node.computeAutomaticPosition(save, pt.x, pt.y);
                this._modifyLocationPorts.put(grf, save);
            }
        }
        this._undoPorts = new ArrayList<AltaFlowPanel.PortModifier>(this._redoPorts.size());
        for (int i = 0; i < this._redoPorts.size(); ++i) {
            AltaFlowPanel.PortModifier redo = this._redoPorts.get(i);
            AltaFlow flow = redo.getPort();
            AltaFlowPanel.PortModifier undo = new AltaFlowPanel.PortModifier(flow);
            if (redo.getLocation() != null) {
                undo.setLocation(new Point(flow.getX(), flow.getY()));
            }
            if (redo.getName() != null) {
                undo.setName(flow.getName());
            }
            if (redo.getType() != null) {
                undo.setType(flow.getType());
            }
            if (redo.getOrientation() != null) {
                undo.setOrientation(flow.getOrientation());
            }
            this._undoPorts.add(undo);
        }
        return true;
    }

    @Override
    protected void firstDo() {
        if (!this._redoPorts.isEmpty()) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    protected void modifyPorts(List<AltaFlowPanel.PortModifier> ports) {
        for (int i = 0; i < ports.size(); ++i) {
            AltaFlowPanel.PortModifier modif = ports.get(i);
            AltaFlow flow = modif.getPort();
            if (modif.getName() != null) {
                flow.setName(modif.getName());
            }
            if (modif.getType() != null) {
                flow.setType(modif.getType().getCopy());
            }
            if (modif.getLocation() != null) {
                flow.setLocation(modif.getLocation());
            }
            if (modif.getOrientation() != null) {
                flow.setOrientation(modif.getOrientation());
            }
            List<AlgaSheet> sheets = this.getContent().getSheets();
            for (int j = sheets.size() - 1; j >= 0; --j) {
                AlgaSheet sheet = sheets.get(j);
                for (AlgaGraph graph : sheet.getGraphs()) {
                    AltaLink log;
                    if (!(graph instanceof AlgaLink) || (log = ((AlgaLink)graph).getLogical()).getFromFlow() != flow && log.getToFlow() != flow) continue;
                    graph.computeControlPoints();
                }
            }
        }
    }

    protected void doChangeLocation() {
        if (this._modifyLocationPorts.isEmpty()) {
            return;
        }
        for (Map.Entry<AlgaPort, AlgaPort> entryPort : this._modifyLocationPorts.entrySet()) {
            AlgaPort curr = entryPort.getKey();
            AlgaPort save = entryPort.getValue();
            int cx = curr.getCX();
            int cy = curr.getCY();
            AlgaTransform trsf = curr.getTransform();
            curr.setCX(save.getCX()).setCY(save.getCY()).setTransform(save.getTransform());
            save.setCX(cx).setCY(cy).setTransform(trsf);
            curr.computeControlPoints();
        }
    }

    private void refresh() {
        this._flowPanel.refreshTable();
        this.getNode().updateLinksLogs(this.getAppl().getDBUser().getLogin(), this._links);
        this.refreshAll();
    }

    @Override
    public void redo() {
        if (this._insertPorts != null) {
            for (AlgaPort algaPort : this._insertPorts) {
                this.getNode().addPort(algaPort);
                this._insertPortsSheet.add(algaPort, Integer.MAX_VALUE);
            }
        }
        if (this._deletePortsCmd != null) {
            this._deletePortsCmd.redo();
        }
        this.doChangeLocation();
        this.modifyPorts(this._redoPorts);
        this.refresh();
    }

    @Override
    public void undo() {
        if (this._deletePortsCmd != null) {
            this._deletePortsCmd.undo();
        }
        if (this._insertPorts != null) {
            for (AlgaPort algaPort : this._insertPorts) {
                this._insertPortsSheet.remove(algaPort);
                this.getNode().deletePort(algaPort.getFlow());
            }
        }
        this.modifyPorts(this._undoPorts);
        this.doChangeLocation();
        this.refresh();
    }
}

