/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import java.util.ArrayList;
import java.util.List;

public class OCmdMove
extends OCCmd {
    List<AlgaGraph> _graphs;
    List<AlgaGraph> _links;
    List<AlgaPort> _ports;
    int _deltaX;
    int _deltaY;
    protected static final int FLAG_MOVE = 2;

    public OCmdMove(AltaContentEditPanel c, int deltaX, int deltaY) {
        super(c.getAppl(), c);
        this._deltaX = deltaX;
        this._deltaY = deltaY;
        this._graphs = new ArrayList<AlgaGraph>(32);
        this._links = new ArrayList<AlgaGraph>(32);
        this._ports = new ArrayList<AlgaPort>(8);
    }

    @Override
    protected void firstDo() {
        AlgaSheet sheet;
        int i;
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (i = sheets.size() - 1; i >= 0; --i) {
            sheet = sheets.get(i);
            for (AlgaGraph graph : sheet.getGraphs()) {
                graph.setFlag(0);
            }
        }
        for (i = sheets.size() - 1; i >= 0; --i) {
            sheet = sheets.get(i);
            for (AlgaGraph grf : sheet.getGraphs()) {
                if (!grf.isSelected() || grf.isLocked() || grf instanceof AlgaLink) continue;
                grf.setFlag(2);
                this._graphs.add(grf);
                if (!(grf instanceof AlgaPort) || !((AlgaPort)grf).isAutomaticPosition()) continue;
                this._ports.add((AlgaPort)grf);
            }
        }
        for (i = sheets.size() - 1; i >= 0; --i) {
            sheet = sheets.get(i);
            for (AlgaGraph grf : sheet.getGraphs()) {
                boolean tgtMove;
                if (!(grf instanceof AlgaLink)) continue;
                AlgaWithPorts src = ((AlgaLink)grf).getLogical().getFromGraphic();
                AlgaWithPorts tgt = ((AlgaLink)grf).getLogical().getToGraphic();
                if (src == null || tgt == null) continue;
                boolean srcMove = (src.getFlag() & 2) != 0;
                boolean bl = tgtMove = (tgt.getFlag() & 2) != 0;
                if (grf.isSelected() && !grf.isLocked() && srcMove && tgtMove) {
                    grf.setFlag(2);
                    this._graphs.add(grf);
                    continue;
                }
                if (!srcMove && !tgtMove) continue;
                this._links.add(grf);
            }
        }
        if (this._graphs.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    public void redo() {
        this.makeDo(this._deltaX, this._deltaY);
    }

    @Override
    public void undo() {
        this.makeDo(-this._deltaX, -this._deltaY);
    }

    private void makeDo(int deltaX, int deltaY) {
        int i;
        for (i = this._ports.size() - 1; i >= 0; --i) {
            AlgaPort port;
            port.setAutomaticPosition(!(port = this._ports.get(i)).isAutomaticPosition());
        }
        for (i = this._graphs.size() - 1; i >= 0; --i) {
            this._graphs.get(i).translate(deltaX, deltaY);
        }
        for (i = this._graphs.size() - 1; i >= 0; --i) {
            this._graphs.get(i).computeControlPoints();
        }
        for (i = this._links.size() - 1; i >= 0; --i) {
            this._links.get(i).computeControlPoints();
        }
        this.getNode().setModified(true);
        this.getPanel().refreshScroll(false);
        this.getPanel().doRefreshActions();
    }
}

