/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaClipboard;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaClipboardTransferable;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.lib.util.CopyUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class OCmdPaste
extends OCCmd {
    private static Logger _LOG = Logger.getLogger(OCmdPaste.class.getPackage().getName());
    ArrayList<AltaSub> _lstSub;
    List<AltaLink> _lstLink;
    Map<AlgaSheet, ArrayList<AlgaGraph>> _mapGraph;

    public OCmdPaste(CeciliaAppl appl, AltaContentEditPanel c) {
        super(appl, c);
    }

    @Override
    protected boolean prepareDo() {
        Transferable transferable = this.getAppl().getLocalClipboard(false).getContents(this);
        if (transferable == null) {
            return false;
        }
        if (!transferable.isDataFlavorSupported(AltaClipboardTransferable.DB_FLAVOR)) {
            return false;
        }
        AltaClipboard altaClipboard = null;
        try {
            altaClipboard = (AltaClipboard)transferable.getTransferData(AltaClipboardTransferable.DB_FLAVOR);
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Probleme avec le presse-papier", e);
            return false;
        }
        int nbrSubAdd = 0;
        CopyUtility.Default util = new CopyUtility.Default();
        HashSet addedNames = new HashSet();
        ArrayList<AltaSub> willRenameSubs = new ArrayList<AltaSub>();
        this._lstSub = new ArrayList(altaClipboard.getSubs().size());
        for (AltaSub sub : altaClipboard.getSubs()) {
            if (!util.selectForCopy((Object)sub)) continue;
            AltaSub cpy = sub.getCopy((CopyUtility)util);
            util.setRef((Object)sub, (Object)cpy);
            this._lstSub.add(cpy);
            ++nbrSubAdd;
            String name = cpy.getName();
            if (this.getNode().getSub(name) == null) {
                addedNames.add(name);
                continue;
            }
            willRenameSubs.add(cpy);
        }
        block3: for (AltaSub sub : willRenameSubs) {
            String originName = sub.getName();
            int length = -1;
            while ((length = originName.length()) > 0 && Character.isDigit(originName.charAt(length - 1))) {
                originName = originName.substring(0, length - 1);
            }
            if (originName.isEmpty()) {
                originName = sub.getName();
            }
            String separator = "";
            PluginWithOptions opts = this.getAppl().getPreferencies().getOptions(AltaContentDisplayPreferencies.PREF_KEY);
            if (opts != null && opts instanceof AltaContentDisplayPreferencies) {
                AltaContentDisplayPreferencies pref = (AltaContentDisplayPreferencies)opts;
                separator = pref.getSeparator();
            }
            if (originName.endsWith(separator)) {
                originName = originName.substring(0, originName.length() - separator.length());
            }
            int i = 1;
            while (true) {
                String currentName = originName + separator + i;
                if (this.getNode().getSub(currentName) == null && !addedNames.contains(currentName)) {
                    sub.setName(currentName);
                    addedNames.add(currentName);
                    continue block3;
                }
                ++i;
            }
        }
        this._lstLink = new ArrayList<AltaLink>(altaClipboard.getLinks().size());
        for (AltaLink link : altaClipboard.getLinks()) {
            if (!util.selectForCopy((Object)link)) continue;
            AltaLink cpy = link.getCopy((CopyUtility)util);
            util.setRef((Object)link, (Object)cpy);
            this._lstLink.add(cpy);
        }
        AlgaContent content = altaClipboard.getContent().getCopy(true, (CopyUtility)util);
        AlgaSheet currentSheet = this.getNode().getContent().getCurrentSheet();
        ArrayList<AlgaGraph> graphs = new ArrayList<AlgaGraph>();
        List<AlgaSheet> sheets = content.getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            graphs.addAll(sheet.getGraphs());
        }
        int delta = altaClipboard.getTranslate(this.getNode());
        for (AlgaGraph graph : graphs) {
            graph.translate(delta, delta);
            graph.setLocked(false);
        }
        for (AlgaGraph graph : graphs) {
            if (graph instanceof AlgaLink) continue;
            graph.computeControlPoints();
        }
        for (AlgaGraph graph : graphs) {
            if (!(graph instanceof AlgaLink)) continue;
            graph.computeControlPoints();
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && this.getNode().getSubs().size() + nbrSubAdd > DemoLimits.Limit.EQUIPMENT_SUBS.getLimit()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getPanel()), ResMsgOcas.getString("DEMO_EQUIPMENT_SUBS"), JOptionCecilia.getTopTitleOf(this.getPanel()), 0);
            return false;
        }
        this._mapGraph = new HashMap<AlgaSheet, ArrayList<AlgaGraph>>();
        this._mapGraph.put(currentSheet, graphs);
        return true;
    }

    @Override
    protected void firstDo() {
        this.redo();
        this.getPanel().addHisto(this);
    }

    @Override
    public void redo() {
        for (AltaSub altaSub : this._lstSub) {
            this.getNode().addSub(altaSub);
        }
        for (AltaLink altaLink : this._lstLink) {
            this.getNode().addLink(altaLink);
        }
        Rectangle rectToVisible = null;
        this.getContent().changeSelectGraphs(null, false);
        for (Map.Entry<AlgaSheet, ArrayList<AlgaGraph>> entry : this._mapGraph.entrySet()) {
            AlgaSheet sheet = entry.getKey();
            for (AlgaGraph grf : entry.getValue()) {
                sheet.add(grf, Integer.MAX_VALUE);
                grf.setSelected(true);
                if (rectToVisible == null) {
                    rectToVisible = grf.getSelectBounds();
                    continue;
                }
                rectToVisible = rectToVisible.union(grf.getSelectBounds());
            }
        }
        this.getPanel().refreshScroll(false);
        if (rectToVisible != null) {
            Rectangle rectZoomIncluded;
            double d = this.getView().getZoom();
            rectToVisible = rectZoomIncluded = new Rectangle((int)Math.round(rectToVisible.getX() * d), (int)Math.round(rectToVisible.getY() * d), (int)Math.round(rectToVisible.getWidth() * d), (int)Math.round(rectToVisible.getHeight() * d));
            this.getView().scrollRectToVisible(rectToVisible);
        }
        this.refreshAll();
        if (!this._lstSub.isEmpty()) {
            this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
            this.getNode().setChangeInternalStructure(true);
        }
    }

    @Override
    public void undo() {
        for (Map.Entry<AlgaSheet, ArrayList<AlgaGraph>> entry : this._mapGraph.entrySet()) {
            AlgaSheet sheet = entry.getKey();
            for (AlgaGraph grf : entry.getValue()) {
                sheet.remove(grf);
            }
        }
        for (AltaLink lnk : this._lstLink) {
            this.getNode().delLink(lnk);
        }
        for (AltaSub sub : this._lstSub) {
            this.getNode().delSub(sub);
        }
        this.getPanel().refreshScroll(false);
        this.refreshAll();
        if (!this._lstSub.isEmpty()) {
            this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
            this.getNode().setChangeInternalStructure(true);
        }
    }
}

