/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdFormMovePoint;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class DelegateMouseFormMoveHitPoint
implements AltaContentView.DelegateMouse {
    int _originX;
    int _originY;
    int _currentX;
    int _currentY;
    AlgaForm _source;
    int _hitPoint;

    public DelegateMouseFormMoveHitPoint(AlgaForm source, int hitPoint) {
        this._source = source;
        this._hitPoint = hitPoint;
    }

    @Override
    public boolean mousePressed(MouseEvent e, AltaContentView view) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return false;
        }
        this._originX = this._source.getX();
        this._originY = this._source.getY();
        switch (this._hitPoint) {
            case 0: {
                this._originX += this._source.getWUser() + 3;
                this._originY += this._source.getHUser() + 3;
                break;
            }
            case 1: {
                this._originX -= 3;
                this._originY += this._source.getHUser() + 3;
                break;
            }
            case 3: {
                this._originX += this._source.getWUser() + 3;
                this._originY -= 3;
                break;
            }
            case 2: {
                this._originX -= 3;
                this._originY -= 3;
            }
        }
        double zoom = view.getZoom();
        this._originX = (int)((double)this._originX * zoom);
        this._originY = (int)((double)this._originY * zoom);
        this._currentX = this.computeLimitX(e.getX());
        this._currentY = this.computeLimitY(e.getY());
        this.drawGhost(view.getGraphics());
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent e, AltaContentView view) {
        Graphics g = view.getGraphics();
        this.drawGhost(g);
        this._currentX = this.computeLimitX(e.getX());
        this._currentY = this.computeLimitY(e.getY());
        this.drawGhost(g);
    }

    @Override
    public void mouseReleased(MouseEvent e, AltaContentView view) {
        this.drawGhost(view.getGraphics());
        this._currentX = this.computeLimitX(e.getX());
        this._currentY = this.computeLimitY(e.getY());
        double zoom = view.getZoom();
        OCmdFormMovePoint cmd = new OCmdFormMovePoint(((AltaContentEditView)view).getPanel(), this._source, (int)((double)this._currentX / zoom), (int)((double)this._currentY / zoom), this._hitPoint);
        cmd.realiseDo();
    }

    private int computeLimitX(int x) {
        switch (this._hitPoint) {
            case 0: 
            case 3: {
                if (x <= this._originX - 10) break;
                return this._originX - 10;
            }
            case 1: 
            case 2: {
                if (x >= this._originX + 10) break;
                return this._originX + 10;
            }
        }
        return x;
    }

    private int computeLimitY(int y) {
        switch (this._hitPoint) {
            case 0: 
            case 1: {
                if (y <= this._originY - 10) break;
                return this._originY - 10;
            }
            case 2: 
            case 3: {
                if (y >= this._originY + 10) break;
                return this._originY + 10;
            }
        }
        return y;
    }

    private void drawGhost(Graphics g) {
        g.setXORMode(Color.yellow);
        g.drawLine(this._originX, this._originY, this._originX, this._currentY);
        g.drawLine(this._originX, this._currentY, this._currentX, this._currentY);
        g.drawLine(this._currentX, this._currentY, this._currentX, this._originY);
        g.drawLine(this._currentX, this._originY, this._originX, this._originY);
    }
}

