/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse;

import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class DelegateMouseRect
implements AltaContentView.DelegateMouse {
    int _originX;
    int _originY;
    int _currentX;
    int _currentY;

    @Override
    public boolean mousePressed(MouseEvent e, AltaContentView view) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return false;
        }
        this._currentX = this._originX = e.getX();
        this._currentY = this._originY = e.getY();
        this.drawRect(view.getGraphics());
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent e, AltaContentView view) {
        this.drawRect(view.getGraphics());
        this._currentX = e.getX();
        this._currentY = e.getY();
        this.drawRect(view.getGraphics());
    }

    @Override
    public void mouseReleased(MouseEvent e, AltaContentView view) {
        this.drawRect(view.getGraphics());
        double zoom = view.getZoom();
        Rectangle rect = new Rectangle((int)Math.ceil((double)Math.min(this._originX, this._currentX) / zoom), (int)Math.ceil((double)Math.min(this._originY, this._currentY) / zoom), (int)Math.floor((double)Math.abs(this._originX - this._currentX) / zoom), (int)Math.floor((double)Math.abs(this._originY - this._currentY) / zoom));
        view.getContent().changeSelectGraphs(rect, e.isShiftDown());
        view.repaint();
        view.fireChangeSelect();
    }

    private void drawRect(Graphics g) {
        g.setXORMode(Color.yellow);
        g.drawLine(this._originX, this._originY, this._originX, this._currentY);
        g.drawLine(this._originX, this._currentY, this._currentX, this._currentY);
        g.drawLine(this._currentX, this._currentY, this._currentX, this._originY);
        g.drawLine(this._currentX, this._originY, this._originX, this._originY);
    }
}

