/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse;

import com.dassault.cecilia.core.cecilia.action.CArrayCmd;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdPathMovePoint;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MoveGrfUtility {
    int _topleftX;
    int _bottomrightX;
    int _topleftY;
    int _bottomrightY;
    List<Shape> _shapes;
    List<AlgaLink> _links;
    List<List<Pt>> _points;
    boolean _logicalCoord;

    public boolean prepare(AltaContentView view, boolean withPoints, boolean logicalCoord) {
        double zoom;
        this._logicalCoord = logicalCoord;
        this._shapes = new ArrayList<Shape>();
        this._links = new ArrayList<AlgaLink>();
        this._points = new ArrayList<List<Pt>>();
        List<AlgaSheet> sheets = view.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (sheet.isVisible()) continue;
            for (AlgaGraph grf : sheet.getGraphs()) {
                if (!grf.isSelected()) continue;
                grf.setSelected(false);
            }
        }
        Graphics g = view.getGraphics();
        Rectangle encloseRect = null;
        Rectangle enclosePoints = null;
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph grf : sheet.getGraphs()) {
                if (!grf.isSelected() || grf.isLocked()) continue;
                if (grf instanceof AlgaLink) {
                    AlgaWithPorts tgt;
                    AlgaWithPorts src;
                    if (withPoints) {
                        AlgaLink link = (AlgaLink)grf;
                        ArrayList<Pt> selectedPoints = null;
                        Iterator<Pt> iterPt = link.iteratePoint();
                        iterPt.next();
                        while (iterPt.hasNext()) {
                            Pt next = iterPt.next();
                            if (!iterPt.hasNext()) break;
                            if (!next.isSelected()) continue;
                            if (selectedPoints == null) {
                                selectedPoints = new ArrayList<Pt>(3);
                            }
                            selectedPoints.add(next);
                            Rectangle rectPt = new Rectangle(next.getX() - 3, next.getY() - 3, 6, 6);
                            if (enclosePoints == null) {
                                enclosePoints = rectPt;
                                continue;
                            }
                            enclosePoints = enclosePoints.union(rectPt);
                        }
                        if (selectedPoints != null) {
                            this._links.add(link);
                            this._points.add(selectedPoints);
                        }
                    }
                    if ((src = ((AlgaLink)grf).getLogical().getFromGraphic()) == null || src.isLocked() || !src.isSelected() || (tgt = ((AlgaLink)grf).getLogical().getToGraphic()) == null || tgt.isLocked() || !tgt.isSelected()) continue;
                }
                encloseRect = encloseRect == null ? new Rectangle(grf.getBounds(g)) : encloseRect.union(grf.getBounds(g));
                this._shapes.add(grf.getSelectShape());
            }
        }
        if (this._shapes.isEmpty() && this._links.isEmpty()) {
            return false;
        }
        double d = zoom = this._logicalCoord ? 1.0 : view.getZoom();
        if (this._shapes.isEmpty()) {
            this._topleftX = (int)((double)enclosePoints.x * zoom);
            this._topleftY = (int)((double)enclosePoints.y * zoom);
            this._bottomrightX = this._topleftX + (int)((double)enclosePoints.width * zoom);
            this._bottomrightY = this._topleftY + (int)((double)enclosePoints.height * zoom);
        } else {
            this._topleftX = (int)((double)encloseRect.x * zoom);
            this._topleftY = (int)((double)encloseRect.y * zoom);
            this._bottomrightX = this._topleftX + (int)((double)encloseRect.width * zoom);
            this._bottomrightY = this._topleftY + (int)((double)encloseRect.height * zoom);
        }
        return true;
    }

    public void drawRect(int deltaX, int deltaY, Graphics2D g, double zoom) {
        block9: {
            if (this._topleftX + deltaX < 0) {
                deltaX = -this._topleftX;
            }
            if (this._topleftY + deltaY < 0) {
                deltaY = -this._topleftY;
            }
            if (deltaX == 0 && deltaY == 0) break block9;
            g.setXORMode(Color.yellow);
            if (this._logicalCoord) {
                g.translate((double)deltaX * zoom, (double)deltaY * zoom);
            } else {
                g.translate(deltaX, deltaY);
            }
            g.scale(zoom, zoom);
            if (this._shapes.isEmpty()) {
                for (int i = this._points.size() - 1; i >= 0; --i) {
                    ArrayList ipts = (ArrayList)this._points.get(i);
                    for (int j = ipts.size() - 1; j >= 0; --j) {
                        Pt pt = (Pt)ipts.get(j);
                        g.fillRect(pt.getX() - 3, pt.getY() - 3, 6, 6);
                    }
                }
            } else {
                for (int i = this._shapes.size() - 1; i >= 0; --i) {
                    g.draw(this._shapes.get(i));
                }
            }
        }
    }

    public int adjustX(int deltaX) {
        if (this._topleftX + deltaX < 0) {
            deltaX = -this._topleftX;
        }
        return deltaX;
    }

    public int adjustY(int deltaY) {
        if (this._topleftY + deltaY < 0) {
            deltaY = -this._topleftY;
        }
        return deltaY;
    }

    public boolean moveShape() {
        return !this._shapes.isEmpty();
    }

    public void prepareMoveHitPoint(CArrayCmd commands, AltaContentEditPanel panel, int deltaX, int deltaY) {
        deltaX = this.adjustX(deltaX);
        deltaY = this.adjustX(deltaY);
        for (int i = this._links.size() - 1; i >= 0; --i) {
            AlgaLink link = this._links.get(i);
            OCmdPathMovePoint lCmd = new OCmdPathMovePoint(panel, link);
            for (Pt pt : this._points.get(i)) {
                lCmd.addMoveDeltaPoint((double)deltaX, (double)deltaY, pt);
            }
            commands.addCmd(lCmd);
        }
    }
}

