/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ImageDefinition;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.freehep.graphicsio.emf.EMFGraphics2D;

public class ExpAlgaContent
extends ExpSection {
    private static Logger _LOG = Logger.getLogger(ExpAlgaContent.class.getPackage().getName());
    AltaEquipment _node;

    public ExpAlgaContent(AltaEquipment item) {
        this._node = item;
    }

    @Override
    public String getTitle() {
        return ResMsgVoc.getString("VOC_DESCRIPTION");
    }

    @Override
    protected void writeContentDocbook(DBKOutput output) throws IOException {
        ExpBook expBook = this.getBook();
        if (expBook == null) {
            _LOG.severe("Don't find root book for exportation");
            return;
        }
        PageFormat format = expBook.getPageFormat();
        int ws = (int)(format.getImageableWidth() * 1.2);
        int hs = (int)(format.getImageableHeight() * 1.2);
        this.prepareContent(this._node.getContent(), ws, hs);
        int[] optimDim = this.optimDimension(ws, hs);
        ws = optimDim[0];
        hs = optimDim[1];
        File pathImg = expBook.getImagPath(output.getXmlOutputFile());
        Object nameFile = "Content_" + this._node.getAltaRicaName();
        nameFile = ((String)nameFile).replaceAll("[^A-Za-z0-9\\_\\-\\.]", "_");
        AlgaContext context = new AlgaContext();
        context.setPrinting(true);
        context.setLinkDisplay(AltaContentDisplayPreferencies.LinkDisplay.BG);
        ArrayList<ImageDefinition> imags = new ArrayList<ImageDefinition>();
        imags.add(this.exportEMF(this._node.getContent(), context, ws, hs, (String)nameFile, pathImg));
        imags.addAll(this.exportPNG(this._node.getContent(), context, ws, hs, (String)nameFile, pathImg));
        output.insertImage("", "", imags.toArray(new ImageDefinition[imags.size()]));
    }

    @Override
    protected void writeContentScribe(SrbInputStream scribe) throws IOException {
        ExpBook expBook = this.getBook();
        if (expBook == null) {
            _LOG.severe("Don't find root book for exportation");
            return;
        }
        PageFormat format = expBook.getPageFormat();
        int ws = (int)(format.getImageableWidth() * 1.2);
        int hs = (int)(format.getImageableHeight() * 1.2);
        this.prepareContent(this._node.getContent(), ws, hs);
        int[] optimDim = this.optimDimension(ws, hs);
        ws = optimDim[0];
        hs = optimDim[1];
        Object nameFile = "Content_" + this._node.getAltaRicaName();
        nameFile = ((String)nameFile).replaceAll("[^A-Za-z0-9\\_\\-\\.]", "_");
        AlgaContext context = new AlgaContext();
        context.setPrinting(true);
        context.setLinkDisplay(AltaContentDisplayPreferencies.LinkDisplay.BG);
        File tmpFile = File.createTempFile((String)nameFile, ".png");
        tmpFile.deleteOnExit();
        this.createPNG(this._node.getContent(), context, ws, hs, tmpFile);
        scribe.write("<IMG>\n");
        scribe.write("<NAME> PNG@" + tmpFile.getAbsolutePath() + "\n");
        scribe.write("<ROLE> HTML\n");
        scribe.write("<EIMG>\n");
    }

    private int[] optimDimension(int ws, int hs) {
        int newWs = ws;
        int newHs = hs;
        int wm = this._node.getContent().getWidth();
        int hm = this._node.getContent().getHeight();
        if (wm <= newWs) {
            if (hm <= newHs) {
                newWs = wm + 1;
                newHs = hm + 1;
            } else {
                newWs = (int)((double)wm / (double)hm * (double)newHs) + 1;
            }
        } else if (hm <= newHs) {
            newHs = (int)((double)hm / (double)wm * (double)newWs) + 1;
        } else if (newWs < newHs) {
            if (wm >= hm) {
                newHs = (int)((double)hm / (double)wm * (double)newWs) + 1;
            }
        } else if (wm < hm) {
            newWs = (int)((double)wm / (double)hm * (double)newHs) + 1;
        }
        return new int[]{newWs, newHs};
    }

    private void prepareContent(AlgaContent content, int ws, int hs) {
        BufferedImage imgi = new BufferedImage(ws / 3, hs / 3, 13);
        Graphics2D graphics = imgi.createGraphics();
        content.computeSize(graphics);
    }

    private ImageDefinition exportEMF(AlgaContent content, AlgaContext context, int ws, int hs, String nameFile, File pathImg) {
        try {
            File tmpFile = File.createTempFile(nameFile, ".emf", pathImg);
            EMFGraphics2D graphics = new EMFGraphics2D(tmpFile, new Dimension(ws, hs));
            graphics.startExport();
            this.printContent((Graphics2D)graphics, content, context, ws, hs);
            graphics.endExport();
            ImageDefinition imagDef = new ImageDefinition(pathImg.getName() + "/" + tmpFile.getName(), "EMF");
            imagDef.addAttribute("scale", "100");
            imagDef.addAttribute("width", Integer.toString(ws) + "px");
            imagDef.addAttribute("depth", Integer.toString(hs) + "px");
            return imagDef;
        }
        catch (Exception exc) {
            _LOG.log(Level.INFO, "Exception lors de la conversion EMF du contenu de " + this._node.getRefPath(), exc);
            exc.printStackTrace();
            return null;
        }
    }

    private Collection<ImageDefinition> exportPNG(AlgaContent content, AlgaContext context, int ws, int hs, String nameFile, File pathImg) {
        try {
            File tmpFile = File.createTempFile(nameFile, ".png", pathImg);
            this.createPNG(content, context, ws, hs, tmpFile);
            ArrayList<ImageDefinition> result = new ArrayList<ImageDefinition>(3);
            ImageDefinition imagDef = new ImageDefinition(pathImg.getName() + "/" + tmpFile.getName(), "PNG");
            imagDef.addAttribute("width", "100%");
            imagDef.addAttribute("scalefit", "1");
            imagDef.addAttribute("contentdepth", "100%");
            imagDef.setRole("fo");
            result.add(imagDef);
            imagDef = new ImageDefinition(pathImg.getName() + "/" + tmpFile.getName(), "PNG");
            imagDef.addAttribute("width", "800");
            imagDef.addAttribute("contentwidth", "800");
            imagDef.setRole("html");
            result.add(imagDef);
            return result;
        }
        catch (Exception exc) {
            _LOG.log(Level.INFO, "Exception lors de la conversion EMF du contenu de " + this._node.getRefPath(), exc);
            return null;
        }
    }

    private void createPNG(AlgaContent content, AlgaContext context, int ws, int hs, File tmpFile) throws IOException {
        BufferedImage imgi = null;
        int lscale = 3;
        int wsi = ws * lscale;
        int hsi = hs * lscale;
        imgi = new BufferedImage(wsi, hsi, 13);
        Graphics2D graphics = imgi.createGraphics();
        graphics.setClip(0, 0, wsi, hsi);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, wsi, hsi);
        this.printContent(graphics, content, context, wsi, hsi);
        imgi.flush();
        BufferedImage imgf = null;
        imgf = new BufferedImage(ws, hs, 13);
        Graphics2D graphics2 = imgf.createGraphics();
        graphics2.setClip(0, 0, ws, hs);
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, ws, hs);
        graphics2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2.drawImage(imgi, 0, 0, ws, hs, null);
        imgf.flush();
        ImageIO.write((RenderedImage)imgi, "png", tmpFile);
    }

    private void printContent(Graphics2D graphics, AlgaContent content, AlgaContext context, int ws, int hs) {
        double hBo;
        double marge = 10.0;
        double wPF = (double)ws - 2.0 * marge;
        double hPF = (double)hs - 2.0 * marge;
        double dPF = wPF / hPF;
        double wBo = content.getWidth();
        double dBo = wBo / (hBo = (double)content.getHeight());
        double coef = dBo >= dPF ? wPF / wBo : hPF / hBo;
        if (coef > 1.0 && (wPF < 1000.0 || hPF < 600.0)) {
            coef = 1.0;
        }
        double dx = (wPF - coef * wBo) / 2.0;
        double dy = (hPF - coef * hBo) / 2.0;
        _LOG.finest("AlgaContent::printContent(ws=" + ws + ",hs=" + hs + ",wp=" + wBo + ",hp=" + hBo + "):Coef=" + coef);
        graphics.translate(dx + marge, dy + marge);
        graphics.scale(coef, coef);
        content.paint(graphics, context);
    }
}

