/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class DBAltaDefaultHandlerXml
extends SAXWrapHandler
implements DBObjectXmlConstant {
    protected DBAltaDefaultHandlerXml(DBLogs.DBLogsManager manager, Locator locator) {
        super(manager, locator);
    }

    public String readAltaName(String key, Map<String, String> attrs) throws SAXException {
        String name = this.readName(key, "name", attrs);
        if (!DBFactory.verifyNameAltarica(name)) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "name", name), this.getLocator()));
        }
        return name;
    }

    public String readAltaPath(String key, Map<String, String> attrs) throws SAXException {
        String name = this.readName(key, "name", attrs);
        name = name.trim();
        boolean error = false;
        if (name.startsWith(".") || name.endsWith(".")) {
            error = true;
        }
        if (!error) {
            StringTokenizer st = new StringTokenizer(name, ".");
            while (st.hasMoreTokens() && !error) {
                String element = st.nextToken();
                if (DBFactory.verifyNameAltarica(element)) continue;
                error = true;
            }
        }
        if (error) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "name", name), this.getLocator()));
        }
        return name;
    }
}

