/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaTypeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class DBAltaNodeHandlerXml
extends DBAltaTypeHandlerXml {
    private static Logger _LOG = Logger.getLogger(DBAltaNodeHandlerXml.class.getPackage().getName());
    public static final String ATT_WIDTH = "width";
    public static final String ATT_HEIGHT = "height";
    public static final String ATT_TEXT_POSITION = "text.position";
    public static final String ELT_ALTA_EVENT = "alta.event";
    public static final String ELT_ALTA_STATE = "alta.state";
    public static final String ELT_ALTA_FLOW = "alta.flow";
    public static final String ATT_ORIENTATION = "orientation";
    public static final String ATT_X = "x";
    public static final String ATT_Y = "y";
    public static final String ELT_ALTA_OPERATOR = "alta.operator.ref";
    public static final String ELT_ALTA_CODE = "alta.code";

    protected DBAltaNodeHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory cecFactory) {
        super(manager, locator, cecFactory);
    }

    protected AltaOperatorRef readOperatorRef(String key, Map<String, String> attrs) throws SAXException {
        String name = this.readAltaName(key, attrs);
        DBFolder dbOper = this.readDBFolder(key, attrs, this._cecFactory.createFolderDAO(), "OPERATOR_FAMILIES", false);
        if (dbOper != null) {
            if (dbOper.getFamily() != DBFolder.Family.OPERATOR) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbOper.getRefPath(), DBFolder.Family.OPERATOR}), this.getLocator()));
            } else if (!dbOper.isVersion()) {
                _LOG.warning("Le dossier reference pour l'operateur n'est pas une version : " + dbOper.getRefPath());
            } else {
                return new AltaOperatorRef(name, dbOper);
            }
        }
        return new AltaOperatorRef(name, null);
    }

    protected AltaFlow readFlow(String key, Map<String, String> attrs) throws SAXException {
        String name = this.readAltaName(key, attrs);
        AltaType type = this.readType(key, attrs);
        AltaFlow result = new AltaFlow(name, type);
        String attr = attrs.get(ATT_ORIENTATION);
        if (attr != null && !attr.isEmpty()) {
            AltaFlow.Orientation orientation = (AltaFlow.Orientation)DBAltaNodeHandlerXml.valueOfEnum(AltaFlow.Orientation.class, (String)attr.toUpperCase());
            if (orientation == null) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, ATT_ORIENTATION, attr), this.getLocator()));
                orientation = AltaFlow.Orientation.IN;
            } else {
                result.setOrientation(orientation);
            }
        }
        if ((attr = attrs.get(ATT_X)) != null && !attr.isEmpty()) {
            int x = -1;
            try {
                x = Integer.parseInt(attr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (x < 0) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, ATT_X, attr), this.getLocator()));
                x = 0;
            } else {
                result.setX(x);
            }
        }
        if ((attr = attrs.get(ATT_Y)) != null && !attr.isEmpty()) {
            int y = -1;
            try {
                y = Integer.parseInt(attr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (y < 0) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, ATT_Y, attr), this.getLocator()));
                y = 0;
            } else {
                result.setY(y);
            }
        }
        long id = -1L;
        String attr2 = attrs.get("id");
        if (attr2 != null && !attr2.isEmpty()) {
            id = -2L;
            try {
                id = Long.parseLong(attr2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (id < -1L) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "id", attr2), this.getLocator()));
            }
        }
        if (id >= 0L) {
            result.setID(id);
        }
        return result;
    }

    protected AltaState readState(String key, Map<String, String> attrs) throws SAXException {
        String name = this.readAltaName(key, attrs);
        AltaType type = this.readType(key, attrs);
        String value = attrs.get("value");
        if (value == null || value.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "value"), this.getLocator()));
        }
        AltaState result = new AltaState(name, type, value);
        return result;
    }
}

