/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.io;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.io.AltaFileHeader;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBObjectReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.io.ocas51.CoreUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class DBNodeReaderRaw
extends DBObjectReaderRaw {
    Map<String, AltaOperatorRef> _mapOperators = new LinkedHashMap<String, AltaOperatorRef>();
    protected String _code;
    private DBFolder _dbRootOperators = null;

    public DBNodeReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        super(dbFolder, logMng);
    }

    public abstract AltaFileHeader getProperties();

    public abstract Collection<AltaFlow> getFlows();

    public Collection<AltaOperatorRef> getOperators() {
        return this._mapOperators.values();
    }

    public String getCode() {
        return this._code;
    }

    protected void readLaw(BufferedReader inData, String line) throws IOException {
        this._code = this.readText(inData, line, "</law>");
    }

    protected void readOperatorId(String line, CECFactory cecFactory) {
        DBFolder dbOperator;
        String field;
        String name = "";
        String family = "";
        String subfamily = "";
        String version = "";
        int position = line.indexOf("name=");
        if (position != -1) {
            field = line.substring(position);
            name = CoreUtil.searchString(field);
        }
        if ((position = line.indexOf("family=")) != -1) {
            field = line.substring(position);
            family = CoreUtil.searchString(field);
        }
        if ((position = line.indexOf("subfamily=")) != -1) {
            field = line.substring(position);
            subfamily = CoreUtil.searchString(field);
        }
        if ((position = line.indexOf("version=")) != -1) {
            field = line.substring(position);
            version = CoreUtil.searchString(field);
        }
        if (subfamily.isEmpty()) {
            subfamily = family;
        }
        StringBuilder pathOp = new StringBuilder(family.length() + subfamily.length() + name.length() + version.length() + 16);
        pathOp.append(family).append("/").append(subfamily).append("/");
        pathOp.append(name).append(";").append(version);
        DAOFolder daoFolder = cecFactory.createFolderDAO();
        if (this._dbRootOperators == null) {
            this._dbRootOperators = daoFolder.getRootID("OPERATOR_FAMILIES");
        }
        if ((dbOperator = daoFolder.findFolder(this._dbRootOperators, pathOp.toString(), false)) == null) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_OPERATOR_UNKNOWN", pathOp.toString()));
        } else if (this._mapOperators.containsKey(name)) {
            this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_OPERATOR_ALREADY", name));
        } else {
            AltaOperatorRef operator = new AltaOperatorRef(name, dbOperator);
            this._mapOperators.put(name, operator);
        }
    }
}

