/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.operator;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.mbsa.node.gui.FctOperatorFinder;
import com.dassault.cecilia.lib.mbsa.translator.parser.OcasLexer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OperatorDictionary
implements FctOperatorFinder,
DAOFolder.UpdateListener {
    private static Logger _LOG = Logger.getLogger(OperatorDictionary.class.getPackage().getName());
    Map<String, Set<DBFolder>> _mapDictionary = new HashMap<String, Set<DBFolder>>();
    Map<DBFolder, String> _mapOldNames = new HashMap<DBFolder, String>();
    DBFolder.Family _dbFamily;
    private static Comparator<DBFolder> __COMPARATOR = new Comparator<DBFolder>(){

        @Override
        public int compare(DBFolder o1, DBFolder o2) {
            return o1.getRefPath().compareTo(o2.getRefPath());
        }
    };

    private void insertIntoDictionary(String name, DBFolder dbFolder) {
        Set<DBFolder> dbSet = this._mapDictionary.get(name);
        if (dbSet == null) {
            dbSet = new HashSet<DBFolder>();
            this._mapDictionary.put(name, dbSet);
        }
        dbSet.add(dbFolder);
        this._mapOldNames.put(dbFolder, name);
    }

    private void removeIntoDictionary(String name, DBFolder dbFolder) {
        Set<DBFolder> dbSet = this._mapDictionary.get(name);
        if (dbSet == null || !dbSet.remove(dbFolder)) {
            _LOG.severe("Suppression d'un folder inconnu dans le dictionnaire : " + dbFolder.getRefPath());
        }
        this._mapOldNames.remove(dbFolder);
    }

    private void travelTree(DBFolder dbFolder, DAOFolder daoFolder) {
        if (dbFolder.isModel()) {
            String name = dbFolder.getName();
            this.insertIntoDictionary(name, dbFolder);
        } else {
            List<DBFolder> dbChildren = dbFolder.getChildren();
            if (dbChildren == null) {
                dbChildren = daoFolder.findChildren(dbFolder);
            }
            for (int i = 0; i < dbChildren.size(); ++i) {
                this.travelTree(dbChildren.get(i), daoFolder);
            }
        }
    }

    public void constructFrom(DBFolder dbRoot, DAOFolder daoFolder) {
        this._mapDictionary.clear();
        this._mapOldNames.clear();
        this._dbFamily = dbRoot.getFamily();
        this.travelTree(dbRoot, daoFolder);
        _LOG.fine("Dictionary-" + this._dbFamily.name().toLowerCase() + ": size=" + this._mapDictionary.size() + " ; old=" + this._mapOldNames.size());
        if (_LOG.isLoggable(Level.FINEST)) {
            for (String key : new TreeSet<String>(this._mapDictionary.keySet())) {
                Set<DBFolder> dbSet = this._mapDictionary.get(key);
                StringBuilder sb = new StringBuilder();
                sb.append(key).append(" => ");
                for (DBFolder dbFolder : dbSet) {
                    if (sb.length() > key.length() + 4) {
                        sb.append(",");
                    }
                    dbFolder.getPathUntilSystem(sb);
                }
                _LOG.finest(sb.toString());
                _LOG.finer(key + ": size=" + dbSet.size());
            }
        }
    }

    @Override
    public boolean isKnowOperator(String name) {
        Set<DBFolder> dbSet = this._mapDictionary.get(name);
        if (dbSet == null) {
            return false;
        }
        return !dbSet.isEmpty();
    }

    public Set<DBFolder> getOperatorsWithName(String name) {
        Set<DBFolder> result = this._mapDictionary.get(name);
        if (result == null || result.size() < 2) {
            return result;
        }
        TreeSet<DBFolder> sortResult = new TreeSet<DBFolder>(__COMPARATOR);
        sortResult.addAll(result);
        return sortResult;
    }

    @Override
    public void changeBegin() {
    }

    @Override
    public boolean changeState(DBFolder dbFolder) {
        if (dbFolder.getFamily() != this._dbFamily) {
            return false;
        }
        if (dbFolder.isVersion()) {
            return false;
        }
        if (dbFolder.isModel()) {
            String oldName = this._mapOldNames.get(dbFolder);
            if (oldName == null) {
                this.insertIntoDictionary(dbFolder.getName(), dbFolder);
            } else if (!oldName.equals(dbFolder.getName())) {
                this.removeIntoDictionary(oldName, dbFolder);
                this.insertIntoDictionary(dbFolder.getName(), dbFolder);
            }
        }
        return false;
    }

    @Override
    public void changeStateAndChildren(DBFolder dbFolder, List<DBFolder> oldChildren) {
        if (dbFolder.getFamily() != this._dbFamily) {
            return;
        }
    }

    @Override
    public void refreshAll() {
    }

    @Override
    public void changeEnd() {
    }

    public Set<String> findOperators(String text) {
        HashSet<String> result = new HashSet<String>();
        StringReader reader = new StringReader(text);
        OcasLexer lexer = new OcasLexer((Reader)reader, true, false);
        try {
            int prevToken = lexer.yylex();
            String prevText = "";
            while (prevToken > 0) {
                prevText = lexer.yytext();
                int curToken = lexer.yylex();
                if (prevToken == 1028 && curToken == 40 && this.isKnowOperator(prevText)) {
                    result.add(prevText);
                }
                prevToken = curToken;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

