/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.operator.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.folder.DBFolderThreadClose;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.ResIcoOcas;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgOperator;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaCodeFrame;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaPropertiesPanel;
import com.dassault.cecilia.dbobj.mbsa.node.gui.EditorInterface;
import com.dassault.cecilia.dbobj.mbsa.node.gui.HelperLabel;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.operator.gui.AltaOperandePanel;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AltaEditOperator
extends AltaCodeFrame
implements EditorInterface {
    JLabel _nameLabel;
    JTextField _name;
    AltaOperandePanel _operandePanel;
    AltaPropertiesPanel _propertiesPanel;

    public AltaEditOperator(CeciliaAppl appl, AltaOperator dbOperator) {
        super(dbOperator.getCopy(), appl);
        this.makePanel();
        this.editOperator(this.getAltaNode());
        this.setModified(false);
    }

    @Override
    protected AltaOperator getAltaNode() {
        return (AltaOperator)super.getAltaNode();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this._operandePanel != null && this._operandePanel.getLastFocusField() != null) {
            this._operandePanel.getLastFocusField().requestFocus();
        }
    }

    private void makePanel() {
        this._nameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME") + " : ");
        this._nameLabel.setForeground(Color.black);
        this._name = new JTextField("");
        this._operandePanel = new AltaOperandePanel(this.getAltaNode(), this.getApplication());
        this._operandePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgOcas.getString("OPERATOR_EDIT_OPERANDE")));
        ((TitledBorder)this._operandePanel.getBorder()).setTitleColor(Color.black);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this._nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        panel.add((Component)this._name, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 10), 0, 0));
        panel.add((Component)this._operandePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        this._tabPane.addTab(ResMsgVoc.getString("VOC_GENERAL"), panel);
        this._propertiesPanel = new AltaPropertiesPanel(this.getDBFolder());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_PROPERTIES"), this._propertiesPanel);
        this._tabPane.addTab(ResMsgOcas.getString("MODEL_EDIT_ALTARICA_CODE"), ResIcoOcas.getImageIcon("CODE_PI"), this.createAltaEditor());
        JPanel content = new JPanel(new BorderLayout());
        this.getContentPane().add(content);
        this._tabPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        content.add((Component)this._tabPane, "Center");
        content.add(this.createAndPlugLogsButtonAt(this.createCodeAndClosePanel()), "South");
        this.defineActions();
        this.setSize(650, 400);
    }

    @Override
    protected int getTabIndex(AltaCodeFrame.CodeTabType tabType) {
        switch (tabType) {
            case CODE: {
                return 2;
            }
            case GENERAL: {
                return 1;
            }
            case FLOW: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        super.changePreferencies(prefs);
        PluginWithOptions opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            this._propertiesPanel.setDateFormat(((GeneralTextPreferencies)opts).getDateFormat());
        }
    }

    @Override
    public String analyseString(String str, char car, Vector list) {
        String resultString = "";
        if (car == '_' || car == '^') {
            AltaType type = null;
            if (this.getAltaNode().getName().equals(str)) {
                type = this.getAltaNode().getType();
            } else {
                AltaFlow operande = this.getAltaNode().getFlow(str);
                if (operande != null) {
                    type = operande.getType();
                }
            }
            if (type != null && type instanceof DBRecord) {
                DBRecord dbRecord = (DBRecord)type;
                for (int i = dbRecord.getValueCount() - 1; i >= 0; --i) {
                    DBRecordField field = dbRecord.getFieldAt(i);
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(field.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FIELD"), field.getType()));
                }
                resultString = ((DBRecord)type).getRefPath();
            }
        }
        return resultString;
    }

    @Override
    public String getHelpRoots(Vector list) {
        UtilOcas.addInAlphabeticOrder(list, new HelperLabel(this.getAltaNode().getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_OUTPUT"), this.getAltaNode().getType()));
        for (AltaFlow operande : this.getAltaNode().getFlows()) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(operande.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_INPUT"), operande.getType()));
        }
        return this.getDBInfo();
    }

    private void defineActions() {
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AltaEditOperator.this._operandePanel.setLastFocusField((JTextField)e.getSource());
            }
        };
        this._name.addFocusListener(focusListener);
        this._codeEditor.getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.getModifiersEx() & 0x1000) != 0) {
                    String selection = AltaEditOperator.this._codeEditor.getEditorComponent().getSelectedText();
                    if (AltaEditOperator.this.getAltaNode() != null && selection != null) {
                        AltaFlow operande = AltaEditOperator.this.getAltaNode().getFlow(selection);
                        if (operande != null) {
                            Vector<String> values = new Vector<String>();
                            AltaType type = operande.getType();
                            for (int i = 0; i < type.getValueCount(); ++i) {
                                values.addElement(type.getValueAt(i));
                            }
                            if (!values.isEmpty()) {
                                JPopupMenu jPopup = new JPopupMenu();
                                JList<String> jList = new JList<String>();
                                jPopup.insert(new JScrollPane(jList), 0);
                                jList.setListData(values);
                                JOptionCecilia.showPopupMenu(jPopup, e.getPoint(), AltaEditOperator.this._codeEditor.getEditorComponent());
                            }
                        } else {
                            for (AltaFlow lOperande : AltaEditOperator.this.getAltaNode().getFlows()) {
                                DBRecord operandeType;
                                DBRecordField field;
                                if (selection.indexOf(lOperande.getName()) != 0 || !(lOperande.getType() instanceof DBRecord) || (field = (operandeType = (DBRecord)lOperande.getType()).fieldExist(selection.substring(lOperande.getName().length() + 1))) == null) continue;
                                Vector<String> values = new Vector<String>();
                                AltaType type = field.getType();
                                for (int i = 0; i < type.getValueCount(); ++i) {
                                    values.addElement(type.getValueAt(i));
                                }
                                if (values.isEmpty()) continue;
                                JPopupMenu jPopup = new JPopupMenu();
                                JList<String> jList = new JList<String>();
                                jPopup.insert(new JScrollPane(jList), 0);
                                jList.setListData(values);
                                JOptionCecilia.showPopupMenu(jPopup, e.getPoint(), AltaEditOperator.this._codeEditor.getEditorComponent());
                            }
                        }
                    }
                }
            }
        });
        this._tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AltaEditOperator.this._tabPane.getSelectedIndex() == AltaEditOperator.this._tabPane.indexOfTab(ResMsgOcas.getString("MODEL_EDIT_ALTARICA_CODE"))) {
                    AltaEditOperator.this._codeEditor.setHeader(AltaEditOperator.this.getAltaNode().getHeader(false, true));
                    AltaEditOperator.this._codeEditor.setBottom(AltaEditOperator.this.getAltaNode().getBottom(false));
                } else if (AltaEditOperator.this._tabPane.getSelectedIndex() == AltaEditOperator.this._tabPane.indexOfTab(ResMsgVoc.getString("VOC_GENERAL"))) {
                    AltaEditOperator.this._operandePanel.getLastFocusField().requestFocus();
                }
            }
        });
    }

    @Override
    public void updateSelectedOperator() {
        this._operatorPanel.update(this._codeEditor.getText(), this.getAltaNode().getName());
    }

    private void editOperator(AltaOperator node) {
        this._operandePanel.setCurrentOperator(this.getAltaNode());
        this._name.setText(node.getName());
        this._name.setEditable(false);
        this.editNode(node);
    }

    @Override
    public void updateLangage() {
        ((TitledBorder)this._operandePanel.getBorder()).setTitle(ResMsgOcas.getString("OPERATOR_EDIT_OPERANDE"));
        this._nameLabel.setText(ResMsgVoc.getString("VOC_NAME") + " : ");
        this._propertiesPanel.updateLangage();
        this._tabPane.setTitleAt(0, ResMsgVoc.getString("VOC_GENERAL"));
        this._tabPane.setTitleAt(1, ResMsgVoc.getString("VOC_PROPERTIES"));
        this._tabPane.setTitleAt(2, ResMsgOcas.getString("MODEL_EDIT_ALTARICA_CODE"));
        this._editorTabPane.setTitleAt(0, ResMsgVoc.getString("VOC_CODE"));
        this._editorTabPane.setTitleAt(1, ResMsgVoc.getString("VOC_OPERATORS"));
        this._operatorPanel.updateLangage();
        super.updateLangage();
    }

    @Override
    protected String getDescription() {
        return this._propertiesPanel.getComment();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        this.updateSelectedOperator();
        this.getAltaNode().setCode(this._codeEditor.getText());
        if (!this.doSave()) {
            return false;
        }
        this._name.setText(this.getAltaNode().getName());
        this._propertiesPanel.updateDBFolder(this.getDBFolder());
        return true;
    }

    public void saveAsOperator() {
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this._operandePanel.isModified()) {
            return true;
        }
        return this._propertiesPanel.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        this._operandePanel.setModified(modified);
        this._propertiesPanel.setModified(modified);
    }

    @Override
    public String toString() {
        return ResMsgVoc.getString("VOC_OPERATOR") + " : " + this.getTitle();
    }

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_OPERATOR");
    }

    @Override
    public boolean toDoWhenClosing() {
        if (!super.toDoWhenClosing()) {
            return false;
        }
        if (!this.verifyClose()) {
            return false;
        }
        new DBFolderThreadClose(this.getDBFolder(), this.getApplication(), this._ctrlClose){

            @Override
            protected void firstDo() {
                super.firstDo();
                AltaEditOperator.this._editorHelper.hideWindow();
            }
        }.realiseDo();
        return true;
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        this.requestFocus();
        this._operandePanel.getLastFocusField().requestFocus();
    }

    @Override
    public void toDoWhenDeActivated() {
        this._editorHelper.hideWindow();
        super.toDoWhenDeActivated();
    }

    @Override
    public boolean isEditable() {
        return !this.isReadOnly();
    }

    @Override
    public void setEditable(boolean etat) {
        super.setEditable(etat);
        this._operandePanel.forReadOnly(this.isReadOnly());
    }

    @Override
    protected GenerateAltaricaCode generateCode() {
        this.updateSelectedOperator();
        this.getAltaNode().setCode(this._codeEditor.getText());
        return super.generateCode();
    }

    @Override
    public IModel getModel(String key) {
        if (key.equals("docbook.file") || key.equals("word.file")) {
            return this.getModel(key, "Operator_");
        }
        return super.getModel(key);
    }

    @Override
    protected void configBook(ExpBook book) {
        XPortCfgOperator xPortCfg = new XPortCfgOperator();
        xPortCfg.configBook(book, this.getAltaNode());
    }

    @Override
    protected void updateEdit() {
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), this.getAltaNode().getLogs());
        if (!this.getAltaNode().update(this.getApplication().getDAOFactory(), logMng)) {
            this._operandePanel.refresh();
        }
        this.getAltaNode().prepareDependTimeUpdt(this.getApplication().getDAOFactory(), this.getAltaNode().getUseRelations());
        this.updateLogs(this.getAltaNode().getUseRelations(), oldLevel, oldNbr);
    }
}

