/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.list.ArrayListModel;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AltaSaveStateConfiguration
extends JDialogCecilia {
    List<String> _configs;
    Plugable _plugable;
    boolean _readOnly;
    JRadioButton _ctrlChoiceDefined;
    JRadioButton _ctrlChoiceLoaded;
    JComboBox _ctrlSelectConfig;
    JTextField _ctrlSelectFile;
    JButton _ctrlFindFile;
    JCheckBox _ctrlOnlyChange;
    JFileChooser _fileChooser;

    public AltaSaveStateConfiguration(Window owner, Plugable plugable, boolean readOnly) {
        super(owner);
        this._plugable = plugable;
        this._readOnly = readOnly;
        this.make();
    }

    protected JFileChooser getFileChooser() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            FileFilterExtention defaultFilter = new FileFilterExtention("Initial config file (*.ini,*.txt)", ".ini;.txt").verifyWrite(true);
            this._fileChooser.addChoosableFileFilter(defaultFilter);
            this._fileChooser.setFileFilter(defaultFilter);
        }
        this._fileChooser.setCurrentDirectory(new File(this._plugable.getOption("plugable.option.path")));
        return this._fileChooser;
    }

    protected void make() {
        this.init();
        JPanel root = new JPanel(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        int line = 0;
        this._ctrlSelectConfig = new JComboBox();
        this._ctrlSelectConfig.setEditable(true);
        this._ctrlSelectConfig.setEnabled(false);
        this._ctrlSelectConfig.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                AltaSaveStateConfiguration.this.valid();
            }
        });
        this._ctrlChoiceDefined = new JRadioButton(ResMsgSimul.getString("SIMUL_SAVE_EDIT_TO_CONFIG"));
        this._ctrlChoiceDefined.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AltaSaveStateConfiguration.this._ctrlSelectConfig.setEnabled(AltaSaveStateConfiguration.this._ctrlChoiceDefined.isSelected());
            }
        });
        group.add(this._ctrlChoiceDefined);
        JPanel panel = new JPanel(new ToggleBorderLayout());
        ToggleBorderLayout.configure(panel, this._ctrlChoiceDefined, this._ctrlSelectConfig);
        root.add((Component)panel, new GridBagConstraints(0, line++, 2, 1, 100.0, 100.0, 10, 1, new Insets(20, 10, 0, 10), 0, 0));
        JPanel loaded = new JPanel(new BorderLayout());
        this._ctrlSelectFile = new JTextField(20);
        this._ctrlSelectFile.setEnabled(false);
        loaded.add((Component)this._ctrlSelectFile, "Center");
        this._ctrlFindFile = new JButton("...");
        this._ctrlFindFile.setEnabled(false);
        this._ctrlFindFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = AltaSaveStateConfiguration.this.getFileChooser();
                if (fc.showSaveDialog(AltaSaveStateConfiguration.this._ctrlSelectFile) == 0) {
                    AltaSaveStateConfiguration.this._plugable.setOption("plugable.option.path", fc.getSelectedFile().getParent());
                    AltaSaveStateConfiguration.this._ctrlSelectFile.setText(FileFilterExtention.addDefaultExtention(fc).getPath());
                }
            }
        });
        loaded.add((Component)this._ctrlFindFile, "East");
        this._ctrlChoiceLoaded = new JRadioButton(ResMsgSimul.getString("SIMUL_SAVE_EDIT_TO_FILE"));
        this._ctrlChoiceLoaded.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AltaSaveStateConfiguration.this._ctrlSelectFile.setEnabled(AltaSaveStateConfiguration.this._ctrlChoiceLoaded.isSelected());
                AltaSaveStateConfiguration.this._ctrlFindFile.setEnabled(AltaSaveStateConfiguration.this._ctrlChoiceLoaded.isSelected());
            }
        });
        group.add(this._ctrlChoiceLoaded);
        JPanel panel2 = new JPanel(new ToggleBorderLayout());
        ToggleBorderLayout.configure(panel2, this._ctrlChoiceLoaded, loaded);
        root.add((Component)panel2, new GridBagConstraints(0, line++, 2, 1, 100.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this._ctrlOnlyChange = new JCheckBox(ResMsgSimul.getString("SIMUL_SAVE_EDIT_ONLY_CHANGE"));
        root.add((Component)this._ctrlOnlyChange, new GridBagConstraints(0, line++, 2, 1, 100.0, 0.0, 10, 1, new Insets(20, 10, 10, 10), 0, 0));
        JPanel buts = new JPanel(new GridLayout(1, 2));
        buts.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AbstractAction okAct = new AbstractAction(ResMsgVoc.getString("VOC_VALIDATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaSaveStateConfiguration.this.valid();
            }
        };
        this._ctrlOK = new JButton(okAct);
        buts.add(this._ctrlOK);
        this.putAction("CECILIA_ENTER", okAct);
        AbstractAction escAct = new AbstractAction(ResMsgVoc.getString("VOC_CANCEL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaSaveStateConfiguration.this.setVisible(false);
            }
        };
        buts.add(new JButton(escAct));
        this.putAction("CECILIA_CANCEL", escAct);
        JPanel panel3 = new JPanel();
        panel3.add(buts);
        root.add((Component)panel3, new GridBagConstraints(0, line++, 2, 1, 100.0, 0.0, 10, 3, new Insets(0, 10, 0, 10), 0, 0));
        if (this._readOnly) {
            this._ctrlChoiceLoaded.setSelected(true);
        } else {
            this._ctrlChoiceDefined.setSelected(true);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(root);
        this.setTitle(ResMsgOcas.getString("OCAS_INIT_STATES"));
        this.setModal(true);
        this.pack();
        Dimension size = this.getSize();
        size.height += 20;
        this.setSize(size);
        this.setResizable(false);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    protected boolean testValid() {
        if (this._ctrlChoiceDefined.isSelected()) {
            int confirm;
            Object configResult = this._ctrlSelectConfig.getSelectedItem();
            if (configResult == null) {
                return false;
            }
            String configName = (String)configResult;
            if (configName.length() == 0) {
                return false;
            }
            return !this._configs.contains(configName) || (confirm = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this._ctrlSelectConfig), ResMsgSimul.getString("SIMUL_SAVE_CONFIG_ALREADY_EXIST_2"), ResMsgOcas.getString("OCAS_INIT_STATES"), 0)) != 1;
        }
        String file = this._ctrlSelectFile.getText();
        return FileUtility.verifyPath((String)file, (boolean)true, (Component)this._ctrlSelectFile, (String)ResMsgOcas.getString("OCAS_INIT_STATES"));
    }

    protected void valid() {
        if (this.testValid()) {
            this._result = true;
            this.setVisible(false);
        }
    }

    public boolean display(List<String> configs, String defaultConfig) {
        this._result = false;
        if (!this._readOnly) {
            boolean change = true;
            if (this._configs != null && this._configs.size() == configs.size()) {
                change = false;
                for (int i = 0; i < configs.size() && !change; ++i) {
                    if (configs.get(i).equals(this._configs.get(i))) continue;
                    change = true;
                }
            }
            if (change) {
                this._configs = new ArrayList<String>(configs);
                this._ctrlSelectConfig.setModel(new ArrayListModel<String>(this._configs));
                if (configs.size() == 1) {
                    this._ctrlSelectConfig.setSelectedIndex(0);
                }
            }
        }
        if (defaultConfig == null) {
            this._ctrlChoiceDefined.setEnabled(false);
            this._ctrlChoiceLoaded.setSelected(true);
        } else {
            this._ctrlChoiceDefined.setEnabled(true);
            this._ctrlSelectConfig.setSelectedItem(defaultConfig);
        }
        this._ctrlOK.requestFocus();
        this.setVisible(true);
        return this._result;
    }

    public boolean isOnlychange() {
        return this._ctrlOnlyChange.isSelected();
    }

    public String getSelectedConfiguration() {
        if (!this._ctrlChoiceDefined.isSelected()) {
            return null;
        }
        Object configResult = this._ctrlSelectConfig.getSelectedItem();
        if (configResult == null) {
            return null;
        }
        String configName = (String)configResult;
        if (configName.length() == 0) {
            return null;
        }
        return configName;
    }

    public String getLoadedConfiguration() {
        if (!this._ctrlChoiceLoaded.isSelected()) {
            return null;
        }
        return new File(this._ctrlSelectFile.getText()).getAbsolutePath();
    }
}

