/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewData;
import com.dassault.cecilia.core.cecilia.stepper.ViewFolder;
import com.dassault.cecilia.core.cecilia.stepper.ViewNode;
import com.dassault.cecilia.core.cecilia.stepper.ViewState;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.AltaStateValueEditor;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.SortFilterModel;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableRendererVarValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AltaStateChange
extends JDialogCecilia {
    TableModelFilterVariable _tableModel;
    JTable _tableCtrl;
    JLabel _lblCurrentNode;
    ViewVariable _select;
    String _value;

    public AltaStateChange(Window owner) {
        super(owner);
        this.make(owner);
    }

    private void make(Window owner) {
        this.init();
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(ResMsgSimul.getString("DLG_STATE_TITLE"));
        JPanel root = new JPanel(new BorderLayout());
        root.add((Component)new JLabel(ResMsgSimul.getString("DLG_STATE_LIST")), "North");
        this._tableModel = new TableModelFilterVariable();
        SortFilterModel sortModel = new SortFilterModel(this._tableModel);
        this._tableCtrl = new JTable(sortModel);
        sortModel.connectTable(this._tableCtrl);
        this._tableCtrl.setSelectionMode(0);
        this._tableCtrl.getColumnModel().getColumn(1).setCellRenderer(new TableRendererVarValue());
        this._tableCtrl.getColumnModel().getColumn(1).setCellEditor(new AltaStateValueEditor());
        JScrollPane scroll = new JScrollPane(this._tableCtrl);
        scroll.setPreferredSize(new Dimension(300, 200));
        root.add((Component)scroll, "Center");
        root.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)root, "Center");
        Box box = Box.createHorizontalBox();
        this._lblCurrentNode = new JLabel();
        this._lblCurrentNode.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        box.add(this._lblCurrentNode);
        this.getContentPane().add((Component)box, "North");
        JPanel panel = new JPanel();
        AbstractAction actionESC = new AbstractAction(ResMsgSimul.getString("DLG_CLOSE")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AltaStateChange.this._select = null;
                AltaStateChange.this.setVisible(false);
            }
        };
        panel.add(new JButton(actionESC));
        this.putAction("CECILIA_ENTER", actionESC);
        this.putAction("CECILIA_CANCEL", actionESC);
        this.getContentPane().add((Component)panel, "South");
        this._tableCtrl.getColumnModel().getColumn(0).setPreferredWidth(4000);
        this._tableCtrl.getColumnModel().getColumn(1).setPreferredWidth(2000);
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean display(SimStepper stepper, String baseFilter) {
        this._select = null;
        this._tableModel.defineModel(stepper, baseFilter);
        this._lblCurrentNode.setText(ResMsgSimul.getString("DLG_SELECT_NAME") + " " + baseFilter);
        if (this._tableModel.getRowCount() > 0) {
            this.setVisible(true);
        }
        this._tableModel.defineModel(null, baseFilter);
        return this._select != null;
    }

    public ViewVariable getSelectVariable() {
        return this._select;
    }

    public String getSelectValue() {
        return this._value;
    }

    class TableModelFilterVariable
    extends AbstractTableModel {
        private List<ViewVariable> _states = new ArrayList<ViewVariable>();
        private String _baseFilter = "";
        private SimStepper _stepper;

        public void defineModel(SimStepper stepper, String baseFilter) {
            this._states.clear();
            this._stepper = stepper;
            this._baseFilter = baseFilter;
            if (this._stepper != null) {
                ViewData data = stepper.findViewData(baseFilter);
                if (data != null && data instanceof ViewFolder) {
                    ViewFolder folder = (ViewFolder)data;
                    for (int i = 0; i < folder.getChildCount(); ++i) {
                        ViewNode child = folder.getChildAt(i);
                        if (!(child instanceof ViewState)) continue;
                        this._states.add((ViewState)child);
                    }
                }
                Collections.sort(this._states, new Comparator<ViewVariable>(){

                    @Override
                    public int compare(ViewVariable o1, ViewVariable o2) {
                        int result = o1.getPath().compareTo(o2.getPath());
                        if (result == 0) {
                            return o1.getName().compareTo(o2.getName());
                        }
                        return result;
                    }
                });
                if (this._baseFilter.length() > 0) {
                    this._baseFilter = this._baseFilter + ".";
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this._states.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ViewVariable var = this._states.get(rowIndex);
            switch (columnIndex) {
                case -2: {
                    return this._stepper;
                }
                case -1: {
                    return var;
                }
                case 0: {
                    return var.getFinalName().substring(this._baseFilter.length());
                }
                case 1: {
                    return var.getSValue();
                }
            }
            return var;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1;
        }

        @Override
        public void setValueAt(Object item, int arg0, int arg1) {
            AltaStateChange.this._select = this._states.get(arg0);
            AltaStateChange.this._value = (String)item;
            AltaStateChange.this.setVisible(false);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public int getColumnWidth(int column) {
            switch (column) {
                case 0: {
                    return 5000;
                }
                case 1: {
                    return 2500;
                }
            }
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgSimul.getString("PAN_STEP_NAME");
                }
                case 1: {
                    return ResMsgSimul.getString("PAN_STEP_VAR_VALUE");
                }
            }
            return "<Error>";
        }

        public Class getColumnClass(int column) {
            switch (column) {
                default: 
            }
            return String.class;
        }
    }
}

