/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.dbobj.mbsa.simul.CentralizedStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.SortFilterModel;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabInfo;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabInfoAccessor;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableModelVariable;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableRendererVarValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class TabListVar
extends TabInfo {
    public static final String STATE = "State";
    public static final String FLOW = "Flow";
    String _type;
    String _code;

    public TabListVar(String code, String type) {
        this._code = code;
        this._type = type;
    }

    @Override
    public String getCode() {
        return this._code;
    }

    @Override
    public String getTitle() {
        if (this._type.equals(FLOW)) {
            return ResMsgSimul.getString("PAN_TITLE_FLOWS");
        }
        return ResMsgSimul.getString("PAN_TITLE_STATES");
    }

    @Override
    public Component createComponent(CentralizedStepper stepper, Map<String, String> config, String prefix) {
        return new Content(stepper);
    }

    class Content
    extends JPanel
    implements TabInfoAccessor {
        public Content(CentralizedStepper stepper) {
            super(new BorderLayout());
            TableModelVariable model = new TableModelVariable(TabListVar.this._type.equals(TabListVar.FLOW) ? 1 : 2);
            stepper.addAltaListener(model);
            model.altaModelChanged(stepper.getSimStepper());
            SortFilterModel sortModel = new SortFilterModel(model);
            JTable table = new JTable(sortModel);
            sortModel.connectTable(table);
            TableColumnModel tabColModel = table.getColumnModel();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                tabColModel.getColumn(i).setPreferredWidth(model.getColumnWidth(i));
            }
            tabColModel.getColumn(1).setCellRenderer(new TableRendererVarValue());
            this.add((Component)new JScrollPane(table), "Center");
        }

        @Override
        public TabInfo getTabInfo() {
            return TabListVar.this;
        }
    }
}

