/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewListener;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableRendererHstInteger;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableRendererHstString;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class TableModelHistory
extends AbstractTableModel
implements ViewListener {
    private static Logger _LOG = Logger.getLogger(TableModelHistory.class.getPackage().getName());
    private SimStepper _stepper = null;
    private int _nbrStep = 0;
    private int _sizeHst = 0;

    protected void setModel(ViewStepper vwStep) {
        if (vwStep != null && vwStep instanceof SimStepper) {
            this._stepper = (SimStepper)vwStep;
            this._nbrStep = this._stepper.getNbrStep();
            this._sizeHst = this._stepper.getViewHisto().size();
        } else {
            this._stepper = null;
            this._nbrStep = 0;
            this._sizeHst = 0;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this._stepper == null) {
            return 0;
        }
        return this._stepper.getViewHisto().size();
    }

    @Override
    public Object getValueAt(int arg0, int column) {
        if (this._stepper == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return arg0 + 1;
            }
            case 1: {
                return this._stepper.getViewHisto().get(arg0).toString();
            }
        }
        return this._stepper.getViewHisto().get(arg0);
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public void setValueAt(Object item, int arg0, int arg1) {
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResMsgSimul.getString("PAN_STEP_IDX");
            }
            case 1: {
                return ResMsgSimul.getString("PAN_STEP_NAME");
            }
        }
        return "<Error>";
    }

    public int getColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 500;
            }
            case 1: {
                return 5000;
            }
        }
        return 1;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public void altaModelChanged(ViewStepper vwStep) {
        this.setModel(vwStep);
    }

    @Override
    public void altaTransitionUpdate(ViewTransition tr) {
    }

    @Override
    public void altaStateUpdate(ViewVariable state) {
    }

    @Override
    public void altaFlowUpdate(ViewVariable flow) {
    }

    @Override
    public void altaOtherUpdate(int type, Object data) {
        if (type == 3) {
            int sizeHst = this._stepper.getViewHisto().size();
            int nbrStep = this._stepper.getNbrStep();
            if (sizeHst > this._sizeHst) {
                if (nbrStep != this._nbrStep + 1) {
                    _LOG.warning("Incoherence dans l'update de la vue historique");
                    this.fireTableDataChanged();
                } else {
                    this.fireTableRowsInserted(this._sizeHst, sizeHst - 1);
                }
            } else {
                if (sizeHst < this._sizeHst) {
                    this.fireTableRowsDeleted(sizeHst, this._sizeHst - 1);
                }
                if (nbrStep < this._nbrStep) {
                    this.fireTableRowsUpdated(nbrStep, this._nbrStep - 1);
                } else {
                    this.fireTableRowsUpdated(this._nbrStep, nbrStep - 1);
                }
            }
            this._sizeHst = sizeHst;
            this._nbrStep = nbrStep;
        }
    }

    public void connectTable(final JTable table) {
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int row = table.rowAtPoint(e.getPoint());
                if (row < TableModelHistory.this._stepper.getNbrStep()) {
                    TableModelHistory.this._stepper.goBackward(TableModelHistory.this._stepper.getNbrStep() - row);
                }
            }
        });
        table.setDefaultRenderer(Integer.class, new TableRendererHstInteger());
        table.setDefaultRenderer(String.class, new TableRendererHstString());
    }
}

