/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.seq;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewEvent;
import com.dassault.cecilia.core.cecilia.stepper.ViewListener;
import com.dassault.cecilia.core.cecilia.stepper.ViewStep;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.SeqNode;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.SeqSet;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.SeqSetModelListener;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.TableRendererSeqInteger;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.TableRendererSeqNode;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.TableRendererSeqString;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SeqSetModelTable
extends AbstractTableModel
implements ViewListener {
    private static Logger _LOG = Logger.getLogger(SeqSetModelTable.class.getPackage().getName());
    private SimStepper _stepper = null;
    private SeqSet _set = null;
    private Set<String> _unknowEvts;
    List<SeqSetModelListener> _listeners = new ArrayList<SeqSetModelListener>();
    private int _seqSelect = -1;
    private JTable _connectTable;

    public SeqSetModelTable() {
        this._unknowEvts = new HashSet<String>();
    }

    protected void setStepper(ViewStepper vwStep) {
        if (vwStep != null && vwStep instanceof SimStepper) {
            this._stepper = (SimStepper)vwStep;
            this.refreshModel();
        } else if (this._stepper != null) {
            this._stepper = null;
            this.fireTableDataChanged();
        }
    }

    private void refreshModel() {
        this._unknowEvts.clear();
        if (this._stepper != null && this._set != null) {
            this._set.plugWithStepper(this._stepper, this._unknowEvts);
            this.changeCurrentSequence();
        }
        for (SeqSetModelListener listener : this._listeners) {
            listener.changeModel();
        }
    }

    public void addViewerModelListener(SeqSetModelListener listener) {
        this._listeners.add(listener);
    }

    public int getSeqNumber() {
        if (this._stepper != null && this._set != null) {
            return this._set.getSeqNumber();
        }
        return 0;
    }

    public int getCurrentSeqNumber() {
        if (this._stepper != null && this._set != null) {
            return this._set.getCurrentSeqNumber();
        }
        return 0;
    }

    public int getSeqErreur() {
        if (this._stepper != null && this._set != null) {
            return this._set.getSeqErreur();
        }
        return 0;
    }

    public int getCurrentSeqErreur() {
        if (this._stepper != null && this._set != null) {
            return this._set.getCurrentSeqErreur();
        }
        return 0;
    }

    protected void setSeqSet(SeqSet set) {
        this._set = set;
        this.refreshModel();
    }

    public Set<String> getUnknowEvents() {
        return this._unknowEvts;
    }

    String[] getCurrentHistory() {
        if (this._stepper == null || this._set == null) {
            return null;
        }
        int nbrStep = this._stepper.getNbrStep();
        String[] seq = new String[nbrStep];
        Iterator<ViewStep> iter = this._stepper.getViewHisto().iterator();
        for (int i = 0; i < nbrStep; ++i) {
            ViewTransition tr = iter.next().getTransition();
            if (tr == null) {
                return null;
            }
            seq[i] = tr.getFinalName();
        }
        return seq;
    }

    @Override
    public int getRowCount() {
        if (this._stepper == null || this._set == null) {
            return 0;
        }
        return this._set.getSeqCount();
    }

    @Override
    public Object getValueAt(int arg0, int column) {
        if (this._stepper == null || this._set == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return this._set.getSeqAt(arg0).getIdx();
            }
            case 1: {
                return this._set.getPrevious();
            }
            case 2: {
                return this._set.getNextAt(arg0);
            }
            case 3: {
                return this._set.getLastAt(arg0);
            }
        }
        return this._set.getSeqAt(arg0);
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public void setValueAt(Object item, int arg0, int arg1) {
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResMsgSimul.getString("PAN_SEQSET_IDX");
            }
            case 1: {
                return ResMsgSimul.getString("PAN_SEQSET_PREVIOUS");
            }
            case 2: {
                return ResMsgSimul.getString("PAN_SEQSET_CURRENT");
            }
            case 3: {
                return ResMsgSimul.getString("PAN_SEQSET_NEXT");
            }
        }
        return "<Error>";
    }

    public int getColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 500;
            }
            case 1: {
                return 2500;
            }
            case 2: {
                return 4000;
            }
            case 3: {
                return 7000;
            }
        }
        return 1;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return SeqNode.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public void altaModelChanged(ViewStepper vwStep) {
        this.setStepper(vwStep);
    }

    @Override
    public void altaTransitionUpdate(ViewTransition tr) {
    }

    @Override
    public void altaStateUpdate(ViewVariable state) {
    }

    @Override
    public void altaFlowUpdate(ViewVariable flow) {
    }

    @Override
    public void altaOtherUpdate(int type, Object data) {
        if (type != 3) {
            return;
        }
        if (this._stepper == null || this._set == null) {
            return;
        }
        this.changeCurrentSequence();
        for (SeqSetModelListener listener : this._listeners) {
            listener.changeState();
        }
    }

    public void connectTable(JTable table) {
        this._connectTable = table;
        this._connectTable.setDefaultRenderer(SeqNode.class, new TableRendererSeqNode());
        this._connectTable.setDefaultRenderer(Integer.class, new TableRendererSeqInteger());
        this._connectTable.setDefaultRenderer(String.class, new TableRendererSeqString());
        this._connectTable.getSelectionModel().setSelectionMode(0);
        this._connectTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                int idx = -1;
                if (!lsm.isSelectionEmpty()) {
                    idx = lsm.getMinSelectionIndex();
                }
                SeqSetModelTable.this._seqSelect = idx;
            }
        });
        this._connectTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() != 32) {
                    return;
                }
                if (SeqSetModelTable.this._seqSelect < 0) {
                    return;
                }
                SeqSetModelTable.this.triggerFollowing(SeqSetModelTable.this._seqSelect, false);
            }
        });
        this._connectTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (SeqSetModelTable.this._seqSelect < 0) {
                    return;
                }
                SeqSetModelTable.this.triggerFollowing(SeqSetModelTable.this._seqSelect, false);
            }
        });
    }

    void changeCurrentSequence() {
        SeqNode nodeSelect = null;
        int idx = this._connectTable.getSelectedRow();
        if (idx != -1) {
            nodeSelect = (SeqNode)this._connectTable.getValueAt(idx, -1);
        }
        this._seqSelect = -1;
        String[] seq = this.getCurrentHistory();
        this._set.defineSelectSeq(seq, this._stepper);
        this.fireTableDataChanged();
        if (nodeSelect != null && nodeSelect.beginWith(seq) && (idx = this._set.indexOf(nodeSelect)) >= 0) {
            this._connectTable.setRowSelectionInterval(idx, idx);
        }
    }

    public boolean isSelectFireable() {
        if (this._stepper == null || this._set == null) {
            return false;
        }
        if (this._seqSelect < 0) {
            return false;
        }
        SeqNode following = this._set.getNextAt(this._seqSelect);
        if (following == null) {
            return false;
        }
        if (following.getNbrFireable() != 1) {
            return false;
        }
        SeqNode seq = this._set.getSeqAt(this._seqSelect);
        return !seq.isError();
    }

    public void fireSelected() {
        this.triggerFollowing(this._seqSelect, true);
    }

    private void triggerFollowing(int idx, boolean trace) {
        if (this._stepper == null || this._set == null) {
            return;
        }
        if (this._seqSelect < 0) {
            return;
        }
        SeqNode following = this._set.getNextAt(idx);
        if (following == null) {
            return;
        }
        if (following.getNbrFireable() != 1) {
            if (trace) {
                _LOG.log(Level.WARNING, "Trigger following sequence with no determinist transition [" + following.getName() + "] Nbr=[" + following.getNbrFireable() + "]");
            }
            return;
        }
        SeqNode seq = this._set.getSeqAt(this._seqSelect);
        if (seq.isError()) {
            _LOG.log(Level.WARNING, "Trigger following sequence with error [" + seq.toString() + "]");
            return;
        }
        ViewEvent evt = this._stepper.getEvent(following.getName());
        for (ViewTransition trans : evt.getTrans()) {
            if (!trans.isValid()) continue;
            this._stepper.goForward(trans);
            break;
        }
    }
}

