/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.io.DBEventsReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimStepper;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.io.DBColorsReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.system.io.DBSystemHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.system.io.DBSystemReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.system.io.config.ConfigParser;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareLinkColorResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareObjWithNameResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.CopyUtility;
import com.dassault.cecilia.lib.util.io.CRCWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AltaSystem
extends AltaEquipment {
    private static Logger _LOG = Logger.getLogger(AltaSystem.class.getPackage().getName());
    List<AltaConfig> _lstConfigs;
    AltaColor _colors = new AltaColor();
    private static final SimpleDateFormat _EXPORT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected AltaSimStepper _stepper;
    AltaConfig _currentConfig;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public AltaSystem(DBFolder dbFolder) {
        super(dbFolder);
        this._lstConfigs = new ArrayList<AltaConfig>();
        this.addConfig(new AltaConfig().setName("Default"));
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.PROJECT;
    }

    @Override
    protected String getNature() {
        return "system.local";
    }

    @Override
    protected String getRelation() {
        return "OA_SYST";
    }

    @Override
    public AltaSystem getCopy() {
        AltaSystem dest = new AltaSystem(this._dbFolder);
        dest.copy(this, (CopyUtility)new CopyUtility.Default());
        return dest;
    }

    protected void copy(AltaSystem src, CopyUtility util) {
        super.copy(src, util);
        List<AltaConfig> lstSrc = src.getConfigs();
        ArrayList<AltaConfig> lstCopy = new ArrayList<AltaConfig>(lstSrc.size());
        for (AltaConfig cfg : lstSrc) {
            AltaConfig cpy = cfg.getCopy(util);
            util.setRef((Object)cfg, (Object)cpy);
            lstCopy.add(cpy);
        }
        this.setConfigs(lstCopy);
        this._colors = new AltaColor(src._colors);
    }

    public List<AltaConfig> getConfigs() {
        return this._lstConfigs;
    }

    public void setConfigs(List<AltaConfig> cfgs) {
        this._lstConfigs = cfgs;
    }

    public AltaConfig getConfig(String name) {
        for (int i = 0; i < this._lstConfigs.size(); ++i) {
            AltaConfig cfg = this._lstConfigs.get(i);
            if (!cfg.getName().equals(name)) continue;
            return cfg;
        }
        return null;
    }

    public boolean addConfig(AltaConfig cfg) {
        if (this.getConfig(cfg.getName()) != null) {
            return false;
        }
        this._lstConfigs.add(cfg);
        return true;
    }

    public AltaColor getColors() {
        return this._colors;
    }

    public void setColors(AltaColor colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this._colors = colors;
    }

    @Override
    protected Set<DBRelation> createRelations(String typeSrc) {
        Set<DBRelation> relations = super.createRelations(typeSrc);
        Iterator<AltaType> iterTypes = this._colors.iteratorTypes();
        while (iterTypes.hasNext()) {
            DBFolder dbFolderColor;
            AltaType type = iterTypes.next();
            if (!(type instanceof DBType) || (dbFolderColor = ((DBType)type).getDBFolder()) == null) continue;
            relations.add(new DBRelation(this._dbFolder, typeSrc, dbFolderColor, "OA_TYPE"));
        }
        return relations;
    }

    @Override
    public String getAltaRicaName() {
        return "main";
    }

    @Override
    protected void writeAltaRicaExtern(Appendable out) throws IOException {
        boolean generate51 = Boolean.getBoolean("cecilia.event.WriteAttributeCecilia51");
        StringBuilder outEvents = new StringBuilder();
        for (AltaEvent event : this._lstSynchro) {
            event.writeAltaRicaExtern(outEvents);
        }
        for (AltaEvent event : this._lstEvent) {
            event.writeAltaRicaExtern(outEvents);
            if (event.getModelLaw() == null) {
                outEvents.append("  attribute DassaultSpecialBTP( <event ").append(event.getName()).append("> ) = \"\";\n");
            }
            if (event.getInspected() != null || event.getInflightTested() != null || generate51) continue;
            outEvents.append("  attribute DassaultSpecialLawModifier( <event ").append(event.getName()).append("> ) = \"\";\n");
        }
        if (outEvents.length() > 0) {
            out.append(" extern\n").append(outEvents.toString());
        }
    }

    public void writeNode(CRCWriter crcOut, AltaConfig config) throws IOException {
        crcOut.append((CharSequence)this.getHeader(false));
        if (config != null) {
            crcOut.append((CharSequence)config.getCode());
        }
        crcOut.append((CharSequence)" assert\n");
        crcOut.append((CharSequence)this.getCode()).append("\n");
        this.writeAltaRicaExtern((Appendable)crcOut);
        crcOut.setUpdate(false);
        crcOut.append((CharSequence)" extern\n");
        if (this.getDBFolder().getParent() != null) {
            crcOut.append((CharSequence)"  nodeproperty projectName = \"");
            crcOut.append((CharSequence)this.getDBFolder().getParent().getName());
            crcOut.append((CharSequence)"\";\n");
        }
        if (this.getDBFolder() != null) {
            crcOut.append((CharSequence)"  nodeproperty projectVersion = \"");
            crcOut.append((CharSequence)this.getDBFolder().getName());
            crcOut.append((CharSequence)"\";\n");
        }
        if (config != null) {
            crcOut.append((CharSequence)"  nodeproperty projectConfig = \"");
            crcOut.append((CharSequence)config.getName());
            crcOut.append((CharSequence)"\";\n");
        }
        crcOut.append((CharSequence)"  nodeproperty currentDate = \"");
        crcOut.append((CharSequence)_EXPORT_DATE_FORMAT.format(new Date()));
        crcOut.append((CharSequence)"\";\n");
        crcOut.setUpdate(true);
        crcOut.append((CharSequence)"edon\n");
    }

    @Override
    protected void doGenerateCode(File file, GenerateAltaricaCode generator) {
        generator.generateSystem(this, file);
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        String indent1 = indent + "  ";
        out.append(indent).append("<").append("cec.mbsa").append(">\n");
        this.toXML_Content(out, indent);
        for (int i = 0; i < this._lstEvent.size(); ++i) {
            ((AltaEvent)this._lstEvent.get(i)).toXMLEvent(out, indent1);
        }
        for (AltaConfig config : this.getConfigs()) {
            config.toXML(out, indent1);
        }
        this._colors.toXML(out, indent1);
        this.toXML_Footer(out, "cec.mbsa", indent);
    }

    @Override
    protected boolean writeModelToDAO(DBObjModel oldModel) {
        DBObjModel newModel = this.writeModel(oldModel);
        if (newModel == null) {
            return false;
        }
        if ("OCAS".equals(oldModel.getFormat())) {
            ArrayList<DBObjModel> models = new ArrayList<DBObjModel>(this._dbFolder.getObject().getModels());
            for (int i = models.size() - 1; i >= 0; --i) {
                DBObjModel current = models.get(i);
                if (!"OCAS".equals(current.getFormat())) continue;
                String nature = current.getNature();
                if (nature.equals("system.local")) {
                    models.remove(i);
                    continue;
                }
                if (nature.equals("system.law")) {
                    models.remove(i);
                    continue;
                }
                if (!nature.startsWith("system.states")) continue;
                models.remove(i);
            }
            models.add(newModel);
            this._dbFolder.getObject().setModels(models);
        } else {
            this._dbFolder.getObject().addModel(newModel);
        }
        return true;
    }

    @Override
    protected DBNodeHandlerXml createHandlerXml(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        return new DBSystemHandlerXml(logMng, null, cecFactory);
    }

    @Override
    protected void copyFromHandlerXml(DBNodeHandlerXml saxHandler, DBLogs.DBLogsManager logMng) {
        AltaColor colors;
        DBSystemHandlerXml xmlHandler = (DBSystemHandlerXml)saxHandler;
        super.copyFromHandlerXml(saxHandler, logMng);
        this.setConfigs(new ArrayList<AltaConfig>(xmlHandler.getConfigs()));
        for (int i = 0; i < this._lstConfigs.size(); ++i) {
            AltaConfig config = this._lstConfigs.get(i);
            config.verify(null, this);
        }
        if (this._lstConfigs.isEmpty()) {
            logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.getString("MSG_XML_CONFIG_NONE"));
            AltaConfig config = new AltaConfig();
            config.setName("Default");
            this.addConfig(config);
        }
        if ((colors = xmlHandler.getColors()) != null) {
            this.setColors(colors);
        }
    }

    @Override
    public boolean readFromDAO(DAOFactory cecFactory) {
        if (!(cecFactory instanceof CECFactory)) {
            _LOG.severe("Le DAOFactory n'est pas un CECFactory");
            return false;
        }
        DBLogs.DBLogsManager logMng = this.createReadLogsManager(cecFactory.getUserLogin());
        if (!this.readLogs(cecFactory)) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_STRUCTURAL"));
            return false;
        }
        DBObjModel model = this.getDefaultObjModel(cecFactory);
        if (model == null) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_STRUCTURAL"));
            return false;
        }
        if (!this.readFromDBObjModel(model, (CECFactory)cecFactory, logMng)) {
            return false;
        }
        if ("OCAS".equals(model.getFormat())) {
            DBObjModel lawmodel = this._dbFolder.getObject().getModel("system.law");
            if (lawmodel != null) {
                new ReaderLawOcas().read(lawmodel, cecFactory, logMng);
            }
            this._lstConfigs = new ArrayList<AltaConfig>();
            for (DBObjModel current : this._dbFolder.getObject().getModels()) {
                if (!current.getNature().startsWith("system.states")) continue;
                new ReaderConfigOcas().read(current, cecFactory, logMng);
            }
            if (this._lstConfigs.isEmpty()) {
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.getString("MSG_XML_CONFIG_NONE"));
                AltaConfig config = new AltaConfig();
                config.setName("Default");
                this.addConfig(config);
            }
            Collections.sort(this._lstConfigs, new Comparator<AltaConfig>(){

                @Override
                public int compare(AltaConfig o1, AltaConfig o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            DBObjModel colormodel = this._dbFolder.getObject().getModel("system.colors");
            if (colormodel != null) {
                new ReaderColorOcas().read(colormodel, cecFactory, logMng);
            }
        }
        this.prepareDependTimeUpdt(cecFactory, null);
        return true;
    }

    @Override
    protected DBNodeReaderRaw createReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        return new DBSystemReaderRaw(dbFolder, logMng);
    }

    public AltaSystem setStepper(AltaSimStepper stepper) {
        this._stepper = stepper;
        return this;
    }

    public AltaSimStepper getStepper() {
        return this._stepper;
    }

    public void setCurrentConfig(AltaConfig config) {
        this._currentConfig = config == null ? null : config.getCopy((CopyUtility)new CopyUtility.Default());
    }

    public AltaConfig getInitialConfiguration() {
        return this._currentConfig;
    }

    @Override
    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = super.update(daoFactory, logMng);
        for (AltaConfig obj : this._lstConfigs) {
            if (obj.update(daoFactory, logMng, this)) continue;
            result = false;
        }
        if (!this._colors.update(daoFactory, logMng)) {
            result = false;
        }
        return result;
    }

    @Override
    public DBComparaisons getCompareConflict(DAOFactory factoryWrap, DBWrap wrap, boolean forImport) {
        DBComparaisons comparaisons = super.getCompareConflict(factoryWrap, wrap, forImport);
        CompareUtils.addConflictInDBWrap(comparaisons, this, wrap, ResMsgVoc.getString("VOC_CONFIGURATIONS"), obj -> ((AltaConfig)obj).getName(), obj -> ((AltaSystem)obj).getConfigs(), CompareObjWithNameResult.class);
        HashSet<AltaType> types = new HashSet<AltaType>();
        types.addAll(this.getColors().getTypes());
        for (AltaType type2 : ((AltaSystem)wrap).getColors().getTypes()) {
            boolean withEquivalent = false;
            for (AltaType type1 : this.getColors().getTypes()) {
                if (!type1.equivalents(type2)) continue;
                withEquivalent = true;
                break;
            }
            if (withEquivalent) continue;
            types.add(type2);
        }
        for (AltaType type : types) {
            comparaisons.addConflict(new CompareLinkColorResult(this, (AltaSystem)wrap, type));
        }
        return comparaisons;
    }

    private class ReaderLawOcas
    extends ReaderModelOcas {
        private ReaderLawOcas() {
        }

        @Override
        protected boolean read(String buffer, CECFactory cecFactory, DBLogs.DBLogsManager logMng) throws IOException {
            DBEventsReaderRaw readerRaw = new DBEventsReaderRaw(AltaSystem.this._dbFolder, logMng);
            if (readerRaw.readRaw(buffer, cecFactory)) {
                AltaSystem.this._lstEvent.clear();
                AltaSystem.this._lstEvent.addAll(readerRaw.getEvents());
                return true;
            }
            return false;
        }
    }

    private class ReaderConfigOcas
    extends ReaderModelOcas {
        String _name;

        private ReaderConfigOcas() {
            this._name = null;
        }

        @Override
        protected boolean verify(DBObjModel model, DAOFactory cecFactory, DBLogs.DBLogsManager logMng) {
            this._name = model.getNature().substring("system.states".length());
            if (this._name.startsWith(".") && this._name.length() > 1) {
                this._name = this._name.substring(1);
            }
            if (AltaSystem.this.getConfig(this._name) != null) {
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_CONFIG_ALREADY", this._name));
                return false;
            }
            return super.verify(model, cecFactory, logMng);
        }

        @Override
        protected boolean read(String buffer, CECFactory cecFactory, DBLogs.DBLogsManager logMng) throws IOException {
            if (buffer.isEmpty()) {
                AltaConfig config = new AltaConfig();
                config.setName(this._name);
                AltaSystem.this.addConfig(config);
                return true;
            }
            ConfigParser parser = new ConfigParser(new StringReader(buffer));
            parser.run();
            Map<String, String> result = parser.getConfig();
            if (result == null) {
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_CONFIG_ERROR", this._name));
                StringBuilder sb = new StringBuilder(512);
                sb.append("Erreur \u00e0 la lecture de la configuration '").append(this._name).append("'");
                sb.append(" pour le dossier '").append(AltaSystem.this._dbFolder.getRefPath()).append("':\n");
                sb.append(parser.getError());
                _LOG.finer(sb.toString());
            } else {
                AltaConfig config = new AltaConfig();
                config.setStates(result);
                config.setName(this._name);
                AltaSystem.this.addConfig(config);
            }
            return result != null;
        }
    }

    private class ReaderColorOcas
    extends ReaderModelOcas {
        private ReaderColorOcas() {
        }

        @Override
        protected boolean read(String buffer, CECFactory cecFactory, DBLogs.DBLogsManager logMng) throws IOException {
            DBColorsReaderRaw readerRaw = new DBColorsReaderRaw(AltaSystem.this._dbFolder, logMng);
            if (readerRaw.readRaw(buffer, cecFactory)) {
                AltaSystem.this._colors.setColors(readerRaw.getColors());
                return true;
            }
            return false;
        }
    }

    private abstract class ReaderModelOcas {
        private ReaderModelOcas() {
        }

        public boolean read(DBObjModel model, DAOFactory cecFactory, DBLogs.DBLogsManager logMng) {
            String format = model.getFormat();
            if ("OCAS".equals(format)) {
                if (!this.verify(model, cecFactory, logMng)) {
                    return false;
                }
                InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
                if (istream == null) {
                    logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                    return false;
                }
                byte[] ibyte = DAOObjModel.convertFromCompressedByte(istream);
                if (ibyte == null) {
                    logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                    return false;
                }
                boolean result = false;
                try {
                    String buffer = null;
                    String encoding = model.getEncoding();
                    if (encoding != null && !encoding.isEmpty()) {
                        if (encoding.equals("ISO-8859-1")) {
                            buffer = new String(ibyte, DBObjModel.getOcasCharset());
                        } else if (encoding.equals("UTF-8")) {
                            buffer = new String(ibyte, StandardCharsets.UTF_8);
                        }
                    }
                    if (buffer == null) {
                        buffer = new String(ibyte);
                    }
                    result = this.read(buffer, (CECFactory)cecFactory, logMng);
                }
                catch (IOException e) {
                    _LOG.log(Level.WARNING, AltaSystem.this._dbFolder.getPathUntilSystem(new StringBuilder("Format de donnees incompatible").append(" : ")).toString(), e);
                }
                return result;
            }
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", AltaSystem.this.getNature(), format));
            return false;
        }

        protected boolean verify(DBObjModel model, DAOFactory cecFactory, DBLogs.DBLogsManager logMng) {
            return true;
        }

        protected abstract boolean read(String var1, CECFactory var2, DBLogs.DBLogsManager var3) throws IOException;
    }
}

