/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEventPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.gui.EditorHelper;
import com.dassault.cecilia.dbobj.mbsa.node.gui.EditorInterface;
import com.dassault.cecilia.dbobj.mbsa.node.gui.HelperLabel;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaModifiedEventTreePanel;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

public class AltaModifiedEventPanel
extends AltaEventPanel
implements EditorInterface {
    private EditorHelper _editorHelper = new EditorHelper(this._eventName, this);
    private AltaModifiedEventTreePanel _treePanel;
    private boolean _blocking = false;

    public AltaModifiedEventPanel(CeciliaAppl appl) {
        super(appl);
    }

    @Override
    protected JComponent createMainPanel() {
        JComponent component = super.createMainPanel();
        this._ctrlTable.getSelectionModel().addListSelectionListener(e -> {
            if (this._blocking) {
                return;
            }
            try {
                this._blocking = true;
                this.refreshSelectedEvents();
            }
            finally {
                this._blocking = false;
            }
        });
        this._treePanel = new AltaModifiedEventTreePanel(this._appl, this);
        JSplitPane splitPane = new JSplitPane(1, this._treePanel, component);
        splitPane.setDividerLocation(150);
        return splitPane;
    }

    protected void refreshSelectedEvents() {
        int[] indexesRowTable = this._ctrlTable.getSelectedRows();
        ArrayList<AltaEvent> events = new ArrayList<AltaEvent>(indexesRowTable.length);
        for (int i = 0; i < indexesRowTable.length; ++i) {
            int indexModel = this._ctrlTable.convertRowIndexToModel(indexesRowTable[i]);
            AltaEvent event = this._ctrlTableModel.getAltaEvent(indexModel);
            events.add(event);
        }
        this._treePanel.updateTree(events);
    }

    @Override
    public AltaSystem getAltaComponent() {
        return (AltaSystem)this._currentComponent;
    }

    @Override
    public void setComponent(AltaComponent currentComponent) {
        super.setComponent(currentComponent);
        if (this._treePanel != null) {
            this._treePanel.setComponent(currentComponent);
        }
    }

    @Override
    public String analyseString(String str, char car, Vector list) {
        if (car != '.') {
            return "";
        }
        AltaSystem equip = this.getAltaComponent();
        String resultString = "";
        AltaSub node = null;
        if (str.indexOf(".") == -1) {
            node = equip.getSub(str);
        } else {
            StringTokenizer stoken = new StringTokenizer(str, ".");
            AltaEquipment current = equip;
            while (stoken.hasMoreTokens() && (node = current.getSub(stoken.nextToken())) != null) {
                if (!(node.getNode() instanceof AltaEquipment)) continue;
                current = (AltaEquipment)node.getNode();
            }
        }
        if (node == null) {
            return "";
        }
        AltaComponent mynode = node.getNode();
        if (mynode instanceof AltaEquipment) {
            AltaEquipment equ = (AltaEquipment)mynode;
            for (AltaSynchro synchro : equ.getSynchros()) {
                UtilOcas.addInAlphabeticOrder(list, new HelperLabel(synchro.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_SYNC"), ""));
            }
            for (AltaSub isub : equ.getSubs()) {
                AltaComponent inode = isub.getNode();
                if (inode instanceof AltaEquipment) {
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(isub.getName(), (Icon)ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_"), inode));
                    continue;
                }
                if (!(inode instanceof AltaComponent)) continue;
                UtilOcas.addInAlphabeticOrder(list, new HelperLabel(isub.getName(), (Icon)ResIcoCore.getImageIcon("FOLDER_COMPONENT_"), inode));
            }
            resultString = mynode.getRefPath();
        } else if (mynode instanceof AltaComponent) {
            for (AltaEvent event : mynode.getEvents()) {
                UtilOcas.addInAlphabeticOrder(list, new HelperLabel(event.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_EVENT"), ""));
            }
            resultString = mynode.getRefPath();
        }
        return resultString;
    }

    @Override
    public String getHelpRoots(Vector list) {
        AltaSystem equip = this.getAltaComponent();
        if (equip != null) {
            for (AltaSub isub : equip.getSubs()) {
                AltaComponent inode = isub.getNode();
                if (inode instanceof AltaComponent) {
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(isub.getName(), (Icon)ResIcoCore.getImageIcon("FOLDER_COMPONENT_"), inode));
                    continue;
                }
                if (!(inode instanceof AltaEquipment)) continue;
                UtilOcas.addInAlphabeticOrder(list, new HelperLabel(isub.getName(), (Icon)ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_"), inode));
            }
        }
        return equip.getRefPath();
    }

    public void hideEditor() {
        this._editorHelper.hideWindow();
    }

    @Override
    protected String validateName(String name) {
        ObjectWithName obj = this.getAltaComponent().findFieldFromPath(name);
        if (obj == null || !(obj instanceof AltaEvent)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._eventName), ResMsgOcas.getString("MSG_ERR_MODIFIED_EVENT_UNKNOWN"), ResMsgOcas.getString("VOC_MODIFIED_EVENTS"), 0);
            return null;
        }
        List<AltaEvent> events = this.getAltaComponent().getEvents();
        for (int i = events.size() - 1; i >= 0; --i) {
            AltaEvent event = events.get(i);
            if (!event.getName().equals(name)) continue;
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._eventName), ResMsgOcas.getString("MSG_ERR_MODIFIED_EVENT_ALREADY"), ResMsgOcas.getString("VOC_MODIFIED_EVENTS"), 0);
            i = this._ctrlTable.convertRowIndexToView(i);
            this._ctrlTable.setRowSelectionInterval(i, i);
            this._ctrlTable.scrollRectToVisible(this._ctrlTable.getCellRect(i, 0, true));
            return null;
        }
        return name;
    }

    @Override
    protected AltaEvent getModelEvent(String name) {
        ObjectWithName obj = this.getAltaComponent().findFieldFromPath(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof AltaEvent) {
            return (AltaEvent)obj;
        }
        return null;
    }

    @Override
    public AltaEvent addEvent() {
        AltaEvent event = super.addEvent();
        if (event == null) {
            return null;
        }
        String namePath = this._eventName.getText();
        this._treePanel.addEventOnMap(event, namePath);
        this._treePanel.updateTree(Collections.singletonList(event));
        return event;
    }

    @Override
    protected void renameEvent(AltaEvent event, String rename) {
        this._treePanel.deleteEventOnMap(event);
        super.renameEvent(event, rename);
        this._treePanel.addEventOnMap(event, rename);
    }

    @Override
    protected List<AltaEvent> deleteEvents() {
        if (this._currentComponent == null) {
            return new ArrayList<AltaEvent>();
        }
        List<AltaEvent> deletedEvents = super.deleteEvents();
        for (AltaEvent evt : deletedEvents) {
            this._treePanel.deleteEventOnMap(evt);
        }
        return deletedEvents;
    }

    public void refreshTree() {
        this.setComponent(this.getAltaComponent());
    }

    public boolean isBlocking() {
        return this._blocking;
    }

    public void setBlocking(boolean blocking) {
        this._blocking = blocking;
    }

    protected AltaEventPanel.EventTable getTable() {
        return this._ctrlTable;
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        if (this.getAltaComponent().isChangeInternalStructure()) {
            this.getAltaComponent().setChangeInternalStructure(false);
            this.refreshTree();
        }
    }
}

