/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class ColorChooser
extends JPanel {
    static Color[][] __predefineColors = new Color[][]{{new Color(255, 128, 128), new Color(255, 255, 128), new Color(128, 255, 128), new Color(0, 255, 128), new Color(128, 255, 255), new Color(0, 128, 255), new Color(255, 128, 192), new Color(255, 128, 255)}, {new Color(255, 0, 0), new Color(255, 255, 0), new Color(128, 255, 0), new Color(0, 255, 64), new Color(0, 255, 255), new Color(0, 128, 192), new Color(128, 128, 192), new Color(255, 0, 255)}, {new Color(128, 64, 64), new Color(255, 128, 64), new Color(0, 255, 0), new Color(0, 128, 128), new Color(0, 65, 128), new Color(128, 128, 255), new Color(128, 0, 64), new Color(255, 0, 128)}, {new Color(128, 0, 0), new Color(255, 128, 0), new Color(0, 128, 0), new Color(0, 128, 64), new Color(0, 0, 255), new Color(0, 0, 160), new Color(128, 0, 128), new Color(128, 0, 255)}, {new Color(64, 0, 0), new Color(128, 64, 0), new Color(0, 64, 0), new Color(0, 64, 64), new Color(0, 0, 128), new Color(0, 0, 64), new Color(64, 0, 64), new Color(64, 0, 128)}, {new Color(0, 0, 0), new Color(128, 128, 0), new Color(128, 128, 64), new Color(128, 128, 128), new Color(64, 128, 128), new Color(192, 192, 192), new Color(128, 192, 192), new Color(255, 255, 255)}};
    static float[] __dashPattern = new float[]{2.0f, 2.0f, 2.0f, 2.0f};
    private static BasicStroke __strokeFocus = new BasicStroke(1.0f, 2, 0, 1.0f, __dashPattern, 2.0f);
    private static BasicStroke __strokeSelect = new BasicStroke(2.0f, 2, 0, 1.0f);
    JTextField _colorCodeTextField;
    static Color __colorBG = new Color(240, 240, 240);
    static Color __color3Da = new Color(160, 160, 160);
    static Color __color3Db = new Color(105, 105, 105);
    static Color __color3Dc = new Color(227, 227, 227);
    static Color __color3Dd = new Color(255, 255, 255);
    static Dimension __colorDimension = new Dimension(50, 50);
    JLabel _lblPredefine;
    JLabel _lblLast;
    Map<Color, ColorButton> _mapPredefineColors = new HashMap<Color, ColorButton>();
    ButtonGroup _buttonGroup = new ButtonGroup();
    Map<Color, ColorButton> _mapLastColors = new HashMap<Color, ColorButton>();
    List<ColorButton> _lstLastColors = new ArrayList<ColorButton>(20);
    int _idxFreeColor = 0;
    int _nbrFreeColor = 0;
    Color _selectedColor = Color.white;
    protected boolean _bEditable;
    ArrayList<ColorListener> _listeners = new ArrayList();

    private String getColorCodeText(Color c) {
        return ResMsgOcas.msgFormat("COLOR_CODE", String.format("%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue()).toUpperCase(), c.getRed(), c.getGreen(), c.getBlue());
    }

    public ColorChooser() {
        super(new GridBagLayout(), true);
        Component but;
        int x;
        int y;
        this.setBackground(__colorBG);
        this._colorCodeTextField = new JTextField(this.getColorCodeText(this._selectedColor));
        this._colorCodeTextField.setBorder(BorderFactory.createEmptyBorder());
        this._colorCodeTextField.setEditable(false);
        this._lblPredefine = new JLabel(ResMsgOcas.getString("VOC_COLOR_DEFINE"));
        this.add((Component)this._lblPredefine, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 7, 2, 0), 0, 0));
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 8; ++x) {
                but = this.createPredefineColorButton(__predefineColors[y][x]);
                this.add(but, new GridBagConstraints(x, y + 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        this.add((Component)new JPanel(), new GridBagConstraints(8, 0, 1, 7, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this._lblLast = new JLabel(ResMsgOcas.getString("VOC_COLOR_LAST"));
        this.add((Component)this._lblLast, new GridBagConstraints(9, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 7, 2, 0), 0, 0));
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 3; ++x) {
                but = this.createLastColorButton();
                this.add(but, new GridBagConstraints(9 + x, y + 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        this.add((Component)this._colorCodeTextField, new GridBagConstraints(4, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 2, 0), 0, 0));
    }

    private Component createPredefineColorButton(Color color) {
        ColorButton result = new ColorButton(color);
        this._buttonGroup.add(result);
        this._mapPredefineColors.put(color, result);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorButton colorBut = (ColorButton)e.getSource();
                ColorChooser.this.setColor(colorBut.getColor(), true, false);
            }
        });
        return result;
    }

    private Component createLastColorButton() {
        Color color = Color.white;
        ColorButton result = new ColorButton(color);
        this._lstLastColors.add(result);
        ++this._nbrFreeColor;
        this._buttonGroup.add(result);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorButton colorBut = (ColorButton)e.getSource();
                ColorChooser.this.setColor(colorBut.getColor(), false, true);
            }
        });
        return result;
    }

    public void setColor(Color color) {
        this.setColor(color, false, false);
    }

    public Color getColor() {
        return this._selectedColor;
    }

    protected ColorButton setLastColor(Color color) {
        ColorButton lastBut = this._mapLastColors.get(color);
        if (lastBut == null) {
            if (this._idxFreeColor >= this._lstLastColors.size()) {
                this._idxFreeColor = 0;
            }
            lastBut = this._lstLastColors.get(this._idxFreeColor++);
            if (this._nbrFreeColor <= 0) {
                Color oldColor = lastBut.getColor();
                this._mapLastColors.remove(oldColor);
            } else {
                --this._nbrFreeColor;
            }
            this._mapLastColors.put(color, lastBut);
            lastBut.setColor(color);
        }
        return lastBut;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.isEnabled();
        super.setEnabled(enabled);
        if (oldEnabled != enabled) {
            this._lblPredefine.setEnabled(enabled);
            for (ColorButton but : this._mapPredefineColors.values()) {
                but.setEnabled(enabled);
            }
            this._lblLast.setEnabled(enabled);
            for (ColorButton but : this._lstLastColors) {
                but.setEnabled(enabled);
            }
            this._colorCodeTextField.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
        this._bEditable = editable;
        for (ColorButton colorButton : this._mapPredefineColors.values()) {
            colorButton.setEditable(editable);
        }
        for (ColorButton colorButton : this._mapLastColors.values()) {
            colorButton.setEditable(editable);
        }
    }

    protected void setColor(Color color, boolean predefine, boolean last) {
        Color oldColor = this._selectedColor;
        if (oldColor != null && color != null && color.equals(oldColor)) {
            return;
        }
        this._colorCodeTextField.setText(this.getColorCodeText(color));
        this._selectedColor = color;
        if (this._selectedColor == null) {
            this._buttonGroup.clearSelection();
            return;
        }
        if (last || predefine) {
            if (!last) {
                this.setLastColor(color);
            }
            this.fireChangeColor(color);
            return;
        }
        ColorButton preDefineBut = this._mapPredefineColors.get(color);
        ColorButton lastBut = this.setLastColor(color);
        if (preDefineBut != null) {
            preDefineBut.setSelected(true);
        } else {
            lastBut.setSelected(true);
        }
    }

    public void addColorListener(ColorListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeColorListener(ColorListener l) {
        this._listeners.remove(l);
    }

    private void fireChangeColor(Color color) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).change(color);
        }
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        frm.setDefaultCloseOperation(3);
        final ColorChooser colorChooser = new ColorChooser();
        final JCheckBox enableCheck = new JCheckBox("Disable color");
        enableCheck.setSelected(false);
        enableCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                colorChooser.setEnabled(!enableCheck.isSelected());
            }
        });
        final JCheckBox editableCheck = new JCheckBox("Editable color");
        editableCheck.setSelected(true);
        editableCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                colorChooser.setEditable(editableCheck.isSelected());
            }
        });
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(enableCheck);
        panel.add(editableCheck);
        frm.getContentPane().add((Component)panel, "North");
        frm.getContentPane().add((Component)colorChooser, "Center");
        frm.pack();
        frm.setLocationRelativeTo(null);
        frm.setVisible(true);
    }

    class ColorButton
    extends JToggleButton {
        Color _color;
        boolean _butEditable;
        ActionListener __disabledAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooser.this._colorCodeTextField.setText(ColorChooser.this.getColorCodeText(ColorButton.this._color));
            }
        };
        ActionListener[] _enabledActions;

        ColorButton(Color color) {
            this._color = color;
            this.setBackground(color);
            this.setOpaque(false);
            this._butEditable = true;
        }

        public void setColor(Color color) {
            if (this._color.equals(color)) {
                return;
            }
            this._color = color;
            this.repaint();
        }

        public void setEditable(boolean editable) {
            if (this._butEditable == editable) {
                return;
            }
            if (this._butEditable) {
                this._enabledActions = this.getActionListeners();
                for (int i = this._enabledActions.length - 1; i >= 0; --i) {
                    this.removeActionListener(this._enabledActions[i]);
                }
                this.addActionListener(this.__disabledAction);
            } else {
                this.removeActionListener(this.__disabledAction);
                for (int i = this._enabledActions.length - 1; i >= 0; --i) {
                    this.addActionListener(this._enabledActions[i]);
                }
            }
            this._butEditable = editable;
        }

        public Color getColor() {
            return this._color;
        }

        @Override
        public Dimension getPreferredSize() {
            return __colorDimension;
        }

        @Override
        public Dimension getMinimumSize() {
            return __colorDimension;
        }

        @Override
        public Dimension getMaximumSize() {
            return __colorDimension;
        }

        @Override
        public void paint(Graphics g) {
            int y2;
            int x2;
            int y1;
            int x1;
            int w = this.getSize().width;
            int h = this.getSize().height;
            int m = 5;
            Graphics2D g2 = (Graphics2D)g;
            Color oldColor = g2.getColor();
            Stroke oldStroke = g2.getStroke();
            Object oldAntiAliassing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            boolean enabled = this.isEnabled();
            if (this.hasFocus() && !enabled) {
                g2.setStroke(__strokeFocus);
                g2.setColor(Color.black);
                g2.drawRect(m, m, w - 2 * m, h - 2 * m);
            }
            m += 2;
            if (this.isSelected() && enabled) {
                g2.setColor(Color.black);
                g2.drawRect(m, m, w - 2 * m - 1, h - 2 * m - 1);
            }
            g2.setColor(enabled ? this._color : __color3Dc);
            g2.fillRect(m += 3, m, w - 2 * m + 1, h - 2 * m + 1);
            if (enabled) {
                x1 = m;
                y1 = m;
                x2 = w - m;
                y2 = h - m;
                g2.setColor(__color3Da);
                g2.drawLine(x1 - 2, y1 - 2, x2 + 1, y1 - 2);
                g2.drawLine(x1 - 2, y1 - 2, x1 - 2, y2 + 1);
                g2.setColor(__color3Db);
                g2.drawLine(x1 - 1, y1 - 1, x2 + 0, y1 - 1);
                g2.drawLine(x1 - 1, y1 - 1, x1 - 1, y2 + 0);
                g2.setColor(__color3Dc);
                g2.drawLine(x2 + 0, y2 + 0, x1 - 1, y2 + 0);
                g2.drawLine(x2 + 0, y2 + 0, x2 + 0, y1 - 1);
                g2.setColor(__color3Dd);
                g2.drawLine(x2 + 1, y2 + 1, x1 - 2, y2 + 1);
                g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y1 - 2);
            }
            if (this.isSelected() && enabled) {
                x1 = m;
                y1 = m;
                x2 = w - m;
                y2 = h - m;
                if ((this._color.getRed() * 299 + this._color.getGreen() * 587 + this._color.getBlue() * 144) / 1000 < 125) {
                    g2.setColor(Color.white);
                } else {
                    g2.setColor(Color.black);
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(__strokeSelect);
                g2.drawLine(x1, y1, x2, y2);
                g2.drawLine(x1, y2, x2, y1);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAliassing);
            g2.setStroke(oldStroke);
            g2.setColor(oldColor);
        }
    }

    public static interface ColorListener {
        public void change(Color var1);
    }
}

