/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.io;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.DBEquipmentReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.io.AltaFileHeader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;

public class DBSystemReaderRaw
extends DBEquipmentReaderRaw {
    public DBSystemReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        super(dbFolder, logMng);
    }

    @Override
    public boolean readRaw(String data, CECFactory cecFactory) throws IOException {
        String line;
        BufferedReader inData = new BufferedReader(new StringReader(data));
        while ((line = inData.readLine()) != null) {
            int position = line.indexOf("<");
            if (position == -1) continue;
            if (line.indexOf("<header") != -1) {
                this._properties = AltaFileHeader.loadFromFile(inData);
                continue;
            }
            if (line.indexOf("<sheet") != -1) {
                this.readSheet(line);
                continue;
            }
            if (line.indexOf("<architecture") == 0) {
                this.readContent(inData, line, "/architecture", cecFactory);
                continue;
            }
            if (line.indexOf("<event_properties ") == 0) {
                this.readEventProperties(inData, line, cecFactory);
                continue;
            }
            this.logMsg(Level.WARNING, "Internal warning (where am I ?): " + line);
            break;
        }
        if (this._properties == null) {
            this._properties = new AltaFileHeader();
        }
        if (this._code == null) {
            this._code = "";
        }
        return true;
    }

    @Override
    protected AltaEvent getOrCreateEvent(String name) {
        AltaEvent event = (AltaEvent)this._mapEvents.get(name);
        if (event == null) {
            event = new AltaEvent(name);
            this._mapEvents.put(name, event);
        }
        return event;
    }
}

