/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DBRecordField {
    private String _name;
    private AltaType _type;
    long _id = -1L;
    private Direction _direction = Direction.NORMAL;
    private String _crossField = "";
    private ViewVariable _simulVar = null;
    private boolean _fieldToDisplay;

    public DBRecordField(String name, AltaType type) {
        this._name = name;
        this._type = type;
        this._fieldToDisplay = false;
    }

    public DBRecordField getCopy() {
        DBRecordField copy = new DBRecordField(this._name, this._type.getCopy());
        copy.setDirection(this._direction);
        copy.setCrossField(this._crossField);
        copy.setLinkToDisplay(this.isLinkToDisplay());
        copy.setID(this.getID());
        return copy;
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBRecordField)) {
            return false;
        }
        DBRecordField other = (DBRecordField)obj;
        if (!other.getName().equals(this._name)) {
            return false;
        }
        if (!other.getType().equals(this._type)) {
            return false;
        }
        if (other.getDirection() != this._direction) {
            return false;
        }
        return other.getCrossField().equals(this._crossField);
    }

    public int hashCode() {
        int hash = this._name.hashCode();
        if (this._crossField.length() > 0) {
            hash = 7 * hash + this._crossField.hashCode();
        }
        hash = 5 * hash + this._type.hashCode();
        hash = 3 * hash + this._direction.hashCode();
        return hash;
    }

    public String getName() {
        return this._name;
    }

    public DBRecordField setName(String name) {
        this._name = name;
        return this;
    }

    public AltaType getType() {
        return this._type;
    }

    public DBRecordField setType(AltaType type) {
        this._type = type;
        return this;
    }

    public long getID() {
        return this._id;
    }

    public DBRecordField setID(long id) {
        this._id = id;
        return this;
    }

    public Direction getDirection() {
        return this._direction;
    }

    public DBRecordField setDirection(Direction direction) {
        this._direction = direction;
        return this;
    }

    public String getCrossField() {
        return this._crossField;
    }

    public DBRecordField setCrossField(String crossFieldName) {
        this._crossField = crossFieldName;
        return this;
    }

    public ViewVariable getSimulVar() {
        return this._simulVar;
    }

    public DBRecordField setSimulVar(ViewVariable var) {
        this._simulVar = var;
        return this;
    }

    public boolean canBeCrossWith(DBRecordField crossField) {
        return crossField != this && this.getType().equivalents(crossField.getType());
    }

    public boolean isLinkToDisplay() {
        return this._fieldToDisplay;
    }

    public void setLinkToDisplay(boolean toDisplay) {
        this._fieldToDisplay = toDisplay;
    }

    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_TYPE"), this._type.getAbstract()));
        sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_SENS"), this._direction.getLabel()));
        sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_CROSS"), this._crossField));
        return sb.toString();
    }

    public static enum Direction {
        NORMAL(ResMsgVoc.getString("VOC_NORMAL")),
        INVERSE(ResMsgVoc.getString("VOC_INVERSE"));

        String _label;

        private Direction(String label) {
            this._label = label;
        }

        public String getLabel() {
            return this._label;
        }

        public static class SpecificListCellRenderer
        extends DefaultListCellRenderer {
            public SpecificListCellRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Direction) {
                    this.setText(((Direction)((Object)value)).getLabel());
                }
                return this;
            }
        }

        public static class SpecificTableCellRenderer
        extends DefaultTableCellRenderer {
            public SpecificTableCellRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Direction) {
                    this.setText(((Direction)((Object)value)).getLabel());
                }
                return this;
            }
        }
    }
}

